/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world;

import com.dev7ex.common.collect.map.ParsedMap;
import com.dev7ex.common.io.file.configuration.Configuration;
import com.dev7ex.common.io.file.configuration.ConfigurationHolder;
import com.dev7ex.common.io.file.configuration.ConfigurationProperties;
import com.dev7ex.common.io.file.configuration.JsonConfiguration;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldConfiguration;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import com.dev7ex.multiworld.api.world.WorldDefaultProperty;
import com.dev7ex.multiworld.api.world.WorldFlag;
import com.dev7ex.multiworld.api.world.WorldHolder;
import com.dev7ex.multiworld.api.world.WorldProperty;
import com.dev7ex.multiworld.api.world.WorldType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

@ConfigurationProperties(fileName="world.json", provider=JsonConfiguration.class)
public class DefaultWorldConfiguration
extends Configuration
implements BukkitWorldConfiguration {
    private final ParsedMap<WorldDefaultProperty, Object> defaultProperties;

    public DefaultWorldConfiguration(@NotNull MultiWorldPlugin plugin) {
        super((ConfigurationHolder)plugin);
        this.defaultProperties = plugin.getConfiguration().getDefaultProperties();
    }

    @Override
    public void add(@NotNull BukkitWorldHolder worldHolder) {
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.CREATOR_NAME.getStoragePath(), (Object)worldHolder.getCreatorName());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.CREATION_TIMESTAMP.getStoragePath(), (Object)worldHolder.getCreationTimeStamp());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.AUTO_LOAD_ENABLED.getStoragePath(), (Object)worldHolder.isAutoLoadEnabled());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.AUTO_UNLOAD_ENABLED.getStoragePath(), (Object)worldHolder.isAutoUnloadEnabled());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.DIFFICULTY.getStoragePath(), (Object)worldHolder.getDifficulty().toString());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.END_PORTAL_ACCESSIBLE.getStoragePath(), (Object)worldHolder.isEndPortalAccessible());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.GAME_MODE.getStoragePath(), (Object)worldHolder.getGameMode().toString());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.FORCE_GAME_MODE.getStoragePath(), (Object)worldHolder.getForceGameMode());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.HUNGER_ENABLED.getStoragePath(), (Object)worldHolder.isHungerEnabled());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.KEEP_SPAWN_IN_MEMORY.getStoragePath(), (Object)worldHolder.isKeepSpawnInMemory());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.NETHER_PORTAL_ACCESSIBLE.getStoragePath(), (Object)worldHolder.isNetherPortalAccessible());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.PVP_ENABLED.getStoragePath(), (Object)worldHolder.isPvpEnabled());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.RECEIVE_ACHIEVEMENTS.getStoragePath(), (Object)worldHolder.isReceiveAchievements());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.REDSTONE_ENABLED.getStoragePath(), (Object)worldHolder.isRedstoneEnabled());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.SPAWN_ANIMALS.getStoragePath(), (Object)worldHolder.isSpawnAnimals());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.SPAWN_MONSTERS.getStoragePath(), (Object)worldHolder.isSpawnMonsters());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.SPAWN_ENTITIES.getStoragePath(), (Object)worldHolder.isSpawnEntities());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.WEATHER_ENABLED.getStoragePath(), (Object)worldHolder.isWeatherEnabled());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.ENVIRONMENT.getStoragePath(), (Object)worldHolder.getEnvironment().toString());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.GENERATOR.getStoragePath(), (Object)worldHolder.getGenerator());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.TYPE.getStoragePath(), (Object)worldHolder.getType().toString());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.LINKED_END_WORLD.getStoragePath(), (Object)worldHolder.getEndWorldName());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.LINKED_NETHER_WORLD.getStoragePath(), (Object)worldHolder.getNetherWorldName());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.LINKED_OVERWORLD.getStoragePath(), (Object)worldHolder.getNormalWorldName());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.WHITELIST.getStoragePath(), Collections.emptyList());
        super.getFileConfiguration().set(worldHolder.getName() + "." + WorldProperty.WHITELIST_ENABLED.getStoragePath(), (Object)worldHolder.isWhitelistEnabled());
        super.saveFile();
    }

    @Override
    public void remove(@NotNull BukkitWorldHolder worldHolder) {
        this.remove(worldHolder.getName());
    }

    @Override
    public void remove(@NotNull String name) {
        super.getFileConfiguration().set(name, null);
        super.saveFile();
    }

    @Override
    public boolean contains(@NotNull String name) {
        return super.getFileConfiguration().contains(name);
    }

    @Override
    public Object getValue(@NotNull WorldHolder worldHolder, @NotNull WorldProperty property) {
        return super.getFileConfiguration().get(worldHolder.getName() + "." + property.getStoragePath());
    }

    @Override
    public boolean hasProperty(@NotNull String name, @NotNull WorldProperty property) {
        return super.getFileConfiguration().contains(name + "." + property.getStoragePath());
    }

    @Override
    public void addMissingProperty(@NotNull BukkitWorldHolder worldHolder, @NotNull WorldProperty property) {
        switch (property) {
            case AUTO_LOAD_ENABLED: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getString((Object)WorldDefaultProperty.AUTO_LOAD_ENABLED));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case AUTO_UNLOAD_ENABLED: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getString((Object)WorldDefaultProperty.AUTO_UNLOAD_ENABLED));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case CREATION_TIMESTAMP: {
                this.write(worldHolder, property, (Object)System.currentTimeMillis());
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case CREATOR_NAME: {
                this.write(worldHolder, property, (Object)"CONSOLE");
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case DIFFICULTY: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getString((Object)WorldDefaultProperty.DIFFICULTY));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case END_PORTAL_ACCESSIBLE: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.END_PORTAL_ACCESSIBLE));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case ENVIRONMENT: {
                break;
            }
            case GAME_MODE: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getString((Object)WorldDefaultProperty.GAME_MODE));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case FORCE_GAME_MODE: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getString((Object)WorldDefaultProperty.FORCE_GAME_MODE));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case GENERATOR: {
                break;
            }
            case HUNGER_ENABLED: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.HUNGER_ENABLED));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case KEEP_SPAWN_IN_MEMORY: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.KEEP_SPAWN_IN_MEMORY));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case LINKED_END_WORLD: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getString((Object)WorldDefaultProperty.END_WORLD));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case LINKED_NETHER_WORLD: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getString((Object)WorldDefaultProperty.NETHER_WORLD));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case LINKED_OVERWORLD: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getString((Object)WorldDefaultProperty.NORMAL_WORLD));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case NETHER_PORTAL_ACCESSIBLE: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.NETHER_PORTAL_ACCESSIBLE));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case PVP_ENABLED: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.PVP_ENABLED));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case RECEIVE_ACHIEVEMENTS: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.RECEIVE_ACHIEVEMENTS));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case REDSTONE_ENABLED: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.REDSTONE_ENABLED));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case SPAWN_ANIMALS: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ANIMALS));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case SPAWN_ENTITIES: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ENTITIES));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case SPAWN_MONSTERS: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_MONSTERS));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case TYPE: {
                break;
            }
            case WEATHER_ENABLED: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.WEATHER_ENABLED));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
                break;
            }
            case WHITELIST_ENABLED: {
                this.write(worldHolder, property, (Object)this.defaultProperties.getBoolean((Object)WorldDefaultProperty.WHITELIST_ENABLED));
                MultiWorldPlugin.getInstance().getLogger().info("Adding Missing Property [" + property.name() + "] to " + worldHolder.getName());
            }
        }
    }

    public void removeUnusableProperties(@NotNull String worldName) {
        if (super.getFileConfiguration().getSection(worldName) == null) {
            return;
        }
        for (String property : super.getFileConfiguration().getSection(worldName).getKeys()) {
            if (WorldProperty.fromStoragePath(property).isPresent()) continue;
            super.getFileConfiguration().set(worldName + "." + property, null);
        }
        super.saveFile();
    }

    @Override
    public void updateFlag(@NotNull BukkitWorldHolder worldHolder, @NotNull WorldFlag worldFlag, @NotNull String value) {
        if ((value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) && worldFlag != WorldFlag.FORCE_GAME_MODE) {
            super.getFileConfiguration().set(worldHolder.getName() + "." + worldFlag.getStoragePath(), (Object)Boolean.valueOf(value));
        } else {
            super.getFileConfiguration().set(worldHolder.getName() + "." + worldFlag.getStoragePath(), (Object)value);
        }
        super.saveFile();
    }

    @Override
    public void write(@NotNull BukkitWorldHolder worldHolder, @NotNull ParsedMap<WorldProperty, Object> worldData) {
        for (WorldProperty property : worldData.keySet()) {
            switch (property) {
                case CREATOR_NAME: 
                case DIFFICULTY: 
                case ENVIRONMENT: 
                case GAME_MODE: 
                case FORCE_GAME_MODE: 
                case GENERATOR: 
                case LINKED_END_WORLD: 
                case LINKED_NETHER_WORLD: 
                case LINKED_OVERWORLD: 
                case TYPE: {
                    super.getFileConfiguration().set(worldHolder.getName() + "." + property.getStoragePath(), (Object)worldData.getString((Object)property));
                    break;
                }
                case CREATION_TIMESTAMP: {
                    super.getFileConfiguration().set(worldHolder.getName() + "." + property.getStoragePath(), (Object)worldData.getLong((Object)property));
                    break;
                }
                case AUTO_LOAD_ENABLED: 
                case AUTO_UNLOAD_ENABLED: 
                case END_PORTAL_ACCESSIBLE: 
                case HUNGER_ENABLED: 
                case KEEP_SPAWN_IN_MEMORY: 
                case NETHER_PORTAL_ACCESSIBLE: 
                case PVP_ENABLED: 
                case RECEIVE_ACHIEVEMENTS: 
                case REDSTONE_ENABLED: 
                case SPAWN_ANIMALS: 
                case SPAWN_ENTITIES: 
                case SPAWN_MONSTERS: 
                case WHITELIST_ENABLED: {
                    super.getFileConfiguration().set(worldHolder.getName() + "." + property.getStoragePath(), (Object)worldData.getBoolean((Object)property));
                    break;
                }
                case WHITELIST: {
                    super.getFileConfiguration().set(worldHolder.getName() + "." + property.getStoragePath(), (Object)worldData.getStringList((Object)property));
                }
            }
        }
        super.saveFile();
    }

    @Override
    public void write(@NotNull BukkitWorldHolder worldHolder, @NotNull WorldProperty property, @NotNull Object value) {
        String path = worldHolder.getName() + "." + property.getStoragePath();
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            super.getFileConfiguration().set(path, (Object)booleanValue);
        } else if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("false")) {
                super.getFileConfiguration().set(path, (Object)Boolean.parseBoolean(stringValue));
            } else {
                super.getFileConfiguration().set(path, (Object)stringValue);
            }
        } else {
            super.getFileConfiguration().set(path, value);
        }
        super.saveFile();
    }

    @Override
    public BukkitWorldHolder getWorldHolder(@NotNull String name) {
        return BukkitWorldHolder.builder().setName(name).setCreatorName(super.getFileConfiguration().getString(name + "." + WorldProperty.CREATOR_NAME.getStoragePath())).setCreationTimeStamp(super.getFileConfiguration().getLong(name + "." + WorldProperty.CREATION_TIMESTAMP.getStoragePath())).setAutoLoadEnabled(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.AUTO_LOAD_ENABLED.getStoragePath())).setAutoUnloadEnabled(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.AUTO_UNLOAD_ENABLED.getStoragePath())).setDifficulty(Difficulty.valueOf((String)super.getFileConfiguration().getString(name + "." + WorldProperty.DIFFICULTY.getStoragePath()))).setEndPortalAccessible(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.END_PORTAL_ACCESSIBLE.getStoragePath(), true)).setGameMode(GameMode.valueOf((String)super.getFileConfiguration().getString(name + "." + WorldProperty.GAME_MODE.getStoragePath()))).setForceGameMode(super.getFileConfiguration().getString(name + "." + WorldProperty.FORCE_GAME_MODE.getStoragePath())).setHungerEnabled(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.HUNGER_ENABLED.getStoragePath())).setKeepSpawnInMemory(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.KEEP_SPAWN_IN_MEMORY.getStoragePath())).setNetherPortalAccessible(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.NETHER_PORTAL_ACCESSIBLE.getStoragePath(), true)).setPvpEnabled(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.PVP_ENABLED.getStoragePath(), true)).setReceiveAchievements(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.RECEIVE_ACHIEVEMENTS.getStoragePath())).setRedstoneEnabled(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.REDSTONE_ENABLED.getStoragePath())).setSpawnAnimals(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.SPAWN_ANIMALS.getStoragePath())).setSpawnMonsters(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.SPAWN_MONSTERS.getStoragePath())).setSpawnEntities(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.SPAWN_ENTITIES.getStoragePath())).setWeatherEnabled(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.WEATHER_ENABLED.getStoragePath())).setEnvironment(World.Environment.valueOf((String)super.getFileConfiguration().getString(name + "." + WorldProperty.ENVIRONMENT.getStoragePath()))).setGenerator(super.getFileConfiguration().getString(name + "." + WorldProperty.GENERATOR.getStoragePath())).setType(WorldType.fromString(super.getFileConfiguration().getString(name + "." + WorldProperty.TYPE.getStoragePath())).orElseThrow()).setEndWorldName(super.getFileConfiguration().getString(name + "." + WorldProperty.LINKED_END_WORLD.getStoragePath())).setNetherWorldName(super.getFileConfiguration().getString(name + "." + WorldProperty.LINKED_NETHER_WORLD.getStoragePath())).setNormalWorldName(super.getFileConfiguration().getString(name + "." + WorldProperty.LINKED_OVERWORLD.getStoragePath())).setWhitelist(super.getFileConfiguration().getStringList(name + "." + WorldProperty.WHITELIST.getStoragePath())).setWhitelistEnabled(super.getFileConfiguration().getBoolean(name + "." + WorldProperty.WHITELIST_ENABLED.getStoragePath())).build();
    }

    @Override
    public Map<String, BukkitWorldHolder> getWorldHolders() {
        HashMap<String, BukkitWorldHolder> worlds = new HashMap<String, BukkitWorldHolder>();
        for (String entry : super.getFileConfiguration().getKeys()) {
            worlds.put(entry, this.getWorldHolder(entry));
        }
        return worlds;
    }
}

