/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world;

import com.dev7ex.common.bukkit.BukkitCommon;
import com.dev7ex.common.collect.map.ParsedMap;
import com.dev7ex.common.io.file.Files;
import com.dev7ex.multiworld.MultiWorldConfiguration;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.event.world.WorldCloneEvent;
import com.dev7ex.multiworld.api.bukkit.event.world.WorldCreateEvent;
import com.dev7ex.multiworld.api.bukkit.event.world.WorldDeleteEvent;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldEnvironment;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldManager;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldProvider;
import com.dev7ex.multiworld.api.bukkit.world.generator.defaults.FlatWorldGenerator;
import com.dev7ex.multiworld.api.bukkit.world.generator.defaults.VoidWorldGenerator;
import com.dev7ex.multiworld.api.bukkit.world.generator.defaults.WaterWorldGenerator;
import com.dev7ex.multiworld.api.world.WorldDefaultProperty;
import com.dev7ex.multiworld.api.world.WorldEnvironment;
import com.dev7ex.multiworld.api.world.WorldType;
import com.dev7ex.multiworld.translation.DefaultTranslationProvider;
import com.dev7ex.multiworld.world.DefaultWorldConfiguration;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Level;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DefaultWorldManager
implements BukkitWorldManager {
    private final DefaultWorldConfiguration configuration;
    private final MultiWorldConfiguration pluginConfiguration;
    private final DefaultTranslationProvider translationProvider;

    public DefaultWorldManager(@NotNull DefaultWorldConfiguration configuration, @NotNull MultiWorldConfiguration pluginConfiguration, @NotNull DefaultTranslationProvider translationProvider) {
        this.configuration = configuration;
        this.pluginConfiguration = pluginConfiguration;
        this.translationProvider = translationProvider;
    }

    @Override
    public void cloneWorld(@NotNull String creatorName, @NotNull String name, @NotNull String clonedName) {
        File sourceFolder = new File(Bukkit.getWorldContainer(), name);
        File destinationFolder = new File(Bukkit.getWorldContainer(), clonedName);
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        BukkitWorldHolder worldHolder = (BukkitWorldHolder)this.getProvider().getWorldHolder(name).orElseThrow();
        WorldCloneEvent event = new WorldCloneEvent(worldHolder, commandSender, clonedName, sourceFolder, destinationFolder);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.clone.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        try {
            File sessionFile = new File(sourceFolder, "session.lock");
            if (sessionFile.exists()) {
                boolean bl = sessionFile.delete();
            }
            FileUtils.copyDirectory((File)sourceFolder, (File)destinationFolder);
            for (File file : Files.getFiles((File)destinationFolder)) {
                if (!file.isFile() || !file.getName().equalsIgnoreCase("uid.dat")) continue;
                file.delete();
            }
            BukkitWorldHolder clonedWorldHolder = worldHolder.clone();
            clonedWorldHolder.setName(clonedName);
            clonedWorldHolder.setCreationTimeStamp(System.currentTimeMillis());
            this.configuration.add(clonedWorldHolder);
            this.getProvider().register(clonedWorldHolder);
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.clone.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name).replaceAll("%cloned_world_name%", clonedName));
        }
        catch (IOException exception) {
            commandSender.sendMessage("\u00a7cAn error has occurred. View the logs");
            MultiWorldPlugin.getInstance().getLogger().log(Level.SEVERE, "\u00a7cAn error has occurred. View the logs", exception);
        }
    }

    @Override
    public void createBackup(@NotNull String creatorName, @NotNull String name) {
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        File sourceFolder = new File(Bukkit.getWorldContainer(), name);
        File destinationFolder = new File(MultiWorldPlugin.getInstance().getSubFolder("backup"), name + "-" + new SimpleDateFormat("MM-dd-yyyy-HH-mm-ss").format(Calendar.getInstance().getTime()));
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.backup.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        try {
            File sessionFile = new File(sourceFolder, "session.lock");
            if (sessionFile.exists()) {
                sessionFile.delete();
            }
            FileUtils.copyDirectory((File)sourceFolder, (File)destinationFolder);
            for (File file : Files.getFiles((File)destinationFolder)) {
                if (!file.isFile() || !file.getName().equalsIgnoreCase("uid.dat")) continue;
                file.delete();
            }
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.backup.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        }
        catch (IOException exception) {
            commandSender.sendMessage("\u00a7cAn error has occurred. View the logs");
            MultiWorldPlugin.getInstance().getLogger().log(Level.SEVERE, "\u00a7cAn error has occurred. View the logs", exception);
        }
    }

    @Override
    public void createWorld(@NotNull String creatorName, @NotNull String name, @NotNull WorldType type) {
        WorldCreator worldCreator = new WorldCreator(name);
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        switch (type) {
            case THE_END: {
                worldCreator.environment(World.Environment.THE_END);
                break;
            }
            case NETHER: {
                worldCreator.environment(World.Environment.NETHER);
                break;
            }
            default: {
                worldCreator.type(org.bukkit.WorldType.NORMAL);
            }
        }
        ParsedMap<WorldDefaultProperty, Object> defaultProperties = this.pluginConfiguration.getDefaultProperties();
        BukkitWorldHolder worldHolder = BukkitWorldHolder.builder().setName(name).setCreatorName(commandSender.getName()).setCreationTimeStamp(System.currentTimeMillis()).setAutoLoadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_LOAD_ENABLED)).setAutoUnloadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_UNLOAD_ENABLED)).setDifficulty(Difficulty.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.DIFFICULTY))).setEndPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.END_PORTAL_ACCESSIBLE)).setGameMode(GameMode.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.GAME_MODE))).setForceGameMode(defaultProperties.getString((Object)WorldDefaultProperty.FORCE_GAME_MODE)).setHungerEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.HUNGER_ENABLED)).setKeepSpawnInMemory(defaultProperties.getBoolean((Object)WorldDefaultProperty.KEEP_SPAWN_IN_MEMORY)).setNetherPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.NETHER_PORTAL_ACCESSIBLE)).setPvpEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.PVP_ENABLED)).setReceiveAchievements(defaultProperties.getBoolean((Object)WorldDefaultProperty.RECEIVE_ACHIEVEMENTS)).setRedstoneEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.REDSTONE_ENABLED)).setSpawnAnimals(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ANIMALS)).setSpawnMonsters(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_MONSTERS)).setSpawnEntities(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ENTITIES)).setWeatherEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WEATHER_ENABLED)).setEnvironment(BukkitWorldEnvironment.from(WorldEnvironment.fromType(type))).setGenerator("NONE").setType(type).setEndWorldName(defaultProperties.getString((Object)WorldDefaultProperty.END_WORLD)).setNetherWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NETHER_WORLD)).setNormalWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NORMAL_WORLD)).setWhitelist(new ArrayList<String>()).setWhitelistEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WHITELIST_ENABLED)).build();
        WorldCreateEvent event = new WorldCreateEvent(worldHolder, commandSender);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.create.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        World world = worldCreator.createWorld();
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.create.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        world.setDifficulty(worldHolder.getDifficulty());
        world.setSpawnFlags(worldHolder.isSpawnMonsters(), worldHolder.isSpawnAnimals());
        worldHolder.setLoadTimeStamp(System.currentTimeMillis());
        worldHolder.setLoaded(true);
        this.configuration.add(worldHolder);
        this.getProvider().register(worldHolder);
    }

    @Override
    public void createWorld(@NotNull String creatorName, @NotNull String name, @NotNull WorldEnvironment environment, long seed) {
        WorldCreator worldCreator = new WorldCreator(name);
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        worldCreator.environment(BukkitWorldEnvironment.from(environment));
        worldCreator.seed(seed);
        ParsedMap<WorldDefaultProperty, Object> defaultProperties = this.pluginConfiguration.getDefaultProperties();
        BukkitWorldHolder worldHolder = BukkitWorldHolder.builder().setName(name).setCreatorName(commandSender.getName()).setCreationTimeStamp(System.currentTimeMillis()).setAutoLoadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_LOAD_ENABLED)).setAutoUnloadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_UNLOAD_ENABLED)).setDifficulty(Difficulty.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.DIFFICULTY))).setEndPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.END_PORTAL_ACCESSIBLE)).setGameMode(GameMode.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.GAME_MODE))).setForceGameMode(defaultProperties.getString((Object)WorldDefaultProperty.FORCE_GAME_MODE)).setHungerEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.HUNGER_ENABLED)).setKeepSpawnInMemory(defaultProperties.getBoolean((Object)WorldDefaultProperty.KEEP_SPAWN_IN_MEMORY)).setNetherPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.NETHER_PORTAL_ACCESSIBLE)).setPvpEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.PVP_ENABLED)).setReceiveAchievements(defaultProperties.getBoolean((Object)WorldDefaultProperty.RECEIVE_ACHIEVEMENTS)).setRedstoneEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.REDSTONE_ENABLED)).setSpawnAnimals(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ANIMALS)).setSpawnMonsters(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_MONSTERS)).setSpawnEntities(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ENTITIES)).setWeatherEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WEATHER_ENABLED)).setEnvironment(BukkitWorldEnvironment.from(WorldEnvironment.fromType(WorldType.CUSTOM))).setGenerator("NONE").setType(WorldType.CUSTOM).setEndWorldName(defaultProperties.getString((Object)WorldDefaultProperty.END_WORLD)).setNetherWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NETHER_WORLD)).setNormalWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NORMAL_WORLD)).setWhitelist(new ArrayList<String>()).setWhitelistEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WHITELIST_ENABLED)).build();
        WorldCreateEvent event = new WorldCreateEvent(worldHolder, commandSender);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.create.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        World world = worldCreator.createWorld();
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.create.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        world.setDifficulty(worldHolder.getDifficulty());
        world.setSpawnFlags(worldHolder.isSpawnMonsters(), worldHolder.isSpawnAnimals());
        worldHolder.setLoadTimeStamp(System.currentTimeMillis());
        worldHolder.setLoaded(true);
        this.configuration.add(worldHolder);
        this.getProvider().register(worldHolder);
    }

    @Override
    public void createWorld(@NotNull String creatorName, @NotNull String name, @NotNull WorldEnvironment environment, @NotNull String generator) {
        WorldCreator worldCreator = new WorldCreator(name);
        ParsedMap<WorldDefaultProperty, Object> defaultProperties = this.pluginConfiguration.getDefaultProperties();
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        if (BukkitWorldEnvironment.from(environment) != World.Environment.CUSTOM) {
            worldCreator.environment(BukkitWorldEnvironment.from(environment));
        }
        switch (generator) {
            case "FlatWorldGenerator": {
                worldCreator.generator((ChunkGenerator)new FlatWorldGenerator((Plugin)MultiWorldPlugin.getInstance()));
                break;
            }
            case "VoidWorldGenerator": {
                worldCreator.generator((ChunkGenerator)new VoidWorldGenerator((Plugin)MultiWorldPlugin.getInstance()));
                break;
            }
            case "WaterWorldGenerator": {
                worldCreator.generator((ChunkGenerator)new WaterWorldGenerator((Plugin)MultiWorldPlugin.getInstance()));
                break;
            }
            default: {
                worldCreator.generator(generator);
            }
        }
        BukkitWorldHolder worldHolder = BukkitWorldHolder.builder().setName(name).setCreatorName(commandSender.getName()).setCreationTimeStamp(System.currentTimeMillis()).setAutoLoadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_LOAD_ENABLED)).setAutoUnloadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_UNLOAD_ENABLED)).setDifficulty(Difficulty.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.DIFFICULTY))).setEndPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.END_PORTAL_ACCESSIBLE)).setGameMode(GameMode.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.GAME_MODE))).setForceGameMode(defaultProperties.getString((Object)WorldDefaultProperty.FORCE_GAME_MODE)).setHungerEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.HUNGER_ENABLED)).setKeepSpawnInMemory(defaultProperties.getBoolean((Object)WorldDefaultProperty.KEEP_SPAWN_IN_MEMORY)).setNetherPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.NETHER_PORTAL_ACCESSIBLE)).setPvpEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.PVP_ENABLED)).setReceiveAchievements(defaultProperties.getBoolean((Object)WorldDefaultProperty.RECEIVE_ACHIEVEMENTS)).setRedstoneEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.REDSTONE_ENABLED)).setSpawnAnimals(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ANIMALS)).setSpawnMonsters(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_MONSTERS)).setSpawnEntities(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ENTITIES)).setWeatherEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WEATHER_ENABLED)).setEnvironment(BukkitWorldEnvironment.from(WorldEnvironment.fromType(WorldType.CUSTOM))).setGenerator(generator).setType(WorldType.CUSTOM).setEndWorldName(defaultProperties.getString((Object)WorldDefaultProperty.END_WORLD)).setNetherWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NETHER_WORLD)).setNormalWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NORMAL_WORLD)).setWhitelist(new ArrayList<String>()).setWhitelistEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WHITELIST_ENABLED)).build();
        WorldCreateEvent event = new WorldCreateEvent(worldHolder, commandSender);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.create.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        World world = worldCreator.createWorld();
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.create.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        world.setDifficulty(worldHolder.getDifficulty());
        world.setSpawnFlags(worldHolder.isSpawnMonsters(), worldHolder.isSpawnAnimals());
        worldHolder.setLoadTimeStamp(System.currentTimeMillis());
        worldHolder.setLoaded(true);
        this.configuration.add(worldHolder);
        this.getProvider().register(worldHolder);
    }

    @Override
    public void deleteWorld(@NotNull String creatorName, @NotNull String name) {
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        BukkitWorldHolder worldHolder = (BukkitWorldHolder)this.getProvider().getWorldHolder(name).orElseThrow();
        WorldDeleteEvent event = new WorldDeleteEvent(worldHolder, commandSender);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.delete.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        if (worldHolder.isLoaded()) {
            this.unloadWorld(creatorName, name);
        }
        try {
            FileUtils.deleteDirectory((File)new File(String.valueOf(Bukkit.getWorldContainer()) + File.separator + name));
        }
        catch (IOException exception) {
            commandSender.sendMessage("\u00a7cAn error has occurred. View the logs");
            exception.printStackTrace();
            return;
        }
        this.configuration.remove(name);
        this.getProvider().unregister(name);
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.delete.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
    }

    @Override
    public void importWorld(@NotNull String creatorName, @NotNull String name, @NotNull WorldEnvironment environment, @NotNull String generator) {
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        ParsedMap<WorldDefaultProperty, Object> defaultProperties = this.pluginConfiguration.getDefaultProperties();
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.import.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        BukkitWorldHolder worldHolder = BukkitWorldHolder.builder().setName(name).setCreatorName(commandSender.getName()).setCreationTimeStamp(System.currentTimeMillis()).setAutoLoadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_LOAD_ENABLED)).setAutoUnloadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_UNLOAD_ENABLED)).setDifficulty(Difficulty.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.DIFFICULTY))).setEndPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.END_PORTAL_ACCESSIBLE)).setGameMode(GameMode.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.GAME_MODE))).setForceGameMode(defaultProperties.getString((Object)WorldDefaultProperty.FORCE_GAME_MODE)).setHungerEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.HUNGER_ENABLED)).setKeepSpawnInMemory(defaultProperties.getBoolean((Object)WorldDefaultProperty.KEEP_SPAWN_IN_MEMORY)).setNetherPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.NETHER_PORTAL_ACCESSIBLE)).setPvpEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.PVP_ENABLED)).setReceiveAchievements(defaultProperties.getBoolean((Object)WorldDefaultProperty.RECEIVE_ACHIEVEMENTS)).setRedstoneEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.REDSTONE_ENABLED)).setSpawnAnimals(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ANIMALS)).setSpawnMonsters(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_MONSTERS)).setSpawnEntities(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ENTITIES)).setWeatherEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WEATHER_ENABLED)).setEnvironment(BukkitWorldEnvironment.from(WorldEnvironment.fromType(WorldType.CUSTOM))).setGenerator(generator).setType(WorldType.CUSTOM).setEndWorldName(defaultProperties.getString((Object)WorldDefaultProperty.END_WORLD)).setNetherWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NETHER_WORLD)).setNormalWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NORMAL_WORLD)).setWhitelist(Collections.emptyList()).setWhitelistEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WHITELIST_ENABLED)).build();
        this.configuration.add(worldHolder);
        this.getProvider().register(worldHolder);
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.import.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
    }

    @Override
    public void importWorld(@NotNull String creatorName, @NotNull String name, @NotNull WorldEnvironment environment, @NotNull WorldType type) {
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.import.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        ParsedMap<WorldDefaultProperty, Object> defaultProperties = this.pluginConfiguration.getDefaultProperties();
        BukkitWorldHolder worldHolder = BukkitWorldHolder.builder().setName(name).setCreatorName(commandSender.getName()).setCreationTimeStamp(System.currentTimeMillis()).setAutoLoadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_LOAD_ENABLED)).setAutoUnloadEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.AUTO_UNLOAD_ENABLED)).setDifficulty(Difficulty.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.DIFFICULTY))).setEndPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.END_PORTAL_ACCESSIBLE)).setGameMode(GameMode.valueOf((String)defaultProperties.getString((Object)WorldDefaultProperty.GAME_MODE))).setForceGameMode(defaultProperties.getString((Object)WorldDefaultProperty.FORCE_GAME_MODE)).setHungerEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.HUNGER_ENABLED)).setKeepSpawnInMemory(defaultProperties.getBoolean((Object)WorldDefaultProperty.KEEP_SPAWN_IN_MEMORY)).setNetherPortalAccessible(defaultProperties.getBoolean((Object)WorldDefaultProperty.NETHER_PORTAL_ACCESSIBLE)).setPvpEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.PVP_ENABLED)).setReceiveAchievements(defaultProperties.getBoolean((Object)WorldDefaultProperty.RECEIVE_ACHIEVEMENTS)).setRedstoneEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.REDSTONE_ENABLED)).setSpawnAnimals(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ANIMALS)).setSpawnMonsters(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_MONSTERS)).setSpawnEntities(defaultProperties.getBoolean((Object)WorldDefaultProperty.SPAWN_ENTITIES)).setWeatherEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WEATHER_ENABLED)).setEnvironment(BukkitWorldEnvironment.from(WorldEnvironment.fromType(type))).setGenerator("NONE").setType(type).setEndWorldName(defaultProperties.getString((Object)WorldDefaultProperty.END_WORLD)).setNetherWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NETHER_WORLD)).setNormalWorldName(defaultProperties.getString((Object)WorldDefaultProperty.NORMAL_WORLD)).setWhitelist(Collections.emptyList()).setWhitelistEnabled(defaultProperties.getBoolean((Object)WorldDefaultProperty.WHITELIST_ENABLED)).build();
        this.configuration.add(worldHolder);
        this.getProvider().register(worldHolder);
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.import.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
    }

    @Override
    public void loadWorld(@NotNull String creatorName, @NotNull String name) {
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        BukkitWorldHolder worldHolder = (BukkitWorldHolder)this.getProvider().getWorldHolder(name).orElseThrow();
        File worldFolder = new File(Bukkit.getWorldContainer(), worldHolder.getName());
        WorldCreator worldCreator = new WorldCreator(name);
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.load.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        if (worldHolder.getGenerator() != null && !worldHolder.getGenerator().equalsIgnoreCase("NONE")) {
            switch (worldHolder.getGenerator()) {
                case "FlatWorldGenerator": {
                    worldCreator.generator((ChunkGenerator)new FlatWorldGenerator((Plugin)MultiWorldPlugin.getInstance()));
                    break;
                }
                case "VoidWorldGenerator": {
                    worldCreator.generator((ChunkGenerator)new VoidWorldGenerator((Plugin)MultiWorldPlugin.getInstance()));
                    break;
                }
                default: {
                    worldCreator.generator(worldHolder.getGenerator());
                }
            }
        }
        if (!MultiWorldPlugin.getInstance().getWorldGeneratorProvider().isRegistered(worldHolder.getGenerator()) && !worldHolder.getGenerator().equalsIgnoreCase("NONE")) {
            commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.load.error-missing-generator").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name).replaceAll("%generator_name%", worldHolder.getGenerator()));
            return;
        }
        switch (worldHolder.getType()) {
            case THE_END: {
                worldCreator.environment(World.Environment.THE_END);
                break;
            }
            case NETHER: {
                worldCreator.environment(World.Environment.NETHER);
                break;
            }
            case NORMAL: 
            case CUSTOM: {
                worldCreator.environment(World.Environment.NORMAL);
            }
        }
        World world = Bukkit.createWorld((WorldCreator)worldCreator);
        Objects.requireNonNull(world).setDifficulty(worldHolder.getDifficulty());
        world.setSpawnFlags(worldHolder.isSpawnMonsters(), worldHolder.isSpawnAnimals());
        worldHolder.setLoadTimeStamp(System.currentTimeMillis());
        worldHolder.setLoaded(true);
        this.getProvider().register(worldHolder);
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.load.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
    }

    @Override
    public void unloadWorld(@NotNull String creatorName, @NotNull String name) {
        CommandSender commandSender = BukkitCommon.getCommandSender((String)creatorName);
        World world = Objects.requireNonNull(Bukkit.getWorld((String)name));
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().getName().equalsIgnoreCase(name)) continue;
            player.sendMessage(this.translationProvider.getMessage((CommandSender)player, "commands.world.unload.chunk-teleport").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name).replaceAll("%unloader_name%", creatorName));
            player.teleport(Objects.requireNonNull(Bukkit.getWorld((String)MultiWorldPlugin.getInstance().getConfiguration().getString("settings.defaults.normal-world"))).getSpawnLocation());
        }
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.unload.chunk-starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        Arrays.stream(world.getLoadedChunks()).forEach(Chunk::unload);
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.unload.chunk-finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.unload.starting").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
        Bukkit.unloadWorld((String)world.getName(), (boolean)true);
        ((BukkitWorldHolder)this.getProvider().getWorldHolder(name).orElseThrow()).setLoaded(false);
        commandSender.sendMessage(this.translationProvider.getMessage(commandSender, "commands.world.unload.finished").replaceAll("%prefix%", this.pluginConfiguration.getPrefix()).replaceAll("%world_name%", name));
    }

    public BukkitWorldProvider getProvider() {
        return MultiWorldPlugin.getInstance().getWorldProvider();
    }

    @Generated
    public DefaultWorldConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public MultiWorldConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    @Generated
    public DefaultTranslationProvider getTranslationProvider() {
        return this.translationProvider;
    }
}

