/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world;

import com.dev7ex.common.bukkit.plugin.module.PluginModule;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.event.plugin.MultiWorldStartupCompleteEvent;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldHolder;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldProvider;
import com.dev7ex.multiworld.api.bukkit.world.BukkitWorldType;
import com.dev7ex.multiworld.api.world.WorldEnvironment;
import com.dev7ex.multiworld.api.world.WorldProperty;
import com.dev7ex.multiworld.api.world.WorldType;
import com.dev7ex.multiworld.world.DefaultWorldConfiguration;
import com.dev7ex.multiworld.world.DefaultWorldManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class DefaultWorldProvider
implements PluginModule,
BukkitWorldProvider {
    private final Map<String, BukkitWorldHolder> worldHolders = new HashMap<String, BukkitWorldHolder>();
    private final DefaultWorldManager worldManager;
    private final DefaultWorldConfiguration configuration;

    public DefaultWorldProvider(@NotNull DefaultWorldManager worldManager, @NotNull DefaultWorldConfiguration configuration) {
        this.worldManager = worldManager;
        this.configuration = configuration;
    }

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        for (World world : Bukkit.getWorlds()) {
            if (this.configuration.contains(world.getName())) continue;
            WorldType worldType = BukkitWorldType.fromEnvironment(world.getEnvironment());
            this.worldManager.importWorld(Bukkit.getConsoleSender().getName(), world.getName(), WorldEnvironment.fromType(worldType), worldType);
        }
        for (String worldEntry : this.configuration.getWorldHolders().keySet()) {
            BukkitWorldHolder worldHolder = this.configuration.getWorldHolder(worldEntry);
            for (WorldProperty property : WorldProperty.values()) {
                if (this.configuration.hasProperty(worldEntry, property)) continue;
                this.configuration.addMissingProperty(worldHolder, property);
            }
            if (Bukkit.getWorld((String)worldEntry) != null) {
                World world = worldHolder.getWorld();
                world.setDifficulty(worldHolder.getDifficulty());
                world.setSpawnFlags(worldHolder.isSpawnMonsters(), worldHolder.isSpawnMonsters());
                worldHolder.setLoaded(true);
            }
            this.register(worldHolder);
        }
        for (BukkitWorldHolder worldHolder : MultiWorldPlugin.getInstance().getWorldProvider().getWorldHolders().values()) {
            if (!worldHolder.isAutoLoadEnabled()) continue;
            this.worldManager.loadWorld(Bukkit.getConsoleSender().getName(), worldHolder.getName());
        }
        MultiWorldPlugin.getInstance().getLogger().info("Found: [" + this.worldHolders.size() + "] Worlds");
        Bukkit.getPluginManager().callEvent((Event)new MultiWorldStartupCompleteEvent(MultiWorldPlugin.getInstance(), System.currentTimeMillis() - startTime));
    }

    public void onDisable() {
        this.worldHolders.clear();
    }

    @Override
    public void register(@NotNull BukkitWorldHolder worldHolder) {
        this.worldHolders.put(worldHolder.getName(), worldHolder);
    }

    @Override
    public void unregister(@NotNull String name) {
        this.worldHolders.remove(name);
    }

    @Override
    public boolean isRegistered(@NotNull String name) {
        return this.worldHolders.containsKey(name);
    }

    @Override
    public Optional<BukkitWorldHolder> getWorldHolder(@NotNull String name) {
        return Optional.ofNullable(this.worldHolders.get(name));
    }

    @Override
    public BukkitWorldHolder getDefaultWorldHolder() {
        return this.getWorldHolder(MultiWorldPlugin.getInstance().getConfiguration().getString("settings.defaults.normal-world")).orElseThrow();
    }

    @Override
    @Generated
    public Map<String, BukkitWorldHolder> getWorldHolders() {
        return this.worldHolders;
    }

    @Generated
    public DefaultWorldManager getWorldManager() {
        return this.worldManager;
    }

    @Generated
    public DefaultWorldConfiguration getConfiguration() {
        return this.configuration;
    }
}

