/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world.generator;

import com.dev7ex.common.bukkit.plugin.module.PluginModule;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.api.bukkit.world.generator.BukkitWorldGenerator;
import com.dev7ex.multiworld.api.bukkit.world.generator.BukkitWorldGeneratorHolder;
import com.dev7ex.multiworld.api.bukkit.world.generator.BukkitWorldGeneratorProvider;
import com.dev7ex.multiworld.api.bukkit.world.generator.defaults.FlatWorldGenerator;
import com.dev7ex.multiworld.api.bukkit.world.generator.defaults.VoidWorldGenerator;
import com.dev7ex.multiworld.api.bukkit.world.generator.defaults.WaterWorldGenerator;
import com.dev7ex.multiworld.api.world.generator.WorldGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DefaultWorldGeneratorProvider
implements PluginModule,
BukkitWorldGeneratorProvider {
    private final Map<BukkitWorldGeneratorHolder, String> customGenerators = new HashMap<BukkitWorldGeneratorHolder, String>();
    private final List<BukkitWorldGenerator> defaultGenerators = new ArrayList<BukkitWorldGenerator>();
    private final Map<BukkitWorldGeneratorHolder, WorldGenerator> fileGenerators = new HashMap<BukkitWorldGeneratorHolder, WorldGenerator>();

    public void onEnable() {
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            block4: {
                if (!plugin.isEnabled()) continue;
                try {
                    if (plugin.getDefaultWorldGenerator("world", "") == null) {
                    }
                    break block4;
                }
                catch (Exception exception) {
                    MultiWorldPlugin.getInstance().getLogger().severe(plugin.getName() + " could not be loaded");
                }
                continue;
            }
            this.customGenerators.put(new BukkitWorldGeneratorHolder(plugin), plugin.getDescription().getName());
        }
        this.defaultGenerators.add(new FlatWorldGenerator((Plugin)MultiWorldPlugin.getInstance()));
        this.defaultGenerators.add(new VoidWorldGenerator((Plugin)MultiWorldPlugin.getInstance()));
        this.defaultGenerators.add(new WaterWorldGenerator((Plugin)MultiWorldPlugin.getInstance()));
        MultiWorldPlugin.getInstance().getLogger().info("Found: [" + this.customGenerators.values().size() + "] World Generator");
    }

    public void onDisable() {
        this.customGenerators.clear();
        this.defaultGenerators.clear();
        this.fileGenerators.clear();
    }

    @Override
    public boolean isRegistered(String generator) {
        return this.customGenerators.containsValue(generator) || this.defaultGenerators.stream().anyMatch(generator1 -> generator1.getName().equalsIgnoreCase(generator));
    }

    @Override
    public List<String> getAllGenerators() {
        ArrayList<String> allGenerators = new ArrayList<String>();
        allGenerators.addAll(this.customGenerators.values());
        allGenerators.addAll(this.defaultGenerators.stream().map(WorldGenerator::getName).toList());
        allGenerators.addAll(this.fileGenerators.values().stream().map(WorldGenerator::getName).toList());
        return allGenerators;
    }

    @Override
    @Generated
    public Map<BukkitWorldGeneratorHolder, String> getCustomGenerators() {
        return this.customGenerators;
    }

    @Override
    @Generated
    public List<BukkitWorldGenerator> getDefaultGenerators() {
        return this.defaultGenerators;
    }

    @Override
    @Generated
    public Map<BukkitWorldGeneratorHolder, WorldGenerator> getFileGenerators() {
        return this.fileGenerators;
    }
}

