/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import me.gabij.multiplebedspawn.commands.NameCommand;
import me.gabij.multiplebedspawn.commands.RemoveCommand;
import me.gabij.multiplebedspawn.commands.RespawnMenuCommand;
import me.gabij.multiplebedspawn.commands.ShareCommand;
import me.gabij.multiplebedspawn.listeners.PlayerGetsOnBedListener;
import me.gabij.multiplebedspawn.listeners.PlayerJoinListener;
import me.gabij.multiplebedspawn.listeners.PlayerRespawnListener;
import me.gabij.multiplebedspawn.listeners.RemoveMenuHandler;
import me.gabij.multiplebedspawn.listeners.RespawnMenuHandler;
import me.gabij.multiplebedspawn.utils.CommandMapUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MultipleBedSpawn
extends JavaPlugin {
    private Configuration messages;
    private static MultipleBedSpawn instance;

    public void onEnable() {
        instance = this;
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.createLanguageConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerRespawnListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RespawnMenuHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RemoveMenuHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerGetsOnBedListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        try {
            CommandMap commandMap = CommandMapUtil.getCommandMap();
            commandMap.register(this.getName(), (Command)new RespawnMenuCommand(this, "respawnbed"));
            commandMap.register(this.getName(), (Command)new NameCommand(this, "renamebed"));
            if (this.getConfig().getBoolean("remove-beds-gui")) {
                commandMap.register(this.getName(), (Command)new RemoveCommand(this, "removebed"));
            }
            if (this.getConfig().getBoolean("bed-sharing")) {
                commandMap.register(this.getName(), (Command)new ShareCommand(this, "sharebed"));
            }
            this.getLogger().info("Commands added successfully");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.getLogger().warning("Could not access commandMap. Commands will not work");
            this.getLogger().warning(e.getMessage());
        }
    }

    public static MultipleBedSpawn getInstance() {
        return instance;
    }

    public String getMessages(String path) {
        return this.messages.getString(path);
    }

    private void createLanguageConfig() {
        String lang = this.getConfig().getString("lang");
        try {
            InputStream input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("languages/{key}.yml".replace("{key}", lang));
            this.messages = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(input));
        }
        catch (Exception e) {
            InputStream input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("languages/enUS.yml");
            this.messages = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(input));
        }
    }
}

