/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn.commands;

import java.util.ArrayList;
import me.gabij.multiplebedspawn.MultipleBedSpawn;
import me.gabij.multiplebedspawn.models.BedData;
import me.gabij.multiplebedspawn.models.BedsDataType;
import me.gabij.multiplebedspawn.models.PlayerBedsData;
import me.gabij.multiplebedspawn.utils.BedsUtils;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class NameCommand
extends BukkitCommand {
    static MultipleBedSpawn plugin;

    public NameCommand(MultipleBedSpawn plugin, String name) {
        super(name);
        NameCommand.plugin = plugin;
        this.description = "Changes the name of the bed you are looking at";
        this.usageMessage = "/renamebed <name of the bed>";
        this.setAliases(new ArrayList());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean execute(CommandSender sender, String alias, String[] args) {
        if (!(sender instanceof Player)) return true;
        Object name = "";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            name = (String)name + arg + " ";
            ++n2;
        }
        Player p = (Player)sender;
        Block bed = BedsUtils.checkIfIsBed(p.getTargetBlockExact(4));
        if (bed == null) {
            p.sendMessage(String.valueOf(ChatColor.RED) + plugin.getMessages("bed-not-found-message"));
            return false;
        }
        BlockState blockState = bed.getState();
        String bedUUID = null;
        if (blockState instanceof TileState) {
            TileState tileState = (TileState)blockState;
            PersistentDataContainer container = tileState.getPersistentDataContainer();
            if (container.has(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING)) {
                bedUUID = (String)container.get(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING);
            }
            tileState.update();
        }
        if (bedUUID == null) {
            p.sendMessage(String.valueOf(ChatColor.RED) + plugin.getMessages("bed-not-registered-message"));
            return false;
        }
        PlayerBedsData playerBedsData = null;
        PersistentDataContainer playerData = p.getPersistentDataContainer();
        if (!playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())) return true;
        playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType());
        if (playerBedsData != null && playerBedsData.getPlayerBedData() != null && playerBedsData.hasBed(bedUUID)) {
            BedData bedData = playerBedsData.getPlayerBedData().get(bedUUID);
            bedData.setBedName((String)name);
            playerData.set(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType(), (Object)playerBedsData);
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.getMessages("bed-name-registered-successfully-message")));
            return true;
        }
        p.sendMessage(String.valueOf(ChatColor.RED) + plugin.getMessages("bed-not-registered-message"));
        return false;
    }
}

