/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn.commands;

import java.util.ArrayList;
import me.gabij.multiplebedspawn.MultipleBedSpawn;
import me.gabij.multiplebedspawn.models.BedsDataType;
import me.gabij.multiplebedspawn.models.PlayerBedsData;
import me.gabij.multiplebedspawn.utils.BedsUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ShareCommand
extends BukkitCommand {
    static MultipleBedSpawn plugin;

    public ShareCommand(MultipleBedSpawn plugin, String name) {
        super(name);
        ShareCommand.plugin = plugin;
        this.description = "Gives bed to another player";
        this.usageMessage = "/sharebed <player>";
        this.setAliases(new ArrayList());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean execute(CommandSender sender, String alias, String[] args) {
        TileState tileState;
        PersistentDataContainer container;
        if (args.length != 1) {
            return false;
        }
        if (!(sender instanceof Player)) return true;
        Player ownerPlayer = (Player)sender;
        Player receiverPlayer = Bukkit.getPlayer((String)args[0]);
        if (receiverPlayer == null) {
            ownerPlayer.sendMessage(String.valueOf(ChatColor.RED) + plugin.getMessages("player-not-found"));
            return false;
        }
        if (receiverPlayer == ownerPlayer) {
            return false;
        }
        Block bed = BedsUtils.checkIfIsBed(ownerPlayer.getTargetBlockExact(4));
        if (bed == null) {
            plugin.getLogger().info("Not found");
            ownerPlayer.sendMessage(String.valueOf(ChatColor.RED) + plugin.getMessages("bed-not-found-message"));
            return false;
        }
        BlockState blockState = bed.getState();
        String bedUUID = null;
        if (blockState instanceof TileState && (container = (tileState = (TileState)blockState).getPersistentDataContainer()).has(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING)) {
            bedUUID = (String)container.get(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING);
        }
        if (bedUUID == null) {
            ownerPlayer.sendMessage(String.valueOf(ChatColor.RED) + plugin.getMessages("bed-not-registered-message"));
            return false;
        }
        PlayerBedsData playerBedsData = null;
        PersistentDataContainer playerData = ownerPlayer.getPersistentDataContainer();
        if (!playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())) return true;
        playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType());
        if (playerBedsData != null && playerBedsData.getPlayerBedData() != null && playerBedsData.hasBed(bedUUID)) {
            PersistentDataContainer receiverData = receiverPlayer.getPersistentDataContainer();
            PlayerBedsData receiverBedsData = receiverData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType()) ? (PlayerBedsData)receiverData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType()) : new PlayerBedsData();
            playerBedsData.shareBed(receiverBedsData, bedUUID);
            receiverData.set(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType(), (Object)receiverBedsData);
            playerData.set(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType(), (Object)playerBedsData);
            receiverPlayer.sendMessage(plugin.getMessages("bed-registered-successfully-message"));
            return true;
        }
        ownerPlayer.sendMessage(String.valueOf(ChatColor.RED) + plugin.getMessages("bed-not-registered-message"));
        return false;
    }
}

