/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn.listeners;

import java.util.List;
import java.util.UUID;
import me.gabij.multiplebedspawn.MultipleBedSpawn;
import me.gabij.multiplebedspawn.models.BedsDataType;
import me.gabij.multiplebedspawn.models.PlayerBedsData;
import me.gabij.multiplebedspawn.utils.BedsUtils;
import me.gabij.multiplebedspawn.utils.PlayerUtils;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerGetsOnBedListener
implements Listener {
    MultipleBedSpawn plugin;

    public PlayerGetsOnBedListener(MultipleBedSpawn plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerGetOnBed(PlayerBedEnterEvent e) {
        boolean passLists;
        Player player = e.getPlayer();
        String world = player.getWorld().getName();
        List denylist = this.plugin.getConfig().getStringList("denylist");
        List allowlist = this.plugin.getConfig().getStringList("allowlist");
        boolean bl = passLists = !denylist.contains(world) && (allowlist.contains(world) || allowlist.isEmpty());
        if (passLists) {
            Block bed = e.getBed();
            PersistentDataContainer playerData = player.getPersistentDataContainer();
            int maxBeds = BedsUtils.getMaxNumberOfBeds(player);
            PlayerBedsData playerBedsData = null;
            int playerBedsCount = PlayerUtils.getPlayerBedsCount(player);
            if (playerData.has(new NamespacedKey((Plugin)this.plugin, "beds"), (PersistentDataType)new BedsDataType())) {
                playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)this.plugin, "beds"), (PersistentDataType)new BedsDataType());
            }
            if (playerBedsCount < maxBeds) {
                UUID randomUUID = UUID.randomUUID();
                BlockState blockState = bed.getState();
                if (blockState instanceof TileState) {
                    TileState tileState = (TileState)blockState;
                    PersistentDataContainer container = tileState.getPersistentDataContainer();
                    if (!container.has(new NamespacedKey((Plugin)this.plugin, "uuid"), PersistentDataType.STRING)) {
                        container.set(new NamespacedKey((Plugin)this.plugin, "uuid"), PersistentDataType.STRING, (Object)String.valueOf(randomUUID));
                    } else {
                        randomUUID = UUID.fromString((String)container.get(new NamespacedKey((Plugin)this.plugin, "uuid"), PersistentDataType.STRING));
                        if ((playerBedsData == null || playerBedsData != null && !playerBedsData.hasBed(randomUUID.toString())) && this.plugin.getConfig().getBoolean("exclusive-bed")) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + this.plugin.getMessages("bed-already-has-owner"));
                            return;
                        }
                    }
                    tileState.update();
                }
                boolean registerBed = false;
                if (playerBedsData == null) {
                    playerBedsData = new PlayerBedsData(player, bed, randomUUID.toString());
                    registerBed = true;
                } else if (!playerBedsData.hasBed(randomUUID.toString())) {
                    playerBedsData.setNewBed(player, bed, randomUUID.toString());
                    registerBed = true;
                }
                if (registerBed) {
                    playerData.set(new NamespacedKey((Plugin)this.plugin, "beds"), (PersistentDataType)new BedsDataType(), (Object)playerBedsData);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getMessages("bed-registered-successfully-message")));
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + this.plugin.getMessages("max-beds-message"));
            }
            player.setBedSpawnLocation(null);
            e.setCancelled(this.plugin.getConfig().getBoolean("disable-sleeping"));
        }
    }
}

