/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn.listeners;

import java.util.HashMap;
import java.util.List;
import me.gabij.multiplebedspawn.MultipleBedSpawn;
import me.gabij.multiplebedspawn.listeners.RespawnMenuHandler;
import me.gabij.multiplebedspawn.models.BedData;
import me.gabij.multiplebedspawn.models.BedsDataType;
import me.gabij.multiplebedspawn.models.PlayerBedsData;
import me.gabij.multiplebedspawn.utils.BedsUtils;
import me.gabij.multiplebedspawn.utils.PlayerUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerRespawnListener
implements Listener {
    static MultipleBedSpawn plugin;

    public PlayerRespawnListener(MultipleBedSpawn plugin) {
        PlayerRespawnListener.plugin = plugin;
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        boolean passLists;
        World world = e.getRespawnLocation().getWorld();
        if (world.getEnvironment() == World.Environment.NETHER || world.getEnvironment() == World.Environment.THE_END) {
            return;
        }
        if (e.getRespawnReason() == PlayerRespawnEvent.RespawnReason.PLUGIN) {
            return;
        }
        String worldName = world.getName();
        List denylist = plugin.getConfig().getStringList("denylist");
        List allowlist = plugin.getConfig().getStringList("allowlist");
        boolean bl = passLists = !denylist.contains(worldName) && (allowlist.contains(worldName) || allowlist.isEmpty());
        if (passLists) {
            PlayerBedsData playerBedsData;
            Player p = e.getPlayer();
            PersistentDataContainer playerData = p.getPersistentDataContainer();
            if (playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType()) && (playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())) != null && playerBedsData.getPlayerBedData() != null) {
                HashMap<String, BedData> beds = playerBedsData.getPlayerBedData();
                beds.forEach((uuid, bed) -> {
                    String[] loc = bed.getBedCoords().split(":");
                    String bedWorld = bed.getBedWorld();
                    Location bedLoc = new Location(Bukkit.getWorld((String)bedWorld), Double.parseDouble(loc[0]), Double.parseDouble(loc[1]), Double.parseDouble(loc[2]));
                    BedsUtils.checksIfBedExists(bedLoc, p, uuid);
                });
            }
            Location loc = e.getRespawnLocation();
            if (plugin.getConfig().getBoolean("spawn-on-sky")) {
                playerData.set(new NamespacedKey((Plugin)plugin, "spawnLoc"), PersistentDataType.STRING, (Object)PlayerUtils.locationToString(loc));
                loc.setY(loc.getY() + 300.0);
            }
            RespawnMenuHandler.openRespawnMenu(p);
        }
    }
}

