/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn.listeners;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import me.gabij.multiplebedspawn.MultipleBedSpawn;
import me.gabij.multiplebedspawn.models.BedsDataType;
import me.gabij.multiplebedspawn.models.PlayerBedsData;
import me.gabij.multiplebedspawn.utils.BedsUtils;
import me.gabij.multiplebedspawn.utils.PlayerUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class RemoveMenuHandler
implements Listener {
    static MultipleBedSpawn plugin;

    public RemoveMenuHandler(MultipleBedSpawn plugin) {
        RemoveMenuHandler.plugin = plugin;
    }

    public static void openRemoveMenu(Player p) {
        PersistentDataContainer playerData = p.getPersistentDataContainer();
        PlayerBedsData playerBedsData = null;
        int playerBedsCount = PlayerUtils.getPlayerBedsCount(p);
        if (playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())) {
            playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType());
        }
        if (playerBedsCount > 0) {
            int bedCount = playerBedsCount + 1;
            Inventory gui = Bukkit.createInventory((InventoryHolder)p, (int)(9 * (int)Math.ceil((double)bedCount / Double.valueOf(9.0))), (String)ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.getMessages("remove-menu-title")));
            HashMap beds = playerBedsData.getPlayerBedData();
            if (!plugin.getConfig().getBoolean("link-worlds")) {
                HashMap bedsT = (HashMap)beds.clone();
                beds.forEach((uuid, bed) -> {
                    if (!bed.getBedWorld().equalsIgnoreCase(p.getWorld().getName())) {
                        bedsT.remove(uuid);
                    }
                });
                beds = bedsT;
            }
            AtomicInteger cont = new AtomicInteger(1);
            beds.forEach((uuid, bed) -> {
                ItemStack item = new ItemStack(bed.getBedMaterial(), 1);
                ItemMeta item_meta = item.getItemMeta();
                String bedName = plugin.getMessages("default-bed-name").replace("{1}", cont.toString());
                item_meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)bedName));
                if (bed.getBedName() != null) {
                    item_meta.setDisplayName(bed.getBedName());
                }
                PersistentDataContainer data = item_meta.getPersistentDataContainer();
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                if (!plugin.getConfig().getBoolean("disable-bed-world-desc")) {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_PURPLE) + bed.getBedWorld().toUpperCase())));
                }
                if (!plugin.getConfig().getBoolean("disable-bed-coords-desc")) {
                    String[] location = bed.getBedCoords().split(":");
                    String locText = "X: " + location[0].substring(0, location[0].length() - 2) + " Y: " + location[1].substring(0, location[1].length() - 2) + " Z: " + location[2].substring(0, location[2].length() - 2);
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + locText)));
                }
                data.set(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING, uuid);
                data.set(new NamespacedKey((Plugin)plugin, "location"), PersistentDataType.STRING, (Object)bed.getBedCoords());
                data.set(new NamespacedKey((Plugin)plugin, "world"), PersistentDataType.STRING, (Object)bed.getBedWorld());
                item_meta.setLore(lore);
                item.setItemMeta(item_meta);
                gui.addItem(new ItemStack[]{item});
                cont.getAndIncrement();
            });
            ItemStack item = new ItemStack(Material.BARRIER, 1);
            ItemMeta item_meta = item.getItemMeta();
            item_meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + plugin.getMessages("close-menu"));
            item.setItemMeta(item_meta);
            gui.setItem(9 * (int)Math.ceil((double)bedCount / Double.valueOf(9.0)) - 1, item);
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> p.openInventory(gui), 0L);
        }
    }

    public static void updateItens(Inventory gui, Player p) {
        if (gui.getViewers().toString().length() > 2) {
            PersistentDataContainer playerData = p.getPersistentDataContainer();
            int playerBedsCount = 0;
            PlayerBedsData playerBedsData = null;
            if (playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType()) && (playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())) != null && playerBedsData.getPlayerBedData() != null) {
                HashMap beds = playerBedsData.getPlayerBedData();
                if (!plugin.getConfig().getBoolean("link-worlds")) {
                    HashMap bedsT = (HashMap)beds.clone();
                    beds.forEach((uuid, bed) -> {
                        if (!bed.getBedWorld().equalsIgnoreCase(p.getWorld().getName())) {
                            bedsT.remove(uuid);
                        }
                    });
                    beds = bedsT;
                }
                playerBedsCount = beds.size();
            }
            if (playerBedsCount > 0) {
                int bedCount = playerBedsCount + 1;
                gui.clear();
                HashMap beds = playerBedsData.getPlayerBedData();
                if (!plugin.getConfig().getBoolean("link-worlds")) {
                    HashMap bedsT = (HashMap)beds.clone();
                    beds.forEach((uuid, bed) -> {
                        if (!bed.getBedWorld().equalsIgnoreCase(p.getWorld().getName())) {
                            bedsT.remove(uuid);
                        }
                    });
                    beds = bedsT;
                }
                AtomicInteger cont = new AtomicInteger(1);
                beds.forEach((uuid, bed) -> {
                    ItemStack item = new ItemStack(bed.getBedMaterial(), 1);
                    ItemMeta item_meta = item.getItemMeta();
                    String bedName = plugin.getMessages("default-bed-name").replace("{1}", cont.toString());
                    item_meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)bedName));
                    if (bed.getBedName() != null) {
                        item_meta.setDisplayName(bed.getBedName());
                    }
                    PersistentDataContainer data = item_meta.getPersistentDataContainer();
                    ArrayList<CallSite> lore = new ArrayList<CallSite>();
                    if (!plugin.getConfig().getBoolean("disable-bed-world-desc")) {
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_PURPLE) + bed.getBedWorld().toUpperCase())));
                    }
                    if (!plugin.getConfig().getBoolean("disable-bed-coords-desc")) {
                        String[] location = bed.getBedCoords().split(":");
                        String locText = "X: " + location[0].substring(0, location[0].length() - 2) + " Y: " + location[1].substring(0, location[1].length() - 2) + " Z: " + location[2].substring(0, location[2].length() - 2);
                        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + locText)));
                    }
                    data.set(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING, uuid);
                    data.set(new NamespacedKey((Plugin)plugin, "location"), PersistentDataType.STRING, (Object)bed.getBedCoords());
                    data.set(new NamespacedKey((Plugin)plugin, "world"), PersistentDataType.STRING, (Object)bed.getBedWorld());
                    item_meta.setLore(lore);
                    item.setItemMeta(item_meta);
                    gui.addItem(new ItemStack[]{item});
                    cont.getAndIncrement();
                });
                ItemStack item = new ItemStack(Material.BARRIER, 1);
                ItemMeta item_meta = item.getItemMeta();
                item_meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + plugin.getMessages("close-menu"));
                item.setItemMeta(item_meta);
                gui.setItem(9 * (int)Math.ceil((double)bedCount / Double.valueOf(9.0)) - 1, item);
            } else {
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> p.closeInventory(), 0L);
            }
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> p.closeInventory(), 0L);
        }
    }

    @EventHandler
    public void onMenuClick(InventoryClickEvent e) {
        if (e.getView().getTitle().equalsIgnoreCase(plugin.getMessages("remove-menu-title"))) {
            e.setCancelled(true);
            Player p = (Player)e.getWhoClicked();
            if (e.getCurrentItem() != null) {
                PersistentDataContainer playerData = p.getPersistentDataContainer();
                PlayerBedsData playerBedsData = null;
                if (playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())) {
                    playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType());
                }
                if (e.getCurrentItem().getType().toString().toLowerCase().contains("bed")) {
                    ItemMeta item_meta = e.getCurrentItem().getItemMeta();
                    PersistentDataContainer data = item_meta.getPersistentDataContainer();
                    String uuid = (String)data.get(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING);
                    BedsUtils.removePlayerBed(uuid, p);
                    RemoveMenuHandler.updateItens(e.getClickedInventory(), p);
                } else if (e.getCurrentItem().getType().toString().equalsIgnoreCase("BARRIER")) {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> p.closeInventory(), 0L);
                }
            }
        }
    }
}

