/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn.listeners;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import me.gabij.multiplebedspawn.MultipleBedSpawn;
import me.gabij.multiplebedspawn.models.BedsDataType;
import me.gabij.multiplebedspawn.models.PlayerBedsData;
import me.gabij.multiplebedspawn.utils.BedsUtils;
import me.gabij.multiplebedspawn.utils.PlayerUtils;
import me.gabij.multiplebedspawn.utils.RunCommandUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class RespawnMenuHandler
implements Listener {
    static MultipleBedSpawn plugin;

    public RespawnMenuHandler(MultipleBedSpawn plugin) {
        RespawnMenuHandler.plugin = plugin;
    }

    public static void updateItens(Inventory gui, Player p) {
        if (gui.getViewers().toString().length() > 2) {
            ItemStack[] itens = gui.getContents();
            boolean hasActiveCooldown = false;
            ItemStack[] itemStackArray = itens;
            int n = itens.length;
            int n2 = 0;
            while (n2 < n) {
                ItemMeta item_meta;
                PersistentDataContainer data;
                ItemStack item = itemStackArray[n2];
                if (item != null && item.hasItemMeta() && (data = (item_meta = item.getItemMeta()).getPersistentDataContainer()).has(new NamespacedKey((Plugin)plugin, "cooldown"), PersistentDataType.LONG) && data.has(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING)) {
                    long cooldown = (Long)data.get(new NamespacedKey((Plugin)plugin, "cooldown"), PersistentDataType.LONG);
                    ArrayList<CallSite> lore = item_meta.getLore();
                    int optionsCount = 2;
                    if (plugin.getConfig().getBoolean("disable-bed-world-desc")) {
                        --optionsCount;
                    }
                    if (plugin.getConfig().getBoolean("disable-bed-coords-desc")) {
                        --optionsCount;
                    }
                    if (cooldown > System.currentTimeMillis()) {
                        hasActiveCooldown = true;
                        long sec = (cooldown - System.currentTimeMillis()) / 1000L;
                        String seconds = Long.toString(sec);
                        if (lore == null) {
                            lore = new ArrayList<CallSite>();
                        }
                        if (lore.size() > optionsCount) {
                            lore.set(optionsCount, (CallSite)((Object)(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + plugin.getMessages("cooldown-text").replace("{1}", seconds))));
                        } else {
                            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + plugin.getMessages("cooldown-text").replace("{1}", seconds))));
                        }
                    } else if (lore.size() > optionsCount) {
                        lore.remove(optionsCount);
                    }
                    item_meta.setLore((List)lore);
                    item.setItemMeta(item_meta);
                }
                ++n2;
            }
            if (hasActiveCooldown) {
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> RespawnMenuHandler.updateItens(gui, p), 10L);
            }
        }
    }

    public static void openRespawnMenu(Player p) {
        PersistentDataContainer playerData = p.getPersistentDataContainer();
        PlayerBedsData playerBedsData = null;
        int playerBedsCount = PlayerUtils.getPlayerBedsCount(p);
        if (playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())) {
            playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType());
        }
        if (playerBedsCount > 0) {
            PlayerUtils.setPropPlayer(p);
            int bedCount = playerBedsCount + 1;
            Inventory gui = Bukkit.createInventory((InventoryHolder)p, (int)(9 * (int)Math.ceil((double)bedCount / Double.valueOf(9.0))), (String)ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.getMessages("menu-title")));
            HashMap beds = playerBedsData.getPlayerBedData();
            if (!plugin.getConfig().getBoolean("link-worlds")) {
                World world = PlayerUtils.getPlayerRespawnLoc(p).getWorld();
                HashMap bedsT = (HashMap)beds.clone();
                beds.forEach((uuid, bed) -> {
                    if (!bed.getBedWorld().equalsIgnoreCase(world.getName())) {
                        bedsT.remove(uuid);
                    }
                });
                beds = bedsT;
            }
            AtomicBoolean hasCooldown = new AtomicBoolean(false);
            AtomicInteger cont = new AtomicInteger(1);
            beds.forEach((uuid, bed) -> {
                ItemStack item = new ItemStack(bed.getBedMaterial(), 1);
                ItemMeta item_meta = item.getItemMeta();
                String bedName = plugin.getMessages("default-bed-name").replace("{1}", cont.toString());
                item_meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)bedName));
                if (bed.getBedName() != null) {
                    item_meta.setDisplayName(bed.getBedName());
                }
                PersistentDataContainer data = item_meta.getPersistentDataContainer();
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                if (!plugin.getConfig().getBoolean("disable-bed-world-desc")) {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_PURPLE) + bed.getBedWorld().toUpperCase())));
                }
                if (!plugin.getConfig().getBoolean("disable-bed-coords-desc")) {
                    String[] location = bed.getBedCoords().split(":");
                    String locText = "X: " + location[0].substring(0, location[0].length() - 2) + " Y: " + location[1].substring(0, location[1].length() - 2) + " Z: " + location[2].substring(0, location[2].length() - 2);
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + locText)));
                }
                if (bed.getBedCooldown() > 0L) {
                    long cooldown = bed.getBedCooldown();
                    if (cooldown > System.currentTimeMillis()) {
                        hasCooldown.set(true);
                        data.set(new NamespacedKey((Plugin)plugin, "cooldown"), PersistentDataType.LONG, (Object)cooldown);
                    } else {
                        bed.setBedCooldown(0L);
                    }
                }
                data.set(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING, uuid);
                data.set(new NamespacedKey((Plugin)plugin, "location"), PersistentDataType.STRING, (Object)bed.getBedCoords());
                data.set(new NamespacedKey((Plugin)plugin, "world"), PersistentDataType.STRING, (Object)bed.getBedWorld());
                item_meta.setLore(lore);
                item.setItemMeta(item_meta);
                gui.addItem(new ItemStack[]{item});
                cont.getAndIncrement();
            });
            if (hasCooldown.get()) {
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> RespawnMenuHandler.updateItens(gui, p), 10L);
            }
            ItemStack item = new ItemStack(Material.GRASS_BLOCK, 1);
            ItemMeta item_meta = item.getItemMeta();
            item_meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "SPAWN");
            item.setItemMeta(item_meta);
            gui.setItem(9 * (int)Math.ceil((double)bedCount / Double.valueOf(9.0)) - 1, item);
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> p.openInventory(gui), 0L);
        } else if (playerData.has(new NamespacedKey((Plugin)plugin, "spawnLoc"))) {
            Location location = PlayerUtils.getPlayerRespawnLoc(p);
            playerData.remove(new NamespacedKey((Plugin)plugin, "spawnLoc"));
            PlayerUtils.undoPropPlayer(p);
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> p.teleport(location), 1L);
        }
    }

    @EventHandler
    public void onMenuClick(InventoryClickEvent e) {
        if (e.getView().getTitle().equalsIgnoreCase(plugin.getMessages("menu-title"))) {
            e.setCancelled(true);
            Player p = (Player)e.getWhoClicked();
            if (e.getCurrentItem() != null) {
                PersistentDataContainer playerData = p.getPersistentDataContainer();
                int playerBedsCount = 0;
                PlayerBedsData playerBedsData = null;
                if (playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType()) && (playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())) != null && playerBedsData.getPlayerBedData() != null) {
                    playerBedsCount = playerBedsData.getPlayerBedData().size();
                }
                double bedCount = playerBedsCount + 1;
                int index = e.getSlot();
                if (e.getCurrentItem().getType().toString().toLowerCase().contains("bed")) {
                    String uuid;
                    ItemMeta item_meta = e.getCurrentItem().getItemMeta();
                    PersistentDataContainer data = item_meta.getPersistentDataContainer();
                    String[] bedCoord = ((String)data.get(new NamespacedKey((Plugin)plugin, "location"), PersistentDataType.STRING)).split(":");
                    String world = (String)data.get(new NamespacedKey((Plugin)plugin, "world"), PersistentDataType.STRING);
                    Location location = new Location(Bukkit.getWorld((String)world), Double.parseDouble(bedCoord[0]), Double.parseDouble(bedCoord[1]), Double.parseDouble(bedCoord[2]));
                    if (BedsUtils.checksIfBedExists(location, p, uuid = (String)data.get(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING))) {
                        PlayerUtils.teleportPlayer(p, data, playerData, playerBedsData, uuid);
                    } else {
                        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> p.closeInventory(), 0L);
                    }
                } else if (index == 9 * (int)Math.ceil(bedCount / Double.valueOf(9.0)) - 1) {
                    PlayerUtils.undoPropPlayer(p);
                    Location location = PlayerUtils.getPlayerRespawnLoc(p);
                    playerData.remove(new NamespacedKey((Plugin)plugin, "spawnLoc"));
                    p.teleport(location);
                    RunCommandUtils.runCommandOnSpawn(p);
                }
            }
        }
    }

    @EventHandler
    public void onMenuClose(InventoryCloseEvent e) {
        Player p;
        if (e.getView().getTitle().equalsIgnoreCase(plugin.getMessages("menu-title")) && !(p = (Player)e.getPlayer()).getCanPickupItems()) {
            RespawnMenuHandler.openRespawnMenu(p);
        }
    }
}

