/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn.models;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import me.gabij.multiplebedspawn.models.BedData;
import org.apache.commons.lang.SerializationUtils;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

public class BedDataType
implements PersistentDataType<byte[], BedData> {
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    public Class<BedData> getComplexType() {
        return BedData.class;
    }

    public byte[] toPrimitive(BedData complex, PersistentDataAdapterContext context) {
        return SerializationUtils.serialize(complex);
    }

    public BedData fromPrimitive(byte[] primitive, PersistentDataAdapterContext context) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(primitive);
            CustomObjectInputStream o = new CustomObjectInputStream(is);
            return (BedData)o.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class CustomObjectInputStream
    extends ObjectInputStream {
        public CustomObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String oldPackageName;
            String className = desc.getName();
            if (className.startsWith(oldPackageName = this.getAsciiPackageName())) {
                className = className.replace(oldPackageName, "me.gabij.");
            }
            return super.resolveClass(ObjectStreamClass.lookup(Class.forName(className)));
        }

        private String getAsciiPackageName() {
            int[] asciiValues = new int[]{109, 101, 46, 103, 97, 98, 114, 105, 101, 108, 102, 106, 46};
            StringBuilder sb = new StringBuilder();
            int[] nArray = asciiValues;
            int n = asciiValues.length;
            int n2 = 0;
            while (n2 < n) {
                int val = nArray[n2];
                sb.append((char)val);
                ++n2;
            }
            return sb.toString();
        }
    }
}

