/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn.utils;

import java.util.HashMap;
import me.gabij.multiplebedspawn.MultipleBedSpawn;
import me.gabij.multiplebedspawn.models.BedData;
import me.gabij.multiplebedspawn.models.BedsDataType;
import me.gabij.multiplebedspawn.models.PlayerBedsData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BedsUtils {
    static MultipleBedSpawn plugin = MultipleBedSpawn.getInstance();

    public static void removePlayerBed(String bedUUID, Player p) {
        PlayerBedsData playerBedsData;
        HashMap<String, BedData> beds;
        PersistentDataContainer playerData = p.getPersistentDataContainer();
        if (playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType()) && (beds = (playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())).getPlayerBedData()).containsKey(bedUUID)) {
            BlockState blockState;
            Bed bedPart;
            BedData bedData = beds.get(bedUUID);
            playerBedsData.removeBed(bedUUID);
            playerData.set(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType(), (Object)playerBedsData);
            World world = Bukkit.getWorld((String)bedData.getBedWorld());
            String[] loc = bedData.getBedCoords().split(":");
            Location locBed = new Location(world, Double.parseDouble(loc[0]), Double.parseDouble(loc[1]), Double.parseDouble(loc[2]));
            Block bed = world.getBlockAt(locBed);
            BlockData blockData = bed.getBlockData();
            if (blockData instanceof Bed && (bedPart = (Bed)blockData).getPart().toString() == "FOOT") {
                bed = bed.getRelative(bedPart.getFacing());
            }
            if ((blockState = bed.getState()) instanceof TileState) {
                TileState tileState = (TileState)blockState;
                PersistentDataContainer container = tileState.getPersistentDataContainer();
                container.remove(new NamespacedKey((Plugin)plugin, "uuid"));
                tileState.update();
            }
        }
    }

    public static boolean checksIfBedExists(Location locBed, Player p, String bedUUID) {
        World world = locBed.getWorld();
        Block bed = world.getBlockAt(locBed);
        boolean isBed = false;
        BlockData blockData = bed.getBlockData();
        if (blockData instanceof Bed) {
            Bed bedPart = (Bed)blockData;
            if (bedPart.getPart().toString() == "FOOT") {
                bed = bed.getRelative(bedPart.getFacing());
            }
            isBed = true;
        }
        if (!isBed) {
            BedsUtils.removePlayerBed(bedUUID, p);
            return false;
        }
        BlockState blockState = bed.getState();
        if (blockState instanceof TileState) {
            TileState tileState = (TileState)blockState;
            PersistentDataContainer container = tileState.getPersistentDataContainer();
            String uuid = (String)container.get(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING);
            if (container == null || uuid == null || !uuid.equalsIgnoreCase(bedUUID)) {
                BedsUtils.removePlayerBed(bedUUID, p);
                return false;
            }
        }
        return true;
    }

    public static Block checkIfIsBed(Block block) {
        BlockData blockData;
        if (block != null && (blockData = block.getBlockData()) instanceof Bed) {
            Bed bedPart = (Bed)blockData;
            if (bedPart.getPart().toString() == "FOOT") {
                block = block.getRelative(bedPart.getFacing());
            }
            return block;
        }
        return null;
    }

    public static int getMaxNumberOfBeds(Player player) {
        int maxBeds = plugin.getConfig().getInt("max-beds");
        int maxBedsByPerms = 0;
        if (player.hasPermission("multiplebedspawn.maxcount")) {
            for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
                String permName = perm.getPermission();
                if (!permName.contains("multiplebedspawn.maxcount.") || !perm.getValue()) continue;
                String maxCount = permName.split("multiplebedspawn.maxcount.")[1].trim();
                try {
                    int max = Integer.parseInt(maxCount);
                    if (max > 53) {
                        plugin.getLogger().warning("Permission " + permName + " is invalid! Should be lower than 53. Value defaulted to 53, please remove this permission. Warning triggered by player " + player.getName());
                        max = 53;
                    }
                    if (max <= maxBedsByPerms) continue;
                    maxBedsByPerms = max;
                }
                catch (Exception err) {
                    plugin.getLogger().warning("Permission " + permName + " is invalid! Should be a number after 'maxcount.'. Warning triggered by player " + player.getName());
                }
            }
        }
        if (maxBeds > 53) {
            plugin.getLogger().warning("Max bed count cant be over 53! Value defaulted to 53.");
            plugin.getConfig().set("max-beds", (Object)53);
            plugin.saveConfig();
            maxBeds = 53;
        }
        if (maxBedsByPerms > 0) {
            maxBeds = maxBedsByPerms;
        }
        return maxBeds;
    }
}

