/*
 * Decompiled with CFR 0.152.
 */
package me.gabij.multiplebedspawn.utils;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import me.gabij.multiplebedspawn.MultipleBedSpawn;
import me.gabij.multiplebedspawn.models.BedData;
import me.gabij.multiplebedspawn.models.BedsDataType;
import me.gabij.multiplebedspawn.models.PlayerBedsData;
import me.gabij.multiplebedspawn.utils.BedsUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerUtils {
    static MultipleBedSpawn plugin = MultipleBedSpawn.getInstance();

    public static String locationToString(Location loc) {
        return loc.getWorld().getName() + ":" + loc.getX() + ":" + loc.getY() + ":" + loc.getZ();
    }

    public static Location stringToLocation(String locString) {
        String[] loc = locString.split(":");
        return new Location(Bukkit.getWorld((String)loc[0]), Double.parseDouble(loc[1]), Double.parseDouble(loc[2]), Double.parseDouble(loc[3]));
    }

    public static void setPropPlayer(Player p) {
        PersistentDataContainer playerData = p.getPersistentDataContainer();
        if (!playerData.has(new NamespacedKey((Plugin)plugin, "hasProp"), PersistentDataType.BOOLEAN)) {
            p.setInvulnerable(true);
            playerData.set(new NamespacedKey((Plugin)plugin, "isInvisible"), PersistentDataType.BOOLEAN, (Object)p.isInvisible());
            p.setInvisible(true);
            playerData.set(new NamespacedKey((Plugin)plugin, "canPickupItems"), PersistentDataType.BOOLEAN, (Object)p.getCanPickupItems());
            p.setCanPickupItems(false);
            if (plugin.getConfig().getBoolean("spawn-on-sky")) {
                playerData.set(new NamespacedKey((Plugin)plugin, "allowFly"), PersistentDataType.BOOLEAN, (Object)p.getAllowFlight());
                p.setAllowFlight(true);
                p.setFlying(true);
            }
            playerData.set(new NamespacedKey((Plugin)plugin, "lastWalkspeed"), PersistentDataType.FLOAT, (Object)Float.valueOf(p.getWalkSpeed()));
            p.setWalkSpeed(0.0f);
            playerData.set(new NamespacedKey((Plugin)plugin, "hasProp"), PersistentDataType.BOOLEAN, (Object)true);
        }
    }

    public static void undoPropPlayer(Player p) {
        PersistentDataContainer playerData = p.getPersistentDataContainer();
        if (playerData.has(new NamespacedKey((Plugin)plugin, "hasProp"), PersistentDataType.BOOLEAN)) {
            playerData.remove(new NamespacedKey((Plugin)plugin, "hasProp"));
            p.setInvulnerable(false);
            p.setInvisible(((Boolean)playerData.get(new NamespacedKey((Plugin)plugin, "isInvisible"), PersistentDataType.BOOLEAN)).booleanValue());
            p.setCanPickupItems(((Boolean)playerData.get(new NamespacedKey((Plugin)plugin, "canPickupItems"), PersistentDataType.BOOLEAN)).booleanValue());
            playerData.remove(new NamespacedKey((Plugin)plugin, "isInvisible"));
            playerData.remove(new NamespacedKey((Plugin)plugin, "canPickupItems"));
            p.setWalkSpeed(((Float)playerData.get(new NamespacedKey((Plugin)plugin, "lastWalkspeed"), PersistentDataType.FLOAT)).floatValue());
            playerData.remove(new NamespacedKey((Plugin)plugin, "lastWalkspeed"));
            if (plugin.getConfig().getBoolean("spawn-on-sky")) {
                p.setAllowFlight(((Boolean)playerData.get(new NamespacedKey((Plugin)plugin, "allowFly"), PersistentDataType.BOOLEAN)).booleanValue());
                p.setFlying(false);
                playerData.remove(new NamespacedKey((Plugin)plugin, "allowFly"));
                playerData.remove(new NamespacedKey((Plugin)plugin, "isFlying"));
            }
            p.closeInventory();
        }
    }

    public static void teleportPlayer(Player p, PersistentDataContainer data, PersistentDataContainer playerData, PlayerBedsData playerBedsData, String uuid) {
        long cooldown;
        boolean isOkayToTP = true;
        if (data.has(new NamespacedKey((Plugin)plugin, "cooldown"), PersistentDataType.LONG) && data.has(new NamespacedKey((Plugin)plugin, "uuid"), PersistentDataType.STRING) && (cooldown = ((Long)data.get(new NamespacedKey((Plugin)plugin, "cooldown"), PersistentDataType.LONG)).longValue()) > System.currentTimeMillis()) {
            isOkayToTP = false;
        }
        if (isOkayToTP) {
            HashMap<String, BedData> beds = playerBedsData.getPlayerBedData();
            PlayerUtils.undoPropPlayer(p);
            String[] loc = beds.get(uuid).getBedSpawnCoords().split(":");
            World world = Bukkit.getWorld((String)beds.get(uuid).getBedWorld());
            Location locSpawn = new Location(world, Double.parseDouble(loc[0]), Double.parseDouble(loc[1]), Double.parseDouble(loc[2]));
            if (!p.hasPermission("multiplebedspawn.skipcooldown")) {
                beds.get(uuid).setBedCooldown(System.currentTimeMillis() + plugin.getConfig().getLong("bed-cooldown") * 1000L);
            }
            playerData.set(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType(), (Object)playerBedsData);
            playerData.remove(new NamespacedKey((Plugin)plugin, "spawnLoc"));
            p.teleport(locSpawn);
        }
    }

    public static Location getPlayerRespawnLoc(Player p) {
        Location playerRespawnLocation;
        Location loc = p.getLocation();
        PersistentDataContainer playerData = p.getPersistentDataContainer();
        if (playerData.has(new NamespacedKey((Plugin)plugin, "spawnLoc"), PersistentDataType.STRING) && (playerRespawnLocation = PlayerUtils.stringToLocation((String)playerData.get(new NamespacedKey((Plugin)plugin, "spawnLoc"), PersistentDataType.STRING))) != null) {
            loc = playerRespawnLocation;
        }
        return loc;
    }

    public static Integer getPlayerBedsCount(Player p) {
        PersistentDataContainer playerData = p.getPersistentDataContainer();
        PlayerBedsData playerBedsData = null;
        AtomicInteger playerBedsCount = new AtomicInteger();
        playerBedsCount.set(0);
        if (playerData.has(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType()) && (playerBedsData = (PlayerBedsData)playerData.get(new NamespacedKey((Plugin)plugin, "beds"), (PersistentDataType)new BedsDataType())) != null && playerBedsData.getPlayerBedData() != null) {
            HashMap beds = playerBedsData.getPlayerBedData();
            World world = PlayerUtils.getPlayerRespawnLoc(p).getWorld();
            String worldName = world.getName();
            if (!plugin.getConfig().getBoolean("link-worlds")) {
                HashMap bedsT = (HashMap)beds.clone();
                beds.forEach((uuid, bedData) -> {
                    if (!bedData.getBedWorld().equalsIgnoreCase(worldName)) {
                        bedsT.remove(uuid);
                    }
                });
                beds = bedsT;
            }
            playerBedsCount.set(beds.size());
            beds.forEach((uuid, bedData) -> {
                String[] location = bedData.getBedCoords().split(":");
                String bedWorld = bedData.getBedWorld();
                Location bedLoc = new Location(Bukkit.getWorld((String)bedWorld), Double.parseDouble(location[0]), Double.parseDouble(location[1]), Double.parseDouble(location[2]));
                if (!BedsUtils.checksIfBedExists(bedLoc, p, uuid)) {
                    playerBedsCount.addAndGet(-1);
                }
            });
        }
        return playerBedsCount.get();
    }
}

