/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class CPlayerMain {
    private Map<UUID, CPlayer> players = new HashMap<UUID, CPlayer>();
    private Map<UUID, String> playersName = new HashMap<UUID, String>();
    private Map<String, UUID> playersUUID = new HashMap<String, UUID>();
    private Set<UUID> playersRegistered = new HashSet<UUID>();
    private Map<UUID, Map<String, Double>> playersConfigSettings = new HashMap<UUID, Map<String, Double>>();
    private ConcurrentHashMap<String, ItemStack> playersHead = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> playersHashedTexture = new ConcurrentHashMap();
    private SimpleClaimSystem instance;
    private final String MOJANG_API_URL = "https://api.mojang.com/users/profiles/minecraft/";
    private final String MOJANG_PROFILE_API_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final int RATE_LIMIT = 50;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private int requestCount = 0;
    public static final Pattern CLAIM_PATTERN = Pattern.compile("scs\\.claim\\.(\\d+)");
    public static final Pattern RADIUS_PATTERN = Pattern.compile("scs\\.radius\\.(\\d+)");
    public static final Pattern DELAY_PATTERN = Pattern.compile("scs\\.delay\\.(\\d+)");
    public static final Pattern COST_PATTERN = Pattern.compile("scs\\.claim-cost\\.(\\d+(\\.\\d+)?)");
    public static final Pattern CHUNK_COST_PATTERN = Pattern.compile("scs\\.chunk-cost\\.(\\d+(\\.\\d+)?)");
    public static final Pattern MULTIPLIER_PATTERN = Pattern.compile("scs\\.claim-cost-multiplier\\.(\\d+(\\.\\d+)?)");
    public static final Pattern CHUNK_MULTIPLIER_PATTERN = Pattern.compile("scs\\.chunk-cost-multiplier\\.(\\d+(\\.\\d+)?)");
    public static final Pattern MEMBERS_PATTERN = Pattern.compile("scs\\.members\\.(\\d+)");
    public static final Pattern CHUNKS_PATTERN = Pattern.compile("scs\\.chunks\\.(\\d+)");
    public static final Pattern DISTANCE_PATTERN = Pattern.compile("scs\\.distance\\.(\\d+)");
    public static final Pattern CHUNKS_TOTAL_PATTERN = Pattern.compile("scs\\.chunks-total\\.(\\d+)");

    public CPlayerMain(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    public void clearAll() {
        this.players.clear();
        this.playersConfigSettings.clear();
    }

    public void checkPlayer(Player player) {
        this.instance.executeAsync(() -> {
            String uuid_mojang;
            UUID uuid = player.getUniqueId();
            String playerName = player.getName();
            String oldName = this.playersName.get(uuid);
            if (!this.playersRegistered.contains(uuid) || oldName == null) {
                this.playersRegistered.add(uuid);
                this.playersName.put(uuid, playerName);
                this.playersUUID.put(playerName, uuid);
                String uuid_mojang2 = this.getUUIDFromMojang(playerName);
                String textures = this.getSkinURLWithoutDelay(uuid_mojang2);
                ItemStack playerHead = this.createPlayerHeadWithTexture(uuid_mojang2, textures);
                this.playersHead.put(playerName, playerHead);
                this.playersHashedTexture.put(playerName, textures == null ? "none" : textures);
                try (Connection connection = this.instance.getDataSource().getConnection();){
                    String updateQuery;
                    String dbProductName = connection.getMetaData().getDatabaseProductName().toLowerCase();
                    if (dbProductName.contains("sqlite")) {
                        updateQuery = "INSERT INTO scs_players(uuid_server, uuid_mojang, player_name, player_head, player_textures) VALUES(?, ?, ?, ?, ?) ON CONFLICT(uuid_server) DO UPDATE SET player_name = excluded.player_name";
                    } else if (dbProductName.contains("mysql")) {
                        updateQuery = "INSERT INTO scs_players(uuid_server, uuid_mojang, player_name, player_head, player_textures) VALUES(?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE player_name = VALUES(player_name)";
                    } else {
                        throw new UnsupportedOperationException("Unsupported database: " + dbProductName);
                    }
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, uuid.toString());
                        preparedStatement.setString(2, uuid_mojang2 == null ? "none" : uuid_mojang2);
                        preparedStatement.setString(3, playerName);
                        preparedStatement.setString(4, "");
                        preparedStatement.setString(5, textures == null ? "none" : textures);
                        preparedStatement.executeUpdate();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.instance.getLogger().info(playerName + " is now registered (" + uuid.toString() + ").");
                return;
            }
            if (!oldName.equals(playerName)) {
                this.instance.getLogger().info(oldName + " changed their name to " + playerName + " (" + uuid.toString() + "), new name saved.");
                this.playersUUID.remove(oldName);
                this.playersName.put(uuid, playerName);
                this.playersUUID.put(playerName, uuid);
                CustomSet<Claim> claims = this.instance.getMain().getPlayerClaims(uuid);
                claims.forEach(c -> {
                    c.setOwner(playerName);
                    this.instance.getBossBars().activateBossBar(c.getChunks());
                });
                this.instance.getMain().setPlayerClaims(uuid, claims);
                try (Connection connection = this.instance.getDataSource().getConnection();){
                    PreparedStatement preparedStatement;
                    String updateQuery = "UPDATE scs_players SET player_name = ? WHERE uuid_server = ?";
                    try {
                        preparedStatement = connection.prepareStatement(updateQuery);
                        try {
                            preparedStatement.setString(1, playerName);
                            preparedStatement.setString(2, uuid.toString());
                            preparedStatement.executeUpdate();
                        }
                        finally {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    updateQuery = "UPDATE scs_claims_1 SET owner_name = ? WHERE owner_uuid = ?";
                    try {
                        preparedStatement = connection.prepareStatement(updateQuery);
                        try {
                            preparedStatement.setString(1, playerName);
                            preparedStatement.setString(2, uuid.toString());
                            preparedStatement.executeUpdate();
                        }
                        finally {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if ((uuid_mojang = this.getUUIDFromMojang(playerName)) != null) {
                String textures = this.getSkinURLWithoutDelay(uuid_mojang);
                if (textures == null) {
                    return;
                }
                if (textures.equals(this.playersHashedTexture.getOrDefault(playerName, ""))) {
                    return;
                }
                this.instance.getLogger().info(playerName + " changed their skin (" + uuid.toString() + "), new textures saved.");
                ItemStack head = this.createPlayerHeadWithTexture(uuid_mojang, textures);
                this.playersHead.put(playerName, head);
                this.playersHashedTexture.put(playerName, textures);
                try (Connection connection = this.instance.getDataSource().getConnection();){
                    String updateQuery = "UPDATE scs_players SET player_textures = ? WHERE uuid_server = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement(updateQuery);){
                        preparedStatement.setString(1, textures);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.executeUpdate();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else if (!this.playersHead.containsKey(playerName)) {
                this.playersHead.put(playerName, new ItemStack(Material.PLAYER_HEAD));
            }
        });
    }

    public void loadPlayers() {
        this.instance.info(" ");
        this.instance.info(String.valueOf(ChatColor.DARK_GREEN) + "Loading players..");
        int i = 0;
        try (Connection connection = this.instance.getDataSource().getConnection();){
            String getQuery = "SELECT * FROM scs_players";
            try (PreparedStatement preparedStatement = connection.prepareStatement(getQuery);){
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        UUID uuid = UUID.fromString(resultSet.getString("uuid_server"));
                        String uuid_mojang = resultSet.getString("uuid_mojang");
                        String playerName = resultSet.getString("player_name");
                        String textures = resultSet.getString("player_textures");
                        ItemStack playerHead = this.createPlayerHeadWithTexture(uuid_mojang, textures);
                        this.playersHead.put(playerName, playerHead);
                        this.playersHashedTexture.put(playerName, textures);
                        this.playersName.put(uuid, playerName);
                        this.playersUUID.put(playerName, uuid);
                        this.playersRegistered.add(uuid);
                        ++i;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.instance.info(this.instance.getMain().getNumberSeparate(String.valueOf(i)) + " players loaded.");
    }

    public ItemStack getPlayerHead(String playerName) {
        ItemStack player_head = this.playersHead.computeIfAbsent(playerName, p -> {
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            if (meta != null) {
                PlayerProfile profile = Bukkit.createPlayerProfile((String)playerName);
                if (profile != null) {
                    meta.setOwnerProfile(profile);
                }
                head.setItemMeta((ItemMeta)meta);
            }
            return head;
        });
        if (player_head == null) {
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            if (meta != null) {
                PlayerProfile profile = Bukkit.createPlayerProfile((String)playerName);
                if (profile != null) {
                    meta.setOwnerProfile(profile);
                }
                head.setItemMeta((ItemMeta)meta);
            }
            return head;
        }
        return player_head;
    }

    private String addDashesToUUID(String uuid) {
        if (uuid.length() == 32) {
            return uuid.replaceFirst("([0-9a-fA-F]{8})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{12})", "$1-$2-$3-$4-$5");
        }
        return uuid;
    }

    public ItemStack createPlayerHeadWithTexture(String uuid, String texture) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (!(meta == null || uuid == null || uuid.isBlank() || texture == null || texture.isBlank() || texture.equals("none") || uuid.equals("none"))) {
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.fromString(uuid));
            if (texture != null) {
                try {
                    URI uri = URI.create(texture);
                    URL url = uri.toURL();
                    PlayerTextures textures = profile.getTextures();
                    textures.setSkin(url);
                    profile.setTextures(textures);
                    meta.setOwnerProfile(profile);
                    head.setItemMeta((ItemMeta)meta);
                }
                catch (MalformedURLException e) {
                    return head;
                }
            }
        }
        return head;
    }

    public ItemStack createPlayerHeadWithTexture(String texture, String title, List<String> lore) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null && texture != null && !texture.isBlank()) {
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
            if (texture != null) {
                try {
                    URI uri = URI.create("http://textures.minecraft.net/texture/" + texture);
                    URL url = uri.toURL();
                    PlayerTextures textures = profile.getTextures();
                    textures.setSkin(url);
                    profile.setTextures(textures);
                    meta.setOwnerProfile(profile);
                    if (title != null) {
                        meta.setDisplayName(title);
                    }
                    if (lore != null && !lore.isEmpty()) {
                        meta.setLore(lore);
                    }
                    head.setItemMeta((ItemMeta)meta);
                }
                catch (MalformedURLException e) {
                    return head;
                }
            }
        }
        return head;
    }

    public CompletableFuture<String> getSkinURL(String uuid) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.scheduler.schedule(() -> {
            try {
                URI uri = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
                URL url = uri.toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                if (connection.getResponseCode() == 200) {
                    InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                    JsonObject response = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    JsonObject properties = response.getAsJsonArray("properties").get(0).getAsJsonObject();
                    String value = properties.get("value").getAsString();
                    String decodedValue = new String(Base64.getDecoder().decode(value));
                    JsonObject textureProperty = JsonParser.parseString((String)decodedValue).getAsJsonObject();
                    future.complete(textureProperty.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, (long)(this.requestCount++ * 50), TimeUnit.MILLISECONDS);
        return future;
    }

    public String getSkinURLWithoutDelay(String uuid) {
        try {
            URI uri = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
            URL url = uri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                JsonObject response = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject properties = response.getAsJsonArray("properties").get(0).getAsJsonObject();
                String value = properties.get("value").getAsString();
                String decodedValue = new String(Base64.getDecoder().decode(value));
                JsonObject textureProperty = JsonParser.parseString((String)decodedValue).getAsJsonObject();
                return textureProperty.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getUUIDFromMojang(String playerName) {
        block7: {
            String string;
            URI uri = URI.create("https://api.mojang.com/users/profiles/minecraft/" + playerName);
            URL url = uri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() != 200) break block7;
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            try {
                JsonObject responseJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                string = this.addDashesToUUID(responseJson.get("id").getAsString());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return string;
        }
        return null;
    }

    public void removeCPlayer(UUID targetUUID) {
        this.players.remove(targetUUID);
    }

    public CPlayer getCPlayer(UUID targetUUID) {
        return this.players.get(targetUUID);
    }

    public String getPlayerName(UUID targetUUID) {
        String name = this.playersName.get(targetUUID);
        return name == null ? Bukkit.getOfflinePlayer((UUID)targetUUID).getName() : name;
    }

    public UUID getPlayerUUID(String targetName) {
        if (targetName == null) {
            return null;
        }
        UUID uuid = this.playersUUID.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(targetName)).map(Map.Entry::getValue).findFirst().orElse(null);
        return uuid != null ? uuid : Bukkit.getOfflinePlayer((String)targetName).getUniqueId();
    }

    public void setPlayersConfigSettings(Map<UUID, Map<String, Double>> p) {
        this.playersConfigSettings = p;
    }

    public void updatePlayerConfigSettings(UUID playerId, String key, Double value) {
        this.playersConfigSettings.computeIfAbsent(playerId, k -> new HashMap()).put(key, value);
    }

    public boolean canAddMember(Player player, Claim claim) {
        if (player.hasPermission("scs.admin")) {
            return true;
        }
        CPlayer cPlayer = this.players.get(player.getUniqueId());
        int i = claim.getMembers().size();
        int nb_members = cPlayer.getMaxMembers();
        return nb_members == 0 || nb_members > i;
    }

    public boolean checkPermPlayer(Player player, String perm) {
        return player.hasPermission("scs.admin") ? true : player.hasPermission(perm);
    }

    public void activePlayerFly(Player player) {
        CPlayer cPlayer = this.players.get(player.getUniqueId());
        if (!player.getAllowFlight()) {
            player.setAllowFlight(true);
        }
        player.setFlying(true);
        cPlayer.setClaimFly(true);
    }

    public void removePlayerFly(Player player) {
        CPlayer cPlayer = this.players.get(player.getUniqueId());
        if (cPlayer.getClaimFly().booleanValue()) {
            GameMode pMode = player.getGameMode();
            if (pMode.equals((Object)GameMode.ADVENTURE) || pMode.equals((Object)GameMode.SURVIVAL)) {
                player.setFlying(false);
                player.setAllowFlight(false);
            }
            cPlayer.setClaimFly(false);
        }
    }

    public Map<String, Double> getPlayerConfig(UUID uuid) {
        return this.playersConfigSettings.get(uuid);
    }

    public void addPlayerPermSetting(Player player) {
        this.instance.executeAsync(() -> {
            UUID playerId = player.getUniqueId();
            this.players.put(playerId, new CPlayer(player, playerId, this.instance.getMain().getPlayerClaimsCount(playerId), this.instance));
        });
    }
}

