/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS;

import java.util.HashSet;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class CScoreboard {
    private Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
    private Objective objective;

    public CScoreboard(String title) {
        this.objective = this.scoreboard.registerNewObjective(" ", " ", title);
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    public void addLine(String line, int score) {
        Score s = this.objective.getScore(line);
        s.setScore(score);
    }

    public void showToPlayer(Player player) {
        player.setScoreboard(this.scoreboard);
    }

    public void removeFromPlayer(Player player) {
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    public void updateLine(String oldLine, String newLine, int score) {
        this.scoreboard.resetScores(oldLine);
        this.addLine(newLine, score);
    }

    public void updateLines(Map<Integer, String> linesMap) {
        HashSet existingEntries = new HashSet(this.scoreboard.getEntries());
        for (Map.Entry<Integer, String> entry : linesMap.entrySet()) {
            int score = entry.getKey();
            String newLine = entry.getValue();
            existingEntries.stream().filter(line -> this.objective.getScore(line).getScore() == score).findFirst().ifPresent(arg_0 -> ((Scoreboard)this.scoreboard).resetScores(arg_0));
            this.addLine(newLine, score);
        }
    }

    public void clear() {
        if (this.scoreboard != null) {
            this.scoreboard.getEntries().forEach(arg_0 -> ((Scoreboard)this.scoreboard).resetScores(arg_0));
        }
    }
}

