/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Commands;

import fr.xyness.SCS.ClaimMain;
import fr.xyness.SCS.Commands.ClaimCommand;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimBansGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimChunksGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimMainGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimMembersGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimsProtectedAreasGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import fr.xyness.SCS.Types.WorldMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ProtectedAreaCommand
implements CommandExecutor,
TabCompleter {
    private SimpleClaimSystem instance;

    public ProtectedAreaCommand(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
            ArrayList<String> completions = new ArrayList<String>();
            if (args.length == 1) {
                completions.addAll(this.getPrimaryCompletions(args));
            } else if (args.length == 2) {
                completions.addAll(this.getSecondaryCompletions(sender, args));
            } else if (args.length == 3) {
                completions.addAll(this.getTertiaryCompletions(sender, args));
            }
            return completions;
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return new ArrayList<String>();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.instance.getLanguage().getMessage("command-only-by-players"));
            return true;
        }
        Player player = (Player)sender;
        String playerName = player.getName();
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        if (args.length > 1 && args[0].equals("setdesc")) {
            this.handleDesc(player, args);
            return true;
        }
        switch (args.length) {
            case 0: {
                this.handleArgZero(player);
                break;
            }
            case 1: {
                this.handleArgOne(player, playerName, cPlayer, args);
                break;
            }
            case 2: {
                this.handleArgTwo(player, playerName, cPlayer, args);
                break;
            }
            case 3: {
                this.handleArgThree(player, playerName, cPlayer, args);
                break;
            }
            default: {
                this.instance.getMain().getHelp(player, args[0], "parea");
            }
        }
        return true;
    }

    private void handleDesc(Player player, String[] args) {
        if (this.instance.getMain().getClaimsNameFromOwner("*").contains(args[1])) {
            String description = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
            if (description.length() > Integer.parseInt(this.instance.getSettings().getSetting("max-length-claim-description"))) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-description-too-long"));
                return;
            }
            if (!description.matches("^[a-zA-Z0-9]+$")) {
                player.sendMessage(this.instance.getLanguage().getMessage("incorrect-characters-description"));
                return;
            }
            Claim claim = this.instance.getMain().getProtectedAreaByName(args[1]);
            ((CompletableFuture)this.instance.getMain().setClaimDescription(claim, description).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("claim-set-description-success").replace("%name%", args[1]).replace("%description%", description)));
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
    }

    private void handleArgThree(Player player, String playerName, CPlayer cPlayer, String[] args) {
        if (args[0].equalsIgnoreCase("delchunk")) {
            int n;
            int X_;
            Claim claim = this.instance.getMain().getProtectedAreaByName(args[1]);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (claim.getChunks().size() == 1) {
                player.sendMessage(this.instance.getLanguage().getMessage("cannot-remove-only-remaining-chunk"));
                return;
            }
            String[] parts = args[2].split(";");
            World world = Bukkit.getWorld((String)parts[0]);
            if (world == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-does-not-exist"));
                return;
            }
            try {
                X_ = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.instance.getLanguage().getMessage("x-z-must-be-integer"));
                return;
            }
            try {
                n = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.instance.getLanguage().getMessage("x-z-must-be-integer"));
                return;
            }
            if (this.instance.isFolia()) {
                world.getChunkAtAsync(X_, n).thenAccept(chunk -> {
                    HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
                    if (!chunks.contains(chunk)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("chunk-not-in-claim"));
                        return;
                    }
                    chunks.remove(chunk);
                    if (!this.instance.getMain().areChunksConnected(chunks)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("chunks-are-not-connected-delchunk"));
                        return;
                    }
                    ((CompletableFuture)this.instance.getMain().removeClaimChunk(claim, (Chunk)chunk).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-chunk-success").replace("%chunk%", "[" + args[2] + "]").replace("%claim-name%", claim.getName())));
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error-delete-chunk")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                });
            } else {
                Chunk chunk2 = world.getChunkAt(X_, n);
                HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
                if (!chunks.contains(chunk2)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("chunk-not-in-claim"));
                    return;
                }
                chunks.remove(chunk2);
                if (!this.instance.getMain().areChunksConnected(chunks)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("chunks-are-not-connected-delchunk"));
                    return;
                }
                ((CompletableFuture)this.instance.getMain().removeClaimChunk(claim, chunk2).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-chunk-success").replace("%chunk%", "[" + args[2] + "]").replace("%claim-name%", claim.getName())));
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error-delete-chunk")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            }
            return;
        }
        if (args[0].equalsIgnoreCase("merge")) {
            CustomSet<String> claimsName = this.instance.getMain().getClaimsNameFromOwner("*");
            if (!claimsName.contains(args[1])) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Claim claim1 = this.instance.getMain().getProtectedAreaByName(args[1]);
            HashSet<Object> claims = new HashSet<Object>();
            if (args[2].equals("*")) {
                claims.addAll(this.instance.getMain().getProtectedAreas());
                claims.remove(claim1);
                if (claims.size() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("no-claim-can-be-merged"));
                    return;
                }
            } else if (args[2].contains(";")) {
                for (String c2 : args[2].split(";")) {
                    if (!claimsName.contains(c2)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                        return;
                    }
                    claims.add(this.instance.getMain().getProtectedAreaByName(c2));
                }
            } else {
                if (!claimsName.contains(args[2])) {
                    player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                    return;
                }
                Claim claim2 = this.instance.getMain().getProtectedAreaByName(args[2]);
                claims.add(claim2);
            }
            if (claims.contains(claim1)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-merge-same-claim"));
                return;
            }
            for (Claim claim : claims) {
                if (this.instance.getMain().isAnyChunkAdjacentBetweenSets(new CustomSet<Chunk>((Collection<Chunk>)claim1.getChunks()), new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks()))) continue;
                player.sendMessage(this.instance.getLanguage().getMessage("one-chunk-of-claim-must-be-adjacent"));
                return;
            }
            HashSet<Chunk> chunks = new HashSet<Chunk>(claim1.getChunks());
            claims.forEach(c -> chunks.addAll(c.getChunks()));
            if (!cPlayer.canClaimWithNumber(chunks.size() + claim1.getChunks().size())) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                return;
            }
            if (!this.instance.getMain().areChunksInSameWorld(chunks)) {
                player.sendMessage(this.instance.getLanguage().getMessage("chunks-must-be-from-same-world"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().mergeClaims(claim1, new CustomSet<Claim>((Collection<Claim>)claims)).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("claims-are-now-merged").replace("%claim-name%", claim1.getName())));
                    if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                        this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)claim1.getChunks()), true, false);
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("kick")) {
            if (args[1].equalsIgnoreCase("*")) {
                if (this.instance.getMain().getProtectedAreasCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("no-admin-claim"));
                    return;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                    return;
                }
                if (target.getName().equals(playerName)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("can-not-kick-yourself"));
                    return;
                }
                if (!this.instance.getMain().getAllChunksFromAllClaims("*").contains(target.getLocation().getChunk())) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-not-in-any-claim").replace("%player%", target.getName()));
                    return;
                }
                player.sendMessage(this.instance.getLanguage().getMessage("kick-success-all-protected-areas").replace("%player%", target.getName()));
                target.sendMessage(this.instance.getLanguage().getMessage("kicked-from-all-protected-areas").replace("%player%", playerName));
                this.instance.getMain().teleportPlayerToExpulsion(target);
                return;
            }
            Claim claim = this.instance.getMain().getProtectedAreaByName(args[1]);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            if (target == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                return;
            }
            if (target.getName().equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("can-not-kick-yourself"));
                return;
            }
            if (!claim.getChunks().contains(target.getLocation().getChunk())) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-not-in-the-protected-area").replace("%player%", target.getName()).replace("%claim-name%", claim.getName()));
                return;
            }
            String claimName = claim.getName();
            player.sendMessage(this.instance.getLanguage().getMessage("kick-success-protected-area").replace("%player%", target.getName()).replace("%claim-name%", claimName));
            target.sendMessage(this.instance.getLanguage().getMessage("kicked-from-protected-area").replace("%player%", playerName).replace("%claim-name%", claimName));
            this.instance.getMain().teleportPlayerToExpulsion(target);
            return;
        }
        if (args[0].equalsIgnoreCase("ban")) {
            if (args[1].equalsIgnoreCase("*")) {
                if (this.instance.getMain().getProtectedAreasCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("no-admin-claim"));
                    return;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                String[] targetName = new String[]{""};
                Runnable task = () -> this.instance.executeSync(() -> {
                    if (targetName[0].equals(playerName)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("cant-ban-yourself"));
                        return;
                    }
                    String message = this.instance.getLanguage().getMessage("add-ban-all-success").replace("%player%", targetName[0]);
                    ((CompletableFuture)this.instance.getMain().addAllClaimBan("*", targetName[0]).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                            if (target != null && target.isOnline()) {
                                if (this.instance.getMain().getAllChunksFromAllProtectedAreas().contains(target.getLocation().getChunk())) {
                                    this.instance.executeEntitySync(target, () -> this.instance.getMain().teleportPlayerToExpulsion(target));
                                }
                                this.instance.executeEntitySync(target, () -> {
                                    target.sendMessage(this.instance.getLanguage().getMessage("banned-all-claim-protected-area-player"));
                                    target.sendMessage(this.instance.getLanguage().getMessage("remove-all-claim-protected-area-player"));
                                });
                            }
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                });
                if (target == null) {
                    this.instance.getOfflinePlayer(args[2], otarget -> {
                        if (otarget == null || !otarget.hasPlayedBefore()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                            return;
                        }
                        targetName[0] = otarget.getName();
                        task.run();
                    });
                } else {
                    targetName[0] = target.getName();
                    task.run();
                }
                return;
            }
            Claim claim = this.instance.getMain().getProtectedAreaByName(args[1]);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            String[] targetName = new String[]{""};
            Runnable task = () -> this.instance.executeSync(() -> {
                if (targetName[0].equals(playerName)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-ban-yourself"));
                    return;
                }
                if (this.instance.getMain().checkBan(claim, targetName[0])) {
                    String message = this.instance.getLanguage().getMessage("already-banned").replace("%player%", targetName[0]);
                    player.sendMessage(message);
                    return;
                }
                String message = this.instance.getLanguage().getMessage("add-ban-success").replace("%player%", targetName[0]).replace("%claim-name%", claim.getName());
                ((CompletableFuture)this.instance.getMain().addClaimBan(claim, targetName[0]).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                        if (target != null && target.isOnline()) {
                            String claimName = claim.getName();
                            if (claim.getChunks().contains(target.getLocation().getChunk())) {
                                this.instance.executeEntitySync(target, () -> this.instance.getMain().teleportPlayerToExpulsion(target));
                            }
                            this.instance.executeEntitySync(target, () -> {
                                target.sendMessage(this.instance.getLanguage().getMessage("banned-claim-protected-area-player").replace("%claim-name%", claimName));
                                target.sendMessage(this.instance.getLanguage().getMessage("remove-claim-protected-area-player").replace("%claim-name%", claimName));
                            });
                        }
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            });
            if (target == null) {
                this.instance.getOfflinePlayer(args[2], otarget -> {
                    if (otarget == null || !otarget.hasPlayedBefore()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    targetName[0] = otarget.getName();
                    task.run();
                });
            } else {
                targetName[0] = target.getName();
                task.run();
            }
            return;
        }
        if (args[0].equalsIgnoreCase("unban")) {
            if (args[1].equalsIgnoreCase("*") && this.instance.getMain().getProtectedAreasCount() == 0) {
                player.sendMessage(this.instance.getLanguage().getMessage("no-admin-claim"));
                return;
            }
            Claim claim = this.instance.getMain().getProtectedAreaByName(args[1]);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (!this.instance.getMain().checkBan(claim, args[2])) {
                String message = this.instance.getLanguage().getMessage("not-banned").replace("%player%", args[2]);
                player.sendMessage(message);
                return;
            }
            String targetName = this.instance.getMain().getRealNameFromClaimBans(claim, args[2]);
            String message = this.instance.getLanguage().getMessage("remove-ban-success").replace("%player%", targetName).replace("%claim-name%", claim.getName());
            ((CompletableFuture)this.instance.getMain().removeClaimBan(claim, targetName).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    Player target = Bukkit.getPlayer((String)targetName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("unbanned-claim-protected-area-player").replace("%claim-name%", claim.getName())));
                    }
                } else {
                    player.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("setname")) {
            if (!this.instance.getMain().checkName(ClaimMain.SERVER_UUID, args[1])) {
                if (args[2].contains("claim-") || !args[2].matches("^[a-zA-Z0-9]+$")) {
                    player.sendMessage(this.instance.getLanguage().getMessage("you-cannot-use-this-name"));
                    return;
                }
                if (this.instance.getMain().checkName(ClaimMain.SERVER_UUID, args[2])) {
                    Claim claim = this.instance.getMain().getProtectedAreaByName(args[1]);
                    ((CompletableFuture)this.instance.getMain().setClaimName(claim, args[2]).thenAccept(success -> {
                        if (success.booleanValue()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("name-change-success").replace("%name%", args[2]));
                        } else {
                            player.sendMessage(this.instance.getLanguage().getMessage("error"));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                    return;
                }
                player.sendMessage(this.instance.getLanguage().getMessage("error-name-exists").replace("%name%", args[2]));
                return;
            }
            Chunk chunk3 = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk3)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk3);
            String owner = claim.getOwner();
            if (!owner.equals("*")) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-not-an-admin-claim"));
                return;
            }
            if (args[1].contains("claim-")) {
                player.sendMessage(this.instance.getLanguage().getMessage("you-cannot-use-this-name"));
                return;
            }
            if (this.instance.getMain().checkName(ClaimMain.SERVER_UUID, args[1])) {
                ((CompletableFuture)this.instance.getMain().setClaimName(claim, args[1]).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("name-change-success").replace("%name%", args[1])));
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            player.sendMessage(this.instance.getLanguage().getMessage("error-name-exists").replace("%name%", args[1]));
            return;
        }
        if (args[0].equalsIgnoreCase("add")) {
            if (args[1].equalsIgnoreCase("*")) {
                if (this.instance.getMain().getProtectedAreasCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("no-admin-claim"));
                    return;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                String[] targetName = new String[]{""};
                Runnable task = () -> this.instance.executeSync(() -> {
                    String message = this.instance.getLanguage().getMessage("add-member-success").replace("%player%", targetName[0]).replace("%claim-name%", this.instance.getLanguage().getMessage("protected-area-title"));
                    ((CompletableFuture)this.instance.getMain().addAllClaimsMember("*", targetName[0]).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                            if (target != null && target.isOnline()) {
                                this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("add-all-claim-protected-area-player")));
                            }
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                });
                if (target == null) {
                    this.instance.getOfflinePlayer(args[2], otarget -> {
                        if (otarget == null || !otarget.hasPlayedBefore()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                            return;
                        }
                        targetName[0] = otarget.getName();
                        task.run();
                    });
                } else {
                    targetName[0] = target.getName();
                    task.run();
                }
                return;
            }
            Claim claim = this.instance.getMain().getProtectedAreaByName(args[1]);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            String[] targetName = new String[]{""};
            Runnable task = () -> this.instance.executeSync(() -> {
                if (this.instance.getMain().checkMembre(claim, targetName[0])) {
                    String message = this.instance.getLanguage().getMessage("already-member").replace("%player%", targetName[0]);
                    player.sendMessage(message);
                    return;
                }
                String message = this.instance.getLanguage().getMessage("add-member-success").replace("%player%", targetName[0]).replace("%claim-name%", claim.getName());
                ((CompletableFuture)this.instance.getMain().addClaimMember(claim, targetName[0]).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                        if (target != null && target.isOnline()) {
                            this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("add-claim-protected-area-player").replace("%claim-name%", claim.getName())));
                        }
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            });
            if (target == null) {
                this.instance.getOfflinePlayer(args[2], otarget -> {
                    if (otarget == null || !otarget.hasPlayedBefore()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    targetName[0] = otarget.getName();
                    task.run();
                });
            } else {
                targetName[0] = target.getName();
                task.run();
            }
            return;
        }
        if (args[0].equalsIgnoreCase("remove")) {
            if (args[1].equalsIgnoreCase("*")) {
                if (this.instance.getMain().getProtectedAreasCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("no-admin-claim"));
                    return;
                }
                String targetName = args[2];
                String message = this.instance.getLanguage().getMessage("remove-member-success").replace("%player%", targetName).replace("%claim-name%", this.instance.getLanguage().getMessage("protected-area-title"));
                ((CompletableFuture)this.instance.getMain().removeAllClaimsMember("*", targetName).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                        Player target = Bukkit.getPlayer((String)targetName);
                        if (target != null && target.isOnline()) {
                            this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("remove-all-claim-protected-area-player")));
                        }
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            Claim claim = this.instance.getMain().getProtectedAreaByName(args[1]);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            String targetName = args[2];
            if (!this.instance.getMain().checkMembre(claim, targetName)) {
                String message = this.instance.getLanguage().getMessage("not-member").replace("%player%", targetName);
                player.sendMessage(message);
                return;
            }
            String realName = this.instance.getMain().getRealNameFromClaimMembers(claim, targetName);
            String message = this.instance.getLanguage().getMessage("remove-member-success").replace("%player%", realName).replace("%claim-name%", claim.getName());
            ((CompletableFuture)this.instance.getMain().removeClaimMember(claim, realName).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    Player target = Bukkit.getPlayer((String)realName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("remove-claim-protected-area-player").replace("%claim-name%", claim.getName())));
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        this.instance.getMain().getHelp(player, args[0], "parea");
    }

    private void handleArgTwo(Player player, String playerName, CPlayer cPlayer, String[] args) {
        Claim claim = this.instance.getMain().getProtectedAreaByName(args[1]);
        if (args[0].equalsIgnoreCase("addchunk")) {
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                Claim claim_target = this.instance.getMain().getClaim(chunk);
                if (claim_target.getOwner().equalsIgnoreCase("*")) {
                    if (claim_target.equals(claim)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-already-in-claim-protected-area").replace("%claim-name%", claim.getName()));
                        return;
                    }
                    player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-already-owner-protected-area").replace("%claim-name%", claim.getName()).replace("%claim-name-1%", claim_target.getName()));
                    return;
                }
                player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-not-owner"));
                return;
            }
            HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
            chunks.add(chunk);
            if (!this.instance.getMain().areChunksInSameWorld(chunks)) {
                player.sendMessage(this.instance.getLanguage().getMessage("chunks-must-be-from-same-world"));
                return;
            }
            chunks.remove(chunk);
            if (!this.instance.getMain().isAnyChunkAdjacent(chunks, chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("one-chunk-must-be-adjacent"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().addClaimChunk(claim, chunk).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-successful").replace("%chunk%", "[" + chunk.getWorld().getName() + ";" + String.valueOf(chunk.getX()) + ";" + String.valueOf(chunk.getZ()) + "]").replace("%claim-name%", claim.getName())));
                    if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                        this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks()), true, false);
                    }
                    return;
                }
                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("unclaim")) {
            if (claim == null) {
                if (args[1].equalsIgnoreCase("*")) {
                    ((CompletableFuture)this.instance.getMain().deleteAllClaims("*").thenAccept(success -> {
                        if (success.booleanValue()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success"));
                        } else {
                            player.sendMessage(this.instance.getLanguage().getMessage("error"));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                    return;
                }
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-claim-protected-area")));
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("main")) {
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            new AdminGestionClaimMainGui(player, claim, this.instance);
        }
        if (args[0].equalsIgnoreCase("bans")) {
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            cPlayer.setGuiPage(1);
            new AdminGestionClaimBansGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("tp")) {
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            this.instance.getMain().goClaim(player, claim.getLocation());
            return;
        }
        if (args[0].equalsIgnoreCase("members")) {
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            cPlayer.setGuiPage(1);
            new AdminGestionClaimMembersGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("chunks")) {
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            cPlayer.setGuiPage(1);
            new AdminGestionClaimChunksGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("settings")) {
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            new AdminGestionClaimGui(player, claim, this.instance, "visitors");
            return;
        }
        this.instance.getMain().getHelp(player, args[0], "parea");
    }

    private void handleArgOne(Player player, String playerName, CPlayer cPlayer, String[] args) {
        if (args[0].equalsIgnoreCase("bans")) {
            Chunk chunk = player.getLocation().getChunk();
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            String owner = claim.getOwner();
            if (owner.equals("*")) {
                cPlayer.setGuiPage(1);
                new AdminGestionClaimBansGui(player, claim, 1, this.instance);
                return;
            }
            player.sendMessage(this.instance.getLanguage().getMessage("claim-not-an-admin-claim"));
            return;
        }
        if (args[0].equalsIgnoreCase("settings")) {
            Chunk chunk = player.getLocation().getChunk();
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            String owner = claim.getOwner();
            if (owner.equals("*")) {
                new AdminGestionClaimGui(player, claim, this.instance, "visitors");
                return;
            }
            player.sendMessage(this.instance.getLanguage().getMessage("claim-not-an-admin-claim"));
            return;
        }
        if (args[0].equalsIgnoreCase("list")) {
            cPlayer.setGuiPage(1);
            new AdminGestionClaimsProtectedAreasGui(player, 1, "all", this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("members")) {
            Chunk chunk = player.getLocation().getChunk();
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            String owner = claim.getOwner();
            if (!owner.equals("*")) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-not-an-admin-claim"));
                return;
            }
            cPlayer.setGuiPage(1);
            new AdminGestionClaimMembersGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("chunks")) {
            Chunk chunk = player.getLocation().getChunk();
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            String owner = claim.getOwner();
            if (!owner.equals("*")) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-not-an-admin-claim"));
                return;
            }
            cPlayer.setGuiPage(1);
            new AdminGestionClaimChunksGui(player, claim, 1, this.instance);
            return;
        }
        String world = player.getWorld().getName();
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", player.getWorld().getName()));
            return;
        }
        try {
            int radius = Integer.parseInt(args[0]);
            ClaimCommand.getChunksInRadius(player, player.getLocation(), radius, this.instance).thenAccept(chunks -> {
                Set chunksToClaim = chunks.stream().filter(c -> !this.instance.getMain().checkIfClaimExists((Chunk)c)).collect(Collectors.toSet());
                if (chunks.size() != chunksToClaim.size()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cant-radius-claim-already-claim")));
                    return;
                }
                ((CompletableFuture)this.instance.getMain().createAdminClaimRadius(player, new CustomSet<Chunk>((Collection<Chunk>)chunks), radius).thenAccept(success -> {
                    if (success.booleanValue()) {
                        if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                            this.instance.executeSync(() -> this.instance.getMain().displayChunkBorderWithRadius(player, radius));
                        }
                        this.instance.executeAsyncLocation(() -> {
                            Claim claim = this.instance.getMain().getClaim(player.getLocation().getChunk());
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("create-protected-area-radius-success").replace("%number%", this.instance.getMain().getNumberSeparate(String.valueOf(chunks.size()))).replace("%claim-name%", claim.getName())));
                        }, player.getLocation());
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            });
        }
        catch (NumberFormatException e) {
            this.instance.getMain().getHelp(player, args[0], "parea");
        }
    }

    private void handleArgZero(Player player) {
        Chunk chunk = player.getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals("*")) {
                player.sendMessage(this.instance.getLanguage().getMessage("create-already-claim").replace("%player%", owner));
                return;
            }
            new AdminGestionClaimMainGui(player, claim, this.instance);
            return;
        }
        String world = player.getWorld().getName();
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", player.getWorld().getName()));
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            this.instance.getMain().handleClaimConflict(player, chunk);
            return;
        }
        ((CompletableFuture)this.instance.getMain().createAdminClaim(player, chunk).thenAccept(success -> {
            if (success.booleanValue()) {
                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("create-protected-area-success")));
                if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                    this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)Set.of(chunk)), true, false);
                }
            } else {
                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    private List<String> getPrimaryCompletions(String[] args) {
        String partialInput = args.length > 0 ? args[0].toLowerCase() : "";
        List<String> completions = List.of("setdesc", "settings", "setname", "members", "tp", "list", "ban", "unban", "bans", "add", "remove", "unclaim", "main", "merge", "addchunk", "delchunk", "chunks", "kick");
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }

    private List<String> getSecondaryCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String command = args[0].toLowerCase();
        String partialInput = args.length > 1 ? args[1].toLowerCase() : "";
        switch (command) {
            case "ban": 
            case "unban": 
            case "add": {
                completions.add("*");
            }
            case "bans": 
            case "setdesc": 
            case "settings": 
            case "setname": 
            case "tp": 
            case "members": 
            case "merge": 
            case "addchunk": 
            case "delchunk": 
            case "chunks": {
                completions.addAll(this.instance.getMain().getClaimsNameFromOwner("*"));
                break;
            }
            case "remove": 
            case "unclaim": 
            case "kick": {
                completions.add("*");
                completions.addAll(this.instance.getMain().getClaimsNameFromOwner("*"));
                break;
            }
        }
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }

    private List<String> getTertiaryCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String command = args[0].toLowerCase();
        String claimName = args[1];
        Claim claim = this.instance.getMain().getProtectedAreaByName(claimName);
        if (claim == null) {
            return completions;
        }
        String partialInput = args.length > 2 ? args[2].toLowerCase() : "";
        switch (command) {
            case "unban": {
                completions.addAll(this.instance.getMain().convertUUIDSetToStringSet(claim.getBans()));
                break;
            }
            case "ban": 
            case "add": 
            case "kick": {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                break;
            }
            case "remove": {
                if (!claimName.equals("*")) {
                    completions.addAll(this.instance.getMain().convertUUIDSetToStringSet(claim.getMembers()));
                    break;
                }
                completions.addAll(this.instance.getMain().getAllMembersOfAllPlayerClaim("*"));
                break;
            }
            case "merge": {
                completions.addAll(this.instance.getMain().getClaimsNameFromOwner("*"));
                completions.remove(args[1]);
                break;
            }
            case "delchunk": {
                if (claim == null) break;
                completions.addAll(this.instance.getMain().getStringChunkFromClaim(claim));
                break;
            }
        }
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }
}

