/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.AdminGestion;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminGestionClaimChunksGui
implements InventoryHolder {
    private Inventory inv;
    private SimpleClaimSystem instance;

    public AdminGestionClaimChunksGui(Player player, Claim claim, int page, SimpleClaimSystem instance) {
        this.instance = instance;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)("\u00a74[A]\u00a7r Chunks: " + claim.getName() + " (" + claim.getOwner() + ")"));
        ((CompletableFuture)this.loadItems(player, claim, page).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(Player player, Claim claim, int page) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
            cPlayer.setClaim(claim);
            cPlayer.clearMapString();
            cPlayer.setGuiPage(page);
            int min_member_slot = 0;
            int max_member_slot = 44;
            int items_count = max_member_slot - min_member_slot + 1;
            if (page > 1) {
                this.inv.setItem(48, this.backPage(page - 1));
            }
            this.inv.setItem(49, this.backMainMenu(claim.getName()));
            ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77The chunk is part of the claim", claim.getChunks().size() == 1 ? "\u00a7cYou can't remove the only remaining chunk" : "\u00a7c[Left-click]\u00a77 to remove chunk"));
            int startItem = (page - 1) * items_count;
            int i = min_member_slot;
            int count = 0;
            int chunk_count = 0;
            for (Chunk chunk : claim.getChunks()) {
                ++chunk_count;
                if (count++ < startItem) continue;
                if (i == max_member_slot + 1) {
                    this.inv.setItem(50, this.nextPage(page + 1));
                    break;
                }
                cPlayer.addMapString(i, String.valueOf(chunk.getWorld().getName() + ";" + chunk.getX() + ";" + chunk.getZ()));
                ItemStack item = new ItemStack(Material.RED_MUSHROOM_BLOCK);
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName("\u00a76Chunk-" + String.valueOf(chunk_count) + " \u00a77(" + String.valueOf(chunk.getWorld().getName() + ", X:" + chunk.getX() + ", Z:" + chunk.getZ()) + ")");
                meta.setLore(lore);
                item.setItemMeta(meta);
                this.inv.setItem(i, item);
                ++i;
            }
            return true;
        });
    }

    private ItemStack backMainMenu(String claim_name) {
        ItemStack item = new ItemStack(Material.DARK_OAK_DOOR);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7cMain menu");
            meta.setLore(this.instance.getGuis().getLore("\u00a77Go back to the main menu of " + claim_name + "\n\u00a77\u25b8 \u00a7fClick to access"));
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack backPage(int page) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7cPrevious page");
            meta.setLore(Arrays.asList("\u00a77Go to the page " + String.valueOf(page), "\u00a77\u25b8 \u00a7fClick to access"));
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack nextPage(int page) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7cNext page");
            meta.setLore(Arrays.asList("\u00a77Go to the page " + String.valueOf(page), "\u00a77\u25b8 \u00a7fClick to access"));
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
    }
}

