/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.AdminGestion;

import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminGestionClaimGui
implements InventoryHolder {
    private Inventory inv;
    private SimpleClaimSystem instance;

    public AdminGestionClaimGui(Player player, Claim claim, SimpleClaimSystem instance, String role) {
        this.instance = instance;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)("\u00a74[A]\u00a7r Settings: " + claim.getName() + " (" + (switch (role) {
            case "members" -> "Members";
            case "natural" -> "Natural";
            default -> "Visitors";
        }) + " - " + claim.getOwner() + ")"));
        ((CompletableFuture)this.loadItems(player, claim, role).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(Player player, Claim claim, String role) {
        return CompletableFuture.supplyAsync(() -> {
            String default_statut_disabled = this.instance.getLanguage().getMessage("status-disabled");
            String default_statut_enabled = this.instance.getLanguage().getMessage("status-enabled");
            String default_choix_disabled = this.instance.getLanguage().getMessage("choice-disabled");
            String default_choix_enabled = this.instance.getLanguage().getMessage("choice-enabled");
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
            cPlayer.setClaim(claim);
            cPlayer.setFilter(role);
            cPlayer.setOwner(claim.getOwner());
            this.inv.setItem(48, this.role(role));
            for (String key : this.instance.getGuis().getPerms(role)) {
                String lower_name = key.toLowerCase();
                ArrayList<String> lore = new ArrayList<String>(this.instance.getGuis().getLore(this.instance.getLanguage().getMessage(lower_name + "-lore")));
                if (!this.instance.getGuis().isAPerm(key, role)) continue;
                boolean permission = claim.getPermission(key, role);
                String statut = permission ? default_statut_enabled : default_statut_disabled;
                String choix = permission ? default_choix_enabled : default_choix_disabled;
                lore.add(this.instance.getSettings().isEnabled(key) ? choix : this.instance.getLanguage().getMessage("choice-setting-disabled"));
                this.inv.setItem(AdminGestionClaimGui.getSlotByKey(key), this.instance.getGuis().createItem(AdminGestionClaimGui.getMaterialByKey(key), this.instance.getLanguage().getMessage(lower_name + "-title").replace("%status%", statut), lore));
            }
            this.inv.setItem(49, this.backMainMenu(claim.getName()));
            this.inv.setItem(50, this.instance.getGuis().createItem(Material.GREEN_CONCRETE, "\u00a7cApply settings to all his claims", Arrays.asList("\u00a77Apply these settings to all claims", "\u00a77of " + claim.getOwner() + ".", " ", "\u00a77\u25b8\u00a7f Click to apply")));
            return true;
        });
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public void openInventory(Player player) {
        player.openInventory(this.inv);
    }

    public static int getSlotByKey(String key) {
        return ClaimGuis.keyToSlotMap.getOrDefault(key, -1);
    }

    public static Material getMaterialByKey(String key) {
        return ClaimGuis.keyToMaterialMap.getOrDefault(key, null);
    }

    private ItemStack backMainMenu(String claim_name) {
        ItemStack item = new ItemStack(Material.DARK_OAK_DOOR);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7cMain menu");
            meta.setLore(this.instance.getGuis().getLore("\u00a77Go back to the main menu of " + claim_name + "\n\u00a77\u25b8 \u00a7fClick to access"));
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack role(String role) {
        ItemStack item = new ItemStack(Material.END_CRYSTAL);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String loreFilter = "\u00a77Change the target role\n%status_color_1%\u27b2 Visitors\n%status_color_2%\u27b2 Members\n%status_color_3%\u27b2 Natural\n\u00a77\u25b8 \u00a7fClick to change".replaceAll("%status_color_" + this.getStatusIndex(role) + "%", this.instance.getLanguage().getMessage("status_color_active_filter")).replaceAll("%status_color_[^" + this.getStatusIndex(role) + "]%", this.instance.getLanguage().getMessage("status_color_inactive_filter"));
            meta.setDisplayName("\u00a7eRole");
            meta.setLore(this.instance.getGuis().getLore(loreFilter));
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    private int getStatusIndex(String role) {
        switch (role) {
            case "members": {
                return 2;
            }
            case "natural": {
                return 3;
            }
        }
        return 1;
    }
}

