/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.AdminGestion;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class AdminGestionClaimsGui
implements InventoryHolder {
    private final Inventory inv;
    private SimpleClaimSystem instance;

    public AdminGestionClaimsGui(Player player, int page, String filter, SimpleClaimSystem instance) {
        this.instance = instance;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)("\u00a74[A]\u00a7r Claims (Page " + String.valueOf(page) + ")"));
        ((CompletableFuture)this.loadItems(player, page, filter).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    private CompletableFuture<Boolean> loadItems(Player player, int page, String filter) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
            cPlayer.setFilter(filter);
            cPlayer.clearMapString();
            cPlayer.setGuiPage(page);
            this.inv.setItem(48, this.backPage(page - 1, page <= 1));
            Map<String, Integer> owners = this.getOwnersByFilter(filter);
            LinkedHashMap sortedOwners = owners.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            this.inv.setItem(49, this.createFilterItem(filter));
            int maxSlot = 44;
            int minSlot = 0;
            int itemsPerPage = maxSlot - minSlot + 1;
            int startItem = (page - 1) * itemsPerPage;
            int i = minSlot;
            int count = 0;
            for (Map.Entry entry : sortedOwners.entrySet()) {
                if (count++ < startItem) continue;
                if (i > maxSlot) {
                    this.inv.setItem(50, this.nextPage(page + 1));
                    break;
                }
                String owner = (String)entry.getKey();
                int claimAmount = (Integer)entry.getValue();
                ArrayList<String> lore = new ArrayList<String>(this.getLore("\u00a77Claims: \u00a7b" + this.instance.getMain().getNumberSeparate(String.valueOf(claimAmount)) + "\n \n\u00a7c[Left-click]\u00a77 to display their claims\n\u00a7c[Shift-left-click]\u00a77 to remove all their claims"));
                cPlayer.addMapString(i, owner);
                this.inv.setItem(i, this.createOwnerClaimItem(owner, lore));
                ++i;
            }
            return true;
        });
    }

    private Map<String, Integer> getOwnersByFilter(String filter) {
        switch (filter) {
            case "sales": {
                return this.instance.getMain().getClaimsOwnersWithSales();
            }
            case "online": {
                return this.instance.getMain().getClaimsOnlineOwners();
            }
            case "offline": {
                return this.instance.getMain().getClaimsOfflineOwners();
            }
        }
        return this.instance.getMain().getClaimsOwnersGui();
    }

    private ItemStack createOwnerClaimItem(String owner, List<String> lore) {
        String title = "\u00a7e" + owner;
        return this.createPlayerHeadItem(owner, title, lore);
    }

    private ItemStack createPlayerHeadItem(String owner, String title, List<String> lore) {
        ItemStack item = this.instance.getPlayerMain().getPlayerHead(owner);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setDisplayName(title);
        meta.setLore(lore);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material != null ? material : Material.STONE, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(lore);
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createFilterItem(String filter) {
        String loreFilter = "\u00a77Change filter\n%status_color_1%\u27b2 All owners\n%status_color_2%\u27b2 Owners with claims in sale\n%status_color_3%\u27b2 Online owners\n%status_color_4%\u27b2 Offline owners\n\u00a77\u25b8 \u00a7fClick to change".replaceAll("%status_color_" + this.getStatusIndex(filter) + "%", "\u00a7a").replaceAll("%status_color_[^" + this.getStatusIndex(filter) + "]%", "\u00a78");
        return this.createItem(Material.END_CRYSTAL, "\u00a7eFilter", this.getLore(loreFilter));
    }

    private int getStatusIndex(String filter) {
        switch (filter) {
            case "sales": {
                return 2;
            }
            case "online": {
                return 3;
            }
            case "offline": {
                return 4;
            }
        }
        return 1;
    }

    private ItemStack backPage(int page, boolean back) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7cPrevious page");
            meta.setLore(Arrays.asList(back ? "\u00a77Go back to admin main menu" : "\u00a77Go to the page " + String.valueOf(page), "\u00a77\u25b8 \u00a7fClick to access"));
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack nextPage(int page) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7cNext page");
            meta.setLore(Arrays.asList("\u00a77Go to the page " + String.valueOf(page), "\u00a77\u25b8 \u00a7fClick to access"));
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    public List<String> getLore(String lore) {
        return Arrays.asList(lore.split("\n"));
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

