/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.Bedrock;

import fr.xyness.SCS.Guis.Bedrock.BClaimMainGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.Claim;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class BClaimBansGui {
    private final SimpleClaimSystem instance;
    private final FloodgatePlayer floodgatePlayer;

    public BClaimBansGui(Player player, Claim claim, SimpleClaimSystem instance) {
        this.instance = instance;
        this.floodgatePlayer = FloodgateApi.getInstance().getPlayer(player.getUniqueId());
        SimpleForm.Builder form = (SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(instance.getLanguage().getMessage("bedrock-gui-bans-title").replace("%name%", claim.getName()))).button(instance.getLanguage().getMessage("bedrock-back-page-main")).content(instance.getLanguage().getMessage("bedrock-gui-bans-click")).validResultHandler(response -> {
            if (response.clickedButtonId() == 0) {
                new BClaimMainGui(player, claim, instance);
                return;
            }
            String banned = response.clickedButton().text();
            if (player.getName().equals(banned)) {
                return;
            }
            if (instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.unban")) {
                String message = instance.getLanguage().getMessage("remove-ban-success").replace("%player%", banned).replace("%claim-name%", claim.getName());
                ((CompletableFuture)this.instance.getMain().removeClaimBan(claim, banned).thenAccept(success -> {
                    if (success.booleanValue()) {
                        instance.executeEntitySync(player, () -> player.sendMessage(message));
                        Player target = Bukkit.getPlayer((String)banned);
                        if (target != null && target.isOnline()) {
                            instance.executeEntitySync(target, () -> target.sendMessage(instance.getLanguage().getMessage("unbanned-claim-player").replace("%owner%", player.getName()).replace("%claim-name%", claim.getName())));
                        }
                    } else {
                        instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
        });
        HashSet bans = instance.getMain().convertUUIDSetToStringSet(claim.getBans());
        ArrayList<String> bansList = new ArrayList<String>(bans);
        Collections.sort(bansList, (ban1, ban2) -> ban1.compareTo((String)ban2));
        bans = new LinkedHashSet<String>(bansList);
        for (String ban : bans) {
            String banHeadUrl = "https://mc-heads.net/avatar/" + ban + "/150";
            form.button(ban, FormImage.Type.URL, banHeadUrl);
        }
        this.floodgatePlayer.sendForm(form.build());
    }
}

