/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.Bedrock;

import fr.xyness.SCS.Guis.Bedrock.BClaimMainGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class BClaimChunksGui {
    private final SimpleClaimSystem instance;
    private final FloodgatePlayer floodgatePlayer;

    public BClaimChunksGui(Player player, Claim claim, SimpleClaimSystem instance) {
        this.instance = instance;
        this.floodgatePlayer = FloodgateApi.getInstance().getPlayer(player.getUniqueId());
        CPlayer cPlayer = instance.getPlayerMain().getCPlayer(player.getUniqueId());
        if (cPlayer == null) {
            return;
        }
        SimpleForm.Builder form = (SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(instance.getLanguage().getMessage("bedrock-gui-chunks-title").replace("%name%", claim.getName()))).button(instance.getLanguage().getMessage("bedrock-back-page-main")).content(instance.getLanguage().getMessage("bedrock-gui-chunks-click")).validResultHandler(response -> {
            int clickedSlot = response.clickedButtonId();
            if (clickedSlot == 0) {
                new BClaimMainGui(player, claim, instance);
                return;
            }
            String chunk = cPlayer.getMapString(clickedSlot);
            if (!instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.delchunk")) {
                return;
            }
            if (claim.getChunks().size() == 1) {
                return;
            }
            ((CompletableFuture)this.instance.getMain().removeClaimChunk(claim, chunk).thenAccept(success -> {
                if (success.booleanValue()) {
                    instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("delete-chunk-success").replace("%chunk%", "[" + chunk + "]").replace("%claim-name%", claim.getName())));
                } else {
                    instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        });
        Set<Chunk> chunks = claim.getChunks();
        cPlayer.clearMapString();
        String chunkHeadUrl = "https://i.ibb.co/kg1gN8V3/chunks.png";
        int i = 1;
        for (Chunk chunk : chunks) {
            cPlayer.addMapString(i, String.valueOf(chunk.getWorld().getName() + ";" + chunk.getX() + ";" + chunk.getZ()));
            form.button(String.valueOf(chunk.getWorld().getName() + ", " + chunk.getX() + ", " + chunk.getZ()), FormImage.Type.URL, chunkHeadUrl);
            ++i;
        }
        this.floodgatePlayer.sendForm(form.build());
    }
}

