/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.Bedrock;

import fr.xyness.SCS.Guis.Bedrock.BClaimMainGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class BClaimListGui {
    private final SimpleClaimSystem instance;
    private final FloodgatePlayer floodgatePlayer;

    public BClaimListGui(Player player, SimpleClaimSystem instance, String filter) {
        this.instance = instance;
        this.floodgatePlayer = FloodgateApi.getInstance().getPlayer(player.getUniqueId());
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        if (cPlayer == null) {
            return;
        }
        String playerName = player.getName();
        SimpleForm.Builder form = (SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(instance.getLanguage().getMessage("bedrock-gui-list-title"))).content(filter.equals("owner") ? instance.getLanguage().getMessage("bedrock-gui-list-click-1") : instance.getLanguage().getMessage("bedrock-gui-list-click-2")).button(instance.getLanguage().getMessage("bedrock-gui-list-filter")).validResultHandler(response -> {
            int clickedSlot = response.clickedButtonId();
            if (clickedSlot == 0) {
                new BClaimListGui(player, instance, filter.equals("owner") ? "not_owner" : "owner");
                return;
            }
            if (!filter.equals("not_owner")) {
                if (instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.main")) {
                    Claim claim = cPlayer.getMapClaim(clickedSlot);
                    if (claim == null) {
                        return;
                    }
                    new BClaimMainGui(player, claim, instance);
                }
            } else {
                Claim claim = cPlayer.getMapClaim(clickedSlot);
                if (instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                    if (claim == null) {
                        return;
                    }
                    if (!claim.getPermissionForPlayer("GuiTeleport", player) && !claim.getOwner().equals(player.getName())) {
                        return;
                    }
                    instance.getMain().goClaim(player, cPlayer.getMapLoc(clickedSlot));
                    return;
                }
            }
        });
        HashSet<Claim> claims = new HashSet<Claim>(filter.equals("owner") ? instance.getMain().getPlayerClaims(playerName) : instance.getMain().getClaimsWhereMemberNotOwner(player));
        ArrayList<Claim> claimList = new ArrayList<Claim>(claims);
        Collections.sort(claimList, (claim1, claim2) -> claim1.getName().compareTo(claim2.getName()));
        claims = new LinkedHashSet<Claim>(claimList);
        cPlayer.clearMapClaim();
        String chunkHeadUrl = "https://i.ibb.co/kg1gN8V3/chunks.png";
        int i = 1;
        for (Claim claim : claims) {
            cPlayer.addMapClaim(i, claim);
            form.button(claim.getName(), FormImage.Type.URL, chunkHeadUrl);
            ++i;
        }
        this.floodgatePlayer.sendForm(form.build());
    }
}

