/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.Bedrock;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class BClaimSettingsGui {
    private final SimpleClaimSystem instance;
    private final FloodgatePlayer floodgatePlayer;

    public BClaimSettingsGui(Player player, Claim claim, SimpleClaimSystem instance) {
        boolean permission;
        this.instance = instance;
        this.floodgatePlayer = FloodgateApi.getInstance().getPlayer(player.getUniqueId());
        CPlayer cPlayer = instance.getPlayerMain().getCPlayer(player.getUniqueId());
        if (cPlayer == null) {
            return;
        }
        CustomForm.Builder form = (CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().title(instance.getLanguage().getMessage("bedrock-gui-settings-title").replace("%name%", claim.getName()))).validResultHandler(response -> {
            HashMap<String, LinkedHashMap<String, Boolean>> perms = new HashMap<String, LinkedHashMap<String, Boolean>>();
            perms.put("visitors", new LinkedHashMap());
            int i = 3;
            for (String key : instance.getGuis().getPerms("visitors")) {
                if (!instance.getSettings().isEnabled(key) || !this.checkPermPerm(player, key)) continue;
                ((LinkedHashMap)perms.get("visitors")).put(key, response.asToggle(i));
                ++i;
            }
            i += 3;
            perms.put("members", new LinkedHashMap());
            for (String key : instance.getGuis().getPerms("members")) {
                if (!instance.getSettings().isEnabled(key) || !this.checkPermPerm(player, key)) continue;
                ((LinkedHashMap)perms.get("members")).put(key, response.asToggle(i));
                ++i;
            }
            i += 3;
            perms.put("natural", new LinkedHashMap());
            for (String key : instance.getGuis().getPerms("natural")) {
                if (!instance.getSettings().isEnabled(key) || !this.checkPermPerm(player, key)) continue;
                ((LinkedHashMap)perms.get("natural")).put(key, response.asToggle(i));
                ++i;
            }
            String message = instance.getLanguage().getMessage("bedrock-perms-updated").replace("%claim-name%", claim.getName());
            ((CompletableFuture)this.instance.getMain().updatePermsBedrock(claim, perms).thenAccept(success -> {
                if (success.booleanValue()) {
                    instance.executeEntitySync(player, () -> player.sendMessage(message));
                } else {
                    instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        });
        form.label("-");
        form.label(instance.getLanguage().getMessage("bedrock-gui-settings-role1"));
        form.label("-");
        for (String key : instance.getGuis().getPerms("visitors")) {
            if (!instance.getSettings().isEnabled(key) || !this.checkPermPerm(player, key)) continue;
            permission = claim.getPermission(key, "visitors");
            form.toggle(instance.getLanguage().getMessage("bedrock-" + key.toLowerCase() + "-title"), permission);
        }
        form.label("-");
        form.label(instance.getLanguage().getMessage("bedrock-gui-settings-role2"));
        form.label("-");
        for (String key : instance.getGuis().getPerms("members")) {
            if (!instance.getSettings().isEnabled(key) || !this.checkPermPerm(player, key)) continue;
            permission = claim.getPermission(key, "members");
            form.toggle(instance.getLanguage().getMessage("bedrock-" + key.toLowerCase() + "-title"), permission);
        }
        form.label("-");
        form.label(instance.getLanguage().getMessage("bedrock-gui-settings-role3"));
        form.label("-");
        for (String key : instance.getGuis().getPerms("natural")) {
            if (!instance.getSettings().isEnabled(key) || !this.checkPermPerm(player, key)) continue;
            permission = claim.getPermission(key, "natural");
            form.toggle(instance.getLanguage().getMessage("bedrock-" + key.toLowerCase() + "-title"), permission);
        }
        this.floodgatePlayer.sendForm(form.build());
    }

    public boolean checkPermPerm(Player player, String perm) {
        return this.instance.getPlayerMain().checkPermPlayer(player, "scs.setting." + perm) || player.hasPermission("scs.setting.*");
    }
}

