/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import dev.lone.itemsadder.api.CustomStack;
import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ClaimBansGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public ClaimBansGui(Player player, Claim claim, int page, SimpleClaimSystem instance) {
        this.instance = instance;
        this.player = player;
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("bans");
        String title = guiSettings.getTitle().replace("%name%", claim.getName()).replace("%page%", String.valueOf(page));
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems(claim, page).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(Claim claim, int page) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(this.player.getUniqueId());
            HashSet bans = this.instance.getMain().convertUUIDSetToStringSet(claim.getBans());
            ArrayList<String> bansList = new ArrayList<String>(bans);
            Collections.sort(bansList, (ban1, ban2) -> ban1.compareTo((String)ban2));
            bans = new LinkedHashSet<String>(bansList);
            int bansCount = bans.size();
            cPlayer.setClaim(claim);
            cPlayer.clearMapString();
            cPlayer.setGuiPage(page);
            GuiSettings guiSettings = ClaimGuis.gui_settings.get("bans");
            int max = guiSettings.getEndSlot() - guiSettings.getStartSlot();
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("bans"));
            for (GuiSlot slot : slots) {
                int slot_int = slot.getSlot();
                String key = slot.getKey();
                String title = slot.getTitle();
                String lore_string = slot.getLore();
                if (key.equals("BackPage")) {
                    if (page == 1) continue;
                    title = title.replace("%page%", String.valueOf(page - 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page - 1));
                }
                if (key.equals("NextPage")) {
                    if (bansCount <= page * max) continue;
                    title = title.replace("%page%", String.valueOf(page + 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page + 1));
                }
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                if (slot.isCustomModel()) {
                    CustomStack customItem = CustomStack.getInstance((String)slot.getCustomModelData());
                    if (customItem == null) continue;
                    Material mat = customItem.getItemStack().getType();
                    this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
                    continue;
                }
                if (slot.isCustomHead()) {
                    this.inv.setItem(slot_int, this.instance.getPlayerMain().createPlayerHeadWithTexture(slot.getCustomTextures(), title, lore));
                    continue;
                }
                Material mat = slot.getMaterial();
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            ArrayList<String> lore = new ArrayList<String>(this.instance.getGuis().getLore(this.instance.getLanguage().getMessage("player-banned-lore")));
            lore.add((String)(this.instance.getPlayerMain().checkPermPlayer(this.player, "scs.command.claim.unban") ? this.instance.getLanguage().getMessage("unban-this-player-button") : this.instance.getLanguage().getMessage("gui-button-no-permission") + this.instance.getLanguage().getMessage("to-unban")));
            int startItem = (page - 1) * max;
            int i = guiSettings.getStartSlot();
            int count = 0;
            for (String p : bans) {
                if (count++ < startItem) continue;
                if (i == guiSettings.getEndSlot()) break;
                cPlayer.addMapString(i, p);
                ItemStack item = this.instance.getPlayerMain().getPlayerHead(p);
                if (item == null) {
                    item = new ItemStack(Material.PLAYER_HEAD);
                }
                SkullMeta meta = (SkullMeta)item.getItemMeta();
                meta.setDisplayName(this.instance.getLanguage().getMessage("player-ban-title").replace("%player%", p));
                meta.setLore(lore);
                item.setItemMeta((ItemMeta)meta);
                this.inv.setItem(i, item);
                ++i;
            }
            return true;
        });
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

