/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import dev.lone.itemsadder.api.CustomStack;
import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ClaimChunksGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public ClaimChunksGui(Player player, Claim claim, int page, SimpleClaimSystem instance) {
        this.instance = instance;
        this.player = player;
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("chunks");
        String title = guiSettings.getTitle().replace("%name%", claim.getName()).replace("%page%", String.valueOf(page));
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems(claim, page).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(Claim claim, int page) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(this.player.getUniqueId());
            Set<Chunk> chunks = claim.getChunks();
            int chunksCount = chunks.size();
            cPlayer.setClaim(claim);
            cPlayer.clearMapString();
            cPlayer.setGuiPage(page);
            GuiSettings guiSettings = ClaimGuis.gui_settings.get("chunks");
            int max = guiSettings.getEndSlot() - guiSettings.getStartSlot();
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("chunks"));
            for (GuiSlot slot : slots) {
                int slot_int = slot.getSlot();
                String key = slot.getKey();
                String title = slot.getTitle();
                String lore_string = slot.getLore();
                if (key.equals("BackPage")) {
                    if (page == 1) continue;
                    title = title.replace("%page%", String.valueOf(page - 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page - 1));
                }
                if (key.equals("NextPage")) {
                    if (chunksCount <= page * max) continue;
                    title = title.replace("%page%", String.valueOf(page + 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page + 1));
                }
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                if (slot.isCustomModel()) {
                    CustomStack customItem = CustomStack.getInstance((String)slot.getCustomModelData());
                    if (customItem == null) continue;
                    Material mat = customItem.getItemStack().getType();
                    this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
                    continue;
                }
                if (slot.isCustomHead()) {
                    this.inv.setItem(slot_int, this.instance.getPlayerMain().createPlayerHeadWithTexture(slot.getCustomTextures(), title, lore));
                    continue;
                }
                Material mat = slot.getMaterial();
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            ArrayList<String> lore = new ArrayList<String>(this.instance.getGuis().getLore(this.instance.getLanguage().getMessage("chunk-lore")));
            lore.add((String)(this.instance.getPlayerMain().checkPermPlayer(this.player, "scs.command.claim.delchunk") ? (claim.getChunks().size() == 1 ? this.instance.getLanguage().getMessage("cannot-remove-only-remaining-chunk-gui") : this.instance.getLanguage().getMessage("access-claim-clickable-removechunk")) : this.instance.getLanguage().getMessage("gui-button-no-permission") + this.instance.getLanguage().getMessage("to-remove-chunk")));
            int startItem = (page - 1) * max;
            int i = guiSettings.getStartSlot();
            int count = 0;
            for (Chunk chunk : chunks) {
                if (count++ < startItem) continue;
                if (i == guiSettings.getEndSlot() + 1) break;
                cPlayer.addMapString(i, String.valueOf(chunk.getWorld().getName() + ";" + chunk.getX() + ";" + chunk.getZ()));
                String title = this.instance.getLanguage().getMessage("chunk-title").replace("%coords%", String.valueOf(chunk.getWorld().getName() + ", X:" + chunk.getX() + ", Z:" + chunk.getZ()));
                ItemStack item = new ItemStack(Material.RED_MUSHROOM_BLOCK, 1);
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName(title);
                meta.setLore(lore);
                item.setItemMeta(meta);
                this.inv.setItem(i, item);
                ++i;
            }
            return true;
        });
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

