/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import dev.lone.itemsadder.api.CustomStack;
import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ClaimMainGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public ClaimMainGui(Player player, Claim claim, SimpleClaimSystem instance) {
        this.instance = instance;
        this.player = player;
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("main");
        String title = guiSettings.getTitle().replace("%name%", claim.getName());
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems(claim).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(Claim claim) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(this.player.getUniqueId());
            cPlayer.setClaim(claim);
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("main"));
            for (GuiSlot slot : slots) {
                int slot_int = slot.getSlot();
                String key = slot.getKey();
                String title = slot.getTitle();
                String lore_string = slot.getLore();
                if (key.equals("Info")) {
                    title = title.replace("%description%", claim.getDescription()).replace("%claim-name%", claim.getName()).replace("%sale-status%", claim.getSale() ? this.instance.getLanguage().getMessage("claim-info-lore-sale-status-true").replace("%price%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("claim-info-lore-sale-status-false")).replace("%chunks-count%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getChunks().size()))).replace("%members-count%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getMembers().size()))).replace("%bans-count%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getBans().size())));
                    lore_string = lore_string.replace("%description%", claim.getDescription()).replace("%claim-name%", claim.getName()).replace("%sale-status%", claim.getSale() ? this.instance.getLanguage().getMessage("claim-info-lore-sale-status-true").replace("%price%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("claim-info-lore-sale-status-false")).replace("%chunks-count%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getChunks().size()))).replace("%members-count%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getMembers().size()))).replace("%bans-count%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getBans().size())));
                }
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                if (slot.isCustomModel()) {
                    CustomStack customItem = CustomStack.getInstance((String)slot.getCustomModelData());
                    if (customItem == null) continue;
                    Material mat = customItem.getItemStack().getType();
                    this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
                    continue;
                }
                if (slot.isCustomHead()) {
                    this.inv.setItem(slot_int, this.instance.getPlayerMain().createPlayerHeadWithTexture(slot.getCustomTextures(), title, lore));
                    continue;
                }
                Material mat = slot.getMaterial();
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            return true;
        });
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

