/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import dev.lone.itemsadder.api.CustomStack;
import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class UnclaimConfirmationGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public UnclaimConfirmationGui(Player player, SimpleClaimSystem instance) {
        this.instance = instance;
        this.player = player;
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("unclaim_confirmation");
        String title = guiSettings.getTitle();
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems().thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("unclaim_confirmation"));
            for (GuiSlot slot : slots) {
                int slot_int = slot.getSlot();
                String title = slot.getTitle();
                String lore_string = slot.getLore();
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                if (slot.isCustomModel()) {
                    CustomStack customItem = CustomStack.getInstance((String)slot.getCustomModelData());
                    if (customItem == null) continue;
                    Material mat = customItem.getItemStack().getType();
                    this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
                    continue;
                }
                Material mat = slot.getMaterial();
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            return true;
        });
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

