/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Listeners;

import fr.xyness.SCS.Commands.ClaimCommand;
import fr.xyness.SCS.Commands.UnclaimCommand;
import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimBansGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimChunksGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimMainGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimMembersGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimsGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimsOwnerGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimsProtectedAreasGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionMainGui;
import fr.xyness.SCS.Guis.ChunkConfirmationGui;
import fr.xyness.SCS.Guis.ClaimBansGui;
import fr.xyness.SCS.Guis.ClaimChunksGui;
import fr.xyness.SCS.Guis.ClaimConfirmationGui;
import fr.xyness.SCS.Guis.ClaimListGui;
import fr.xyness.SCS.Guis.ClaimMainGui;
import fr.xyness.SCS.Guis.ClaimMembersGui;
import fr.xyness.SCS.Guis.ClaimSettingsGui;
import fr.xyness.SCS.Guis.ClaimsGui;
import fr.xyness.SCS.Guis.ClaimsOwnerGui;
import fr.xyness.SCS.Guis.UnclaimConfirmationGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ClaimGuiEvents
implements Listener {
    private SimpleClaimSystem instance;

    public ClaimGuiEvents(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Inventory inv = event.getInventory();
        InventoryHolder holder = inv.getHolder();
        if (holder instanceof ClaimConfirmationGui) {
            this.instance.executeAsyncLater(() -> ClaimCommand.isOnCreate.remove(player), 500L);
        } else if (holder instanceof ChunkConfirmationGui) {
            this.instance.executeAsyncLater(() -> ClaimCommand.isOnAdd.remove(player), 500L);
        } else if (holder instanceof UnclaimConfirmationGui) {
            this.instance.executeAsyncLater(() -> UnclaimCommand.isOnDelete.remove(player), 500L);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory inv = event.getClickedInventory();
        Inventory openInventory = event.getView().getTopInventory();
        if (inv != null) {
            InventoryHolder holder = event.getInventory().getHolder();
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
            if (holder instanceof ClaimMainGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleClaimMainGuiClick(event, player, cPlayer);
            } else if (holder instanceof ClaimSettingsGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleClaimSettingsGuiClick(event, player, cPlayer);
            } else if (holder instanceof ClaimMembersGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleClaimMembersGuiClick(event, player, cPlayer);
            } else if (holder instanceof ClaimChunksGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleClaimChunksGuiClick(event, player, cPlayer);
            } else if (holder instanceof ClaimBansGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleClaimBansGuiClick(event, player, cPlayer);
            } else if (holder instanceof ClaimListGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleClaimListGuiClick(event, player, cPlayer);
            } else if (holder instanceof ClaimsGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleClaimsGuiClick(event, player, cPlayer);
            } else if (holder instanceof ClaimsOwnerGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleClaimsOwnerGuiClick(event, player, cPlayer);
            } else if (holder instanceof ClaimConfirmationGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleClaimConfirmationGuiClick(event, player, cPlayer);
            } else if (holder instanceof UnclaimConfirmationGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleUnclaimConfirmationGuiClick(event, player, cPlayer);
            } else if (holder instanceof ChunkConfirmationGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleChunkConfirmationGuiClick(event, player, cPlayer);
            } else if (holder instanceof AdminGestionMainGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleAdminGestionMainGuiClick(event, player, cPlayer);
            } else if (holder instanceof AdminGestionClaimsGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleAdminGestionClaimsGuiClick(event, player, cPlayer);
            } else if (holder instanceof AdminGestionClaimsOwnerGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleAdminGestionClaimsOwnerGuiClick(event, player, cPlayer);
            } else if (holder instanceof AdminGestionClaimGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleAdminGestionClaimGuiClick(event, player, cPlayer);
            } else if (holder instanceof AdminGestionClaimMembersGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleAdminGestionClaimMembersGuiClick(event, player, cPlayer);
            } else if (holder instanceof AdminGestionClaimBansGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleAdminGestionClaimBansGuiClick(event, player, cPlayer);
            } else if (holder instanceof AdminGestionClaimsProtectedAreasGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleAdminGestionClaimsProtectedAreasGuiClick(event, player, cPlayer);
            } else if (holder instanceof AdminGestionClaimMainGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleAdminGestionClaimMainGuiClick(event, player, cPlayer);
            } else if (holder instanceof AdminGestionClaimChunksGui) {
                if (!inv.equals((Object)openInventory)) {
                    event.setCancelled(true);
                    return;
                }
                this.handleAdminGestionClaimChunksGuiClick(event, player, cPlayer);
            }
        }
    }

    private void handleClaimConfirmationGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("claim_confirmation", clickedSlot);
        if (guiSlot != null) {
            if (guiSlot.getKey().startsWith("confirm-")) {
                player.closeInventory();
                int radius = ClaimCommand.isOnCreate.get(player);
                if (radius == 0) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)"claim");
                } else {
                    Bukkit.dispatchCommand((CommandSender)player, (String)("claim " + String.valueOf(radius)));
                }
                return;
            }
            if (guiSlot.getKey().startsWith("cancel-")) {
                player.closeInventory();
                ClaimCommand.isOnCreate.remove(player);
                return;
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
    }

    private void handleUnclaimConfirmationGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("unclaim_confirmation", clickedSlot);
        if (guiSlot != null) {
            if (guiSlot.getKey().startsWith("confirm-")) {
                player.closeInventory();
                String claimName = UnclaimCommand.isOnDelete.get(player);
                Bukkit.dispatchCommand((CommandSender)player, (String)("unclaim " + claimName));
                return;
            }
            if (guiSlot.getKey().startsWith("cancel-")) {
                player.closeInventory();
                UnclaimCommand.isOnDelete.remove(player);
                return;
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
    }

    private void handleChunkConfirmationGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("chunk_confirmation", clickedSlot);
        if (guiSlot != null) {
            if (guiSlot.getKey().startsWith("confirm-")) {
                player.closeInventory();
                String claimName = ClaimCommand.isOnAdd.get(player);
                Bukkit.dispatchCommand((CommandSender)player, (String)("claim addchunk " + claimName));
                return;
            }
            if (guiSlot.getKey().startsWith("cancel-")) {
                player.closeInventory();
                ClaimCommand.isOnAdd.remove(player);
                return;
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
    }

    private void handleClaimMainGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        if (claim == null) {
            return;
        }
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("main", clickedSlot);
        if (guiSlot != null) {
            String key;
            switch (key = guiSlot.getKey()) {
                case "Settings": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.settings")) {
                        return;
                    }
                    new ClaimSettingsGui(player, claim, this.instance, "visitors");
                    return;
                }
                case "Members": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.members")) {
                        return;
                    }
                    new ClaimMembersGui(player, claim, 1, this.instance);
                    return;
                }
                case "Bans": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.bans")) {
                        return;
                    }
                    new ClaimBansGui(player, claim, 1, this.instance);
                    return;
                }
                case "Chunks": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.chunks")) {
                        return;
                    }
                    new ClaimChunksGui(player, claim, 1, this.instance);
                    return;
                }
                case "Teleport": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                        return;
                    }
                    player.closeInventory();
                    this.instance.getMain().goClaim(player, claim.getLocation());
                    return;
                }
                case "List": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.list")) {
                        return;
                    }
                    new ClaimListGui(player, 1, "owner", this.instance);
                    return;
                }
                case "Unclaim": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim")) {
                        return;
                    }
                    player.closeInventory();
                    Bukkit.dispatchCommand((CommandSender)player, (String)("unclaim " + claim.getName()));
                    return;
                }
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
    }

    private void handleClaimSettingsGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        ItemMeta meta;
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        String role = cPlayer.getFilter();
        if (claim == null || role == null) {
            return;
        }
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("settings", clickedSlot);
        if (guiSlot != null) {
            String key;
            switch (key = guiSlot.getKey()) {
                case "Filter": {
                    role = role.equals("visitors") ? "members" : (role.equals("members") ? "natural" : "visitors");
                    new ClaimSettingsGui(player, claim, this.instance, role);
                    return;
                }
                case "Apply": {
                    ((CompletableFuture)this.instance.getMain().applyAllSettings(claim).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> {
                                player.closeInventory();
                                player.sendMessage(this.instance.getLanguage().getMessage("apply-all-settings-success"));
                            });
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                    return;
                }
                case "Main": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.main")) {
                        return;
                    }
                    new ClaimMainGui(player, claim, this.instance);
                    return;
                }
                case "Members": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.members")) {
                        return;
                    }
                    new ClaimMembersGui(player, claim, 1, this.instance);
                    return;
                }
                case "Bans": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.bans")) {
                        return;
                    }
                    new ClaimBansGui(player, claim, 1, this.instance);
                    return;
                }
                case "Chunks": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.chunks")) {
                        return;
                    }
                    new ClaimChunksGui(player, claim, 1, this.instance);
                    return;
                }
                case "Teleport": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                        return;
                    }
                    player.closeInventory();
                    this.instance.getMain().goClaim(player, claim.getLocation());
                    return;
                }
                case "List": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.list")) {
                        return;
                    }
                    new ClaimListGui(player, 1, "owner", this.instance);
                    return;
                }
                case "Unclaim": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim")) {
                        return;
                    }
                    player.closeInventory();
                    Bukkit.dispatchCommand((CommandSender)player, (String)("unclaim " + claim.getName()));
                    return;
                }
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
        if (this.instance.getGuis().isAllowedSlot(clickedSlot, role) && (meta = clickedItem.getItemMeta()) != null && meta.hasLore()) {
            String title = meta.getDisplayName();
            List lore = meta.getLore();
            String check = (String)lore.get(lore.size() - 1);
            if (check.equals(this.instance.getLanguage().getMessage("choice-setting-disabled"))) {
                return;
            }
            String action = this.instance.getGuis().getSlotPerm(clickedSlot, role);
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.setting." + action) && !this.instance.getPlayerMain().checkPermPlayer(player, "scs.setting.*")) {
                return;
            }
            if (title.contains(this.instance.getLanguage().getMessage("status-enabled"))) {
                ((CompletableFuture)this.instance.getMain().updatePerm(claim, action, false, role).thenAccept(success -> {
                    if (success.booleanValue()) {
                        meta.setDisplayName(title.replace(this.instance.getLanguage().getMessage("status-enabled"), this.instance.getLanguage().getMessage("status-disabled")));
                        lore.remove(lore.size() - 1);
                        lore.add(this.instance.getLanguage().getMessage("choice-disabled"));
                        meta.setLore(lore);
                        clickedItem.setItemMeta(meta);
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            ((CompletableFuture)this.instance.getMain().updatePerm(claim, action, true, role).thenAccept(success -> {
                if (success.booleanValue()) {
                    meta.setDisplayName(title.replace(this.instance.getLanguage().getMessage("status-disabled"), this.instance.getLanguage().getMessage("status-enabled")));
                    lore.remove(lore.size() - 1);
                    lore.add(this.instance.getLanguage().getMessage("choice-enabled"));
                    meta.setLore(lore);
                    clickedItem.setItemMeta(meta);
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
    }

    private void handleClaimMembersGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        if (claim == null) {
            return;
        }
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("members");
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("members", clickedSlot);
        if (guiSlot != null) {
            String key;
            switch (key = guiSlot.getKey()) {
                case "Main": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.main")) {
                        return;
                    }
                    new ClaimMainGui(player, claim, this.instance);
                    return;
                }
                case "Settings": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.settings")) {
                        return;
                    }
                    new ClaimSettingsGui(player, claim, this.instance, "visitors");
                    return;
                }
                case "Bans": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.bans")) {
                        return;
                    }
                    new ClaimBansGui(player, claim, 1, this.instance);
                    return;
                }
                case "Chunks": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.chunks")) {
                        return;
                    }
                    new ClaimChunksGui(player, claim, 1, this.instance);
                    return;
                }
                case "Teleport": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                        return;
                    }
                    player.closeInventory();
                    this.instance.getMain().goClaim(player, claim.getLocation());
                    return;
                }
                case "List": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.list")) {
                        return;
                    }
                    new ClaimListGui(player, 1, "owner", this.instance);
                    return;
                }
                case "Unclaim": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim")) {
                        return;
                    }
                    player.closeInventory();
                    Bukkit.dispatchCommand((CommandSender)player, (String)("unclaim " + claim.getName()));
                    return;
                }
                case "BackPage": {
                    int page = cPlayer.getGuiPage();
                    new ClaimMembersGui(player, claim, page - 1, this.instance);
                    return;
                }
                case "NextPage": {
                    int page = cPlayer.getGuiPage() + 1;
                    new ClaimMembersGui(player, claim, page, this.instance);
                    return;
                }
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
        if (clickedSlot >= guiSettings.getStartSlot() && clickedSlot <= guiSettings.getEndSlot()) {
            String targetName = cPlayer.getMapString(clickedSlot);
            String owner_claim = claim.getOwner();
            String playerName = player.getName();
            if (targetName.equals(playerName) && !owner_claim.equals("*")) {
                return;
            }
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.remove")) {
                return;
            }
            String message = this.instance.getLanguage().getMessage("remove-member-success").replace("%player%", targetName).replace("%claim-name%", claim.getName());
            ((CompletableFuture)this.instance.getMain().removeClaimMember(claim, targetName).thenAccept(success -> {
                if (success.booleanValue()) {
                    int page = cPlayer.getGuiPage();
                    new ClaimMembersGui(player, claim, page, this.instance);
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    Player target = Bukkit.getPlayer((String)targetName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("remove-claim-player").replace("%claim-name%", claim.getName()).replace("%owner%", playerName)));
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
    }

    private void handleClaimChunksGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        if (claim == null) {
            return;
        }
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("chunks");
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("chunks", clickedSlot);
        if (guiSlot != null) {
            String key;
            switch (key = guiSlot.getKey()) {
                case "Main": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.main")) {
                        return;
                    }
                    new ClaimMainGui(player, claim, this.instance);
                    return;
                }
                case "Settings": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.settings")) {
                        return;
                    }
                    new ClaimSettingsGui(player, claim, this.instance, "visitors");
                    return;
                }
                case "Bans": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.bans")) {
                        return;
                    }
                    new ClaimBansGui(player, claim, 1, this.instance);
                    return;
                }
                case "Members": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.members")) {
                        return;
                    }
                    new ClaimMembersGui(player, claim, 1, this.instance);
                    return;
                }
                case "Teleport": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                        return;
                    }
                    player.closeInventory();
                    this.instance.getMain().goClaim(player, claim.getLocation());
                    return;
                }
                case "List": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.list")) {
                        return;
                    }
                    new ClaimListGui(player, 1, "owner", this.instance);
                    return;
                }
                case "Unclaim": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim")) {
                        return;
                    }
                    player.closeInventory();
                    Bukkit.dispatchCommand((CommandSender)player, (String)("unclaim " + claim.getName()));
                    return;
                }
                case "BackPage": {
                    int page = cPlayer.getGuiPage();
                    new ClaimChunksGui(player, claim, page - 1, this.instance);
                    return;
                }
                case "NextPage": {
                    int page = cPlayer.getGuiPage() + 1;
                    new ClaimChunksGui(player, claim, page, this.instance);
                    return;
                }
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
        if (clickedSlot >= guiSettings.getStartSlot() && clickedSlot <= guiSettings.getEndSlot()) {
            String chunk = cPlayer.getMapString(clickedSlot);
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.delchunk")) {
                return;
            }
            if (claim.getChunks().size() == 1) {
                return;
            }
            ((CompletableFuture)this.instance.getMain().removeClaimChunk(claim, chunk).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-chunk-success").replace("%chunk%", "[" + chunk + "]").replace("%claim-name%", claim.getName())));
                    int page = cPlayer.getGuiPage();
                    new ClaimChunksGui(player, claim, page, this.instance);
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
    }

    private void handleClaimBansGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        if (claim == null) {
            return;
        }
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("bans");
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("bans", clickedSlot);
        if (guiSlot != null) {
            String key;
            switch (key = guiSlot.getKey()) {
                case "Main": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.main")) {
                        return;
                    }
                    new ClaimMainGui(player, claim, this.instance);
                    return;
                }
                case "Settings": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.settings")) {
                        return;
                    }
                    new ClaimSettingsGui(player, claim, this.instance, "visitors");
                    return;
                }
                case "Members": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.members")) {
                        return;
                    }
                    new ClaimMembersGui(player, claim, 1, this.instance);
                    return;
                }
                case "Chunks": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.chunks")) {
                        return;
                    }
                    new ClaimChunksGui(player, claim, 1, this.instance);
                    return;
                }
                case "Teleport": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                        return;
                    }
                    player.closeInventory();
                    this.instance.getMain().goClaim(player, claim.getLocation());
                    return;
                }
                case "List": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.list")) {
                        return;
                    }
                    new ClaimListGui(player, 1, "owner", this.instance);
                    return;
                }
                case "Unclaim": {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim")) {
                        return;
                    }
                    player.closeInventory();
                    Bukkit.dispatchCommand((CommandSender)player, (String)("unclaim " + claim.getName()));
                    return;
                }
                case "BackPage": {
                    int page = cPlayer.getGuiPage();
                    new ClaimBansGui(player, claim, page - 1, this.instance);
                    return;
                }
                case "NextPage": {
                    int page = cPlayer.getGuiPage() + 1;
                    new ClaimBansGui(player, claim, page, this.instance);
                    return;
                }
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
        if (clickedSlot >= guiSettings.getStartSlot() && clickedSlot <= guiSettings.getEndSlot()) {
            String playerName;
            String targetName = cPlayer.getMapString(clickedSlot);
            if (targetName.equals(playerName = player.getName())) {
                return;
            }
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.unban")) {
                return;
            }
            String message = this.instance.getLanguage().getMessage("remove-ban-success").replace("%player%", targetName).replace("%claim-name%", claim.getName());
            ((CompletableFuture)this.instance.getMain().removeClaimBan(claim, targetName).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    int page = cPlayer.getGuiPage();
                    new ClaimBansGui(player, claim, page, this.instance);
                    Player target = Bukkit.getPlayer((String)targetName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("unbanned-claim-player").replace("%owner%", playerName).replace("%claim-name%", claim.getName())));
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
    }

    private void handleClaimListGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("list");
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("list", clickedSlot);
        if (guiSlot != null) {
            String key;
            switch (key = guiSlot.getKey()) {
                case "Filter": {
                    String filter = cPlayer.getFilter();
                    filter = filter.equals("owner") ? "not_owner" : "owner";
                    new ClaimListGui(player, 1, filter, this.instance);
                    return;
                }
                case "BackPage": {
                    int page = cPlayer.getGuiPage() - 1;
                    new ClaimListGui(player, page, cPlayer.getFilter(), this.instance);
                    return;
                }
                case "NextPage": {
                    int page = cPlayer.getGuiPage() + 1;
                    new ClaimListGui(player, page, cPlayer.getFilter(), this.instance);
                    return;
                }
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
        if (clickedSlot >= guiSettings.getStartSlot() && clickedSlot <= guiSettings.getEndSlot()) {
            Claim claim;
            if (event.getClick() == ClickType.LEFT) {
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                    claim = cPlayer.getMapClaim(clickedSlot);
                    if (claim == null) {
                        return;
                    }
                    if (!claim.getPermissionForPlayer("GuiTeleport", player) && !claim.getOwner().equals(player.getName())) {
                        return;
                    }
                    player.closeInventory();
                    this.instance.getMain().goClaim(player, cPlayer.getMapLoc(clickedSlot));
                    return;
                }
                return;
            }
            if (cPlayer.getFilter().equals("not_owner")) {
                return;
            }
            if (event.getClick() == ClickType.RIGHT) {
                if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim")) {
                    return;
                }
                new ClaimMainGui(player, cPlayer.getMapClaim(clickedSlot), this.instance);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT) {
                if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim")) {
                    return;
                }
                claim = cPlayer.getMapClaim(clickedSlot);
                ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success")));
                        int page = cPlayer.getGuiPage();
                        new ClaimListGui(player, page, cPlayer.getFilter(), this.instance);
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
        }
    }

    private void handleClaimsGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("claims");
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("claims", clickedSlot);
        if (guiSlot != null) {
            String key;
            switch (key = guiSlot.getKey()) {
                case "Filter": {
                    String filter = cPlayer.getFilter();
                    filter = filter.equals("all") ? "sales" : (filter.equals("sales") ? "online" : (filter.equals("online") ? "offline" : "all"));
                    new ClaimsGui(player, 1, filter, this.instance);
                    return;
                }
                case "BackPage": {
                    int page = cPlayer.getGuiPage() - 1;
                    new ClaimsGui(player, page, cPlayer.getFilter(), this.instance);
                    return;
                }
                case "NextPage": {
                    int page = cPlayer.getGuiPage() + 1;
                    new ClaimsGui(player, page, cPlayer.getFilter(), this.instance);
                    return;
                }
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
        if (clickedSlot >= guiSettings.getStartSlot() && clickedSlot <= guiSettings.getEndSlot()) {
            String filter = cPlayer.getFilter();
            if (filter.equals("sales")) {
                new ClaimsOwnerGui(player, 1, filter, cPlayer.getMapString(clickedSlot), this.instance);
                return;
            }
            new ClaimsOwnerGui(player, 1, "all", cPlayer.getMapString(clickedSlot), this.instance);
            return;
        }
    }

    private void handleClaimsOwnerGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("claims");
        GuiSlot guiSlot = this.instance.getGuis().getGuiSlotByClickedSlot("claims", clickedSlot);
        if (guiSlot != null) {
            String key;
            switch (key = guiSlot.getKey()) {
                case "Filter": {
                    String filter = cPlayer.getFilter();
                    filter = filter.equals("all") ? "sales" : "all";
                    new ClaimsOwnerGui(player, 1, filter, cPlayer.getOwner(), this.instance);
                    return;
                }
                case "BackPageOther": {
                    if (cPlayer.getGuiPage() == 1) {
                        new ClaimsGui(player, 1, "all", this.instance);
                        return;
                    }
                }
                case "BackPage": {
                    if (cPlayer.getGuiPage() == 1) {
                        new ClaimsGui(player, 1, "all", this.instance);
                        return;
                    }
                    int page = cPlayer.getGuiPage() - 1;
                    new ClaimsOwnerGui(player, page, cPlayer.getFilter(), cPlayer.getOwner(), this.instance);
                    return;
                }
                case "NextPage": {
                    int page = cPlayer.getGuiPage() + 1;
                    new ClaimsOwnerGui(player, page, cPlayer.getFilter(), cPlayer.getOwner(), this.instance);
                    return;
                }
            }
            String action = guiSlot.getAction();
            if (action != null && !action.isBlank()) {
                this.instance.getGuis().executeAction(player, guiSlot, event.getClick());
            }
        }
        if (clickedSlot >= guiSettings.getStartSlot() && clickedSlot <= guiSettings.getEndSlot()) {
            Claim claim = cPlayer.getMapClaim(clickedSlot);
            if (event.getClick() == ClickType.LEFT) {
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                    if (!(claim.getPermissionForPlayer("GuiTeleport", player) || claim.getOwner().equals(player.getName()) || this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass.guiteleport"))) {
                        return;
                    }
                    this.instance.executeEntitySync(player, () -> player.closeInventory());
                    this.instance.getMain().goClaim(player, cPlayer.getMapLoc(clickedSlot));
                    return;
                }
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT) {
                if (this.instance.getSettings().getBooleanSetting("economy")) {
                    if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.buy")) {
                        return;
                    }
                    if (claim.getOwner().equals(player.getName())) {
                        player.sendMessage(this.instance.getLanguage().getMessage("cant-buy-your-own-claim"));
                        return;
                    }
                    if (claim.getSale()) {
                        String playerName = player.getName();
                        String old_owner = claim.getOwner();
                        String old_name = claim.getName();
                        double price = claim.getPrice();
                        double balance = this.instance.getVault().getPlayerBalance(playerName);
                        if (balance < price) {
                            player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money"));
                            return;
                        }
                        if (!cPlayer.canClaim()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore"));
                            return;
                        }
                        if (!cPlayer.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(playerName).size() + claim.getChunks().size())) {
                            player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                            return;
                        }
                        ((CompletableFuture)this.instance.getMain().sellChunk(player, claim).thenAccept(success -> {
                            if (success.booleanValue()) {
                                Player target;
                                this.instance.executeEntitySync(player, () -> {
                                    player.sendMessage(this.instance.getLanguage().getMessage("buy-claim-success").replace("%name%", old_name).replace("%price%", String.valueOf(price)).replace("%owner%", old_owner.equalsIgnoreCase("*") ? "protected areas" : old_owner).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")));
                                    player.closeInventory();
                                });
                                if (!old_owner.equalsIgnoreCase("*") && (target = Bukkit.getPlayer((String)old_owner)) != null && target.isOnline()) {
                                    this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("claim-was-sold").replace("%name%", old_name).replace("%buyer%", playerName).replace("%price%", String.valueOf(price)).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                                }
                            } else {
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                            }
                        })).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                        return;
                    }
                    player.sendMessage(this.instance.getLanguage().getMessage("claim-is-not-in-sale"));
                    return;
                }
                player.sendMessage(this.instance.getLanguage().getMessage("economy-disabled"));
                return;
            }
        }
    }

    private void handleAdminGestionMainGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        if (clickedSlot == 21) {
            new AdminGestionClaimsGui(player, 1, "all", this.instance);
            return;
        }
        if (clickedSlot == 22) {
            new AdminGestionClaimsProtectedAreasGui(player, 1, "all", this.instance);
            return;
        }
        if (clickedSlot == 23) {
            this.instance.getAutopurge().purgeClaims(player);
            player.closeInventory();
            return;
        }
    }

    private void handleAdminGestionClaimsGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        if (clickedSlot == 48) {
            int page = cPlayer.getGuiPage();
            if (page == 1) {
                new AdminGestionMainGui(player, this.instance);
                return;
            }
            new AdminGestionClaimsGui(player, --page, cPlayer.getFilter(), this.instance);
            return;
        }
        if (clickedSlot == 50) {
            int page = cPlayer.getGuiPage() + 1;
            new AdminGestionClaimsGui(player, page, cPlayer.getFilter(), this.instance);
            return;
        }
        if (clickedSlot == 49) {
            String filter = cPlayer.getFilter();
            filter = filter.equals("all") ? "sales" : (filter.equals("sales") ? "online" : (filter.equals("online") ? "offline" : "all"));
            new AdminGestionClaimsGui(player, 1, filter, this.instance);
            return;
        }
        if (clickedSlot >= 0 && clickedSlot <= 44) {
            String filter = cPlayer.getFilter();
            if (event.getClick() == ClickType.SHIFT_LEFT) {
                String target = cPlayer.getMapString(clickedSlot);
                ((CompletableFuture)this.instance.getMain().deleteAllClaims(target).thenAccept(success -> {
                    if (success.booleanValue()) {
                        new AdminGestionClaimsGui(player, 1, filter, this.instance);
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("player-unclaim-other-all-claim-aclaim").replace("%player%", target)));
                        Player pTarget = Bukkit.getPlayer((String)target);
                        if (pTarget != null) {
                            this.instance.executeEntitySync(pTarget, () -> pTarget.sendMessage(this.instance.getLanguage().getMessage("player-all-claim-unclaimed-by-admin").replace("%player%", player.getName())));
                        }
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            if (event.getClick() == ClickType.LEFT) {
                new AdminGestionClaimsOwnerGui(player, 1, filter, cPlayer.getMapString(clickedSlot), this.instance);
                return;
            }
            return;
        }
    }

    private void handleAdminGestionClaimsOwnerGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        if (clickedSlot == 48) {
            if (cPlayer.getGuiPage() == 1) {
                new AdminGestionClaimsGui(player, 1, "all", this.instance);
                return;
            }
            int page = cPlayer.getGuiPage() - 1;
            new AdminGestionClaimsOwnerGui(player, page, cPlayer.getFilter(), cPlayer.getOwner(), this.instance);
            return;
        }
        if (clickedSlot == 50) {
            int page = cPlayer.getGuiPage() + 1;
            new AdminGestionClaimsOwnerGui(player, page, cPlayer.getFilter(), cPlayer.getOwner(), this.instance);
            return;
        }
        if (clickedSlot == 49) {
            String filter = cPlayer.getFilter();
            filter = filter.equals("all") ? "sales" : "all";
            new AdminGestionClaimsOwnerGui(player, 1, filter, cPlayer.getOwner(), this.instance);
            return;
        }
        if (clickedSlot >= 0 && clickedSlot <= 44) {
            Claim claim = cPlayer.getMapClaim(clickedSlot);
            if (event.getClick() == ClickType.LEFT) {
                new AdminGestionClaimMainGui(player, claim, this.instance);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT) {
                String owner = claim.getOwner();
                String claim_name = claim.getName();
                ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("player-unclaim-other-claim-aclaim").replace("%name%", claim_name).replace("%player%", owner)));
                        Player target = Bukkit.getPlayer((String)owner);
                        if (target != null) {
                            this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("player-claim-unclaimed-by-admin").replace("%name%", claim_name).replace("%player%", player.getName())));
                        }
                        new AdminGestionClaimsOwnerGui(player, cPlayer.getGuiPage(), cPlayer.getFilter(), owner, this.instance);
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
        }
    }

    private void handleAdminGestionClaimGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        ItemMeta meta;
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        String role = cPlayer.getFilter();
        if (claim == null || role == null) {
            return;
        }
        if (clickedSlot == 49) {
            new AdminGestionClaimMainGui(player, claim, this.instance);
            return;
        }
        if (clickedSlot == 50) {
            ((CompletableFuture)this.instance.getMain().applyAllSettings(claim).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("apply-all-settings-success-aclaim").replace("%player%", claim.getOwner())));
                    String target = cPlayer.getOwner();
                    if (target.equals("*")) {
                        new AdminGestionClaimsProtectedAreasGui(player, 1, cPlayer.getFilter(), this.instance);
                        return;
                    }
                    new AdminGestionClaimsOwnerGui(player, 1, cPlayer.getFilter(), target, this.instance);
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (clickedSlot == 48) {
            role = role.equals("visitors") ? "members" : (role.equals("members") ? "natural" : "visitors");
            new AdminGestionClaimGui(player, claim, this.instance, role);
            return;
        }
        if (this.instance.getGuis().isAdminAllowedSlot(clickedSlot, role) && (meta = clickedItem.getItemMeta()) != null && meta.hasLore()) {
            String title = meta.getDisplayName();
            List lore = meta.getLore();
            String check = (String)lore.get(lore.size() - 1);
            if (check.equals(this.instance.getLanguage().getMessage("choice-setting-disabled"))) {
                return;
            }
            String action = this.instance.getGuis().getAdminSlotPerm(clickedSlot, role);
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.setting." + action)) {
                return;
            }
            if (title.contains(this.instance.getLanguage().getMessage("status-enabled"))) {
                ((CompletableFuture)this.instance.getMain().updatePerm(claim, action, false, role).thenAccept(success -> {
                    if (success.booleanValue()) {
                        meta.setDisplayName(title.replace(this.instance.getLanguage().getMessage("status-enabled"), this.instance.getLanguage().getMessage("status-disabled")));
                        lore.remove(lore.size() - 1);
                        lore.add(this.instance.getLanguage().getMessage("choice-disabled"));
                        meta.setLore(lore);
                        clickedItem.setItemMeta(meta);
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            ((CompletableFuture)this.instance.getMain().updatePerm(claim, action, true, role).thenAccept(success -> {
                if (success.booleanValue()) {
                    meta.setDisplayName(title.replace(this.instance.getLanguage().getMessage("status-disabled"), this.instance.getLanguage().getMessage("status-enabled")));
                    lore.remove(lore.size() - 1);
                    lore.add(this.instance.getLanguage().getMessage("choice-enabled"));
                    meta.setLore(lore);
                    clickedItem.setItemMeta(meta);
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
    }

    private void handleAdminGestionClaimMembersGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        if (claim == null) {
            return;
        }
        if (clickedSlot == 48) {
            int page = cPlayer.getGuiPage();
            new AdminGestionClaimMembersGui(player, claim, page - 1, this.instance);
            return;
        }
        if (clickedSlot == 49) {
            new AdminGestionClaimMainGui(player, claim, this.instance);
            return;
        }
        if (clickedSlot == 50) {
            int page = cPlayer.getGuiPage() + 1;
            new AdminGestionClaimMembersGui(player, claim, page, this.instance);
            return;
        }
        if (clickedSlot >= 0 && clickedSlot <= 44) {
            String targetName = cPlayer.getMapString(clickedSlot);
            String owner_claim = claim.getOwner();
            String claimName = claim.getName();
            if (targetName.equals(owner_claim) && !owner_claim.equals("*")) {
                return;
            }
            String message = this.instance.getLanguage().getMessage("remove-member-success-aclaim").replace("%player%", targetName).replace("%claim-name%", claimName).replace("%owner%", owner_claim);
            String targetMessage = owner_claim.equalsIgnoreCase("*") ? this.instance.getLanguage().getMessage("remove-claim-protected-area-player").replace("%claim-name%", claimName) : this.instance.getLanguage().getMessage("remove-claim-player").replace("%claim-name%", claimName).replace("%owner%", owner_claim);
            ((CompletableFuture)this.instance.getMain().removeClaimMember(claim, targetName).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    int page = cPlayer.getGuiPage();
                    new AdminGestionClaimMembersGui(player, claim, page, this.instance);
                    Player target = Bukkit.getPlayer((String)targetName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(targetMessage));
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
    }

    private void handleAdminGestionClaimBansGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        if (claim == null) {
            return;
        }
        if (clickedSlot == 48) {
            int page = cPlayer.getGuiPage();
            new AdminGestionClaimBansGui(player, claim, page - 1, this.instance);
            return;
        }
        if (clickedSlot == 49) {
            new AdminGestionClaimMainGui(player, claim, this.instance);
            return;
        }
        if (clickedSlot == 50) {
            int page = cPlayer.getGuiPage() + 1;
            new AdminGestionClaimBansGui(player, claim, page, this.instance);
            return;
        }
        if (clickedSlot >= 0 && clickedSlot <= 44) {
            String targetName = cPlayer.getMapString(clickedSlot);
            String owner_claim = claim.getOwner();
            String claimName = claim.getName();
            if (targetName.equals(player.getName())) {
                return;
            }
            String message = this.instance.getLanguage().getMessage("remove-ban-success-aclaim").replace("%player%", targetName).replace("%claim-name%", claim.getName()).replace("%owner%", owner_claim);
            String targetMessage = owner_claim.equalsIgnoreCase("*") ? this.instance.getLanguage().getMessage("unbanned-claim-protected-area-player").replace("%claim-name%", claimName) : this.instance.getLanguage().getMessage("unbanned-claim-player").replace("%claim-name%", claimName).replace("%owner%", owner_claim);
            ((CompletableFuture)this.instance.getMain().removeClaimBan(claim, targetName).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    int page = cPlayer.getGuiPage();
                    new AdminGestionClaimBansGui(player, claim, page, this.instance);
                    Player target = Bukkit.getPlayer((String)targetName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(targetMessage));
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
    }

    private void handleAdminGestionClaimsProtectedAreasGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        if (clickedSlot == 48) {
            if (cPlayer.getGuiPage() == 1) {
                new AdminGestionMainGui(player, this.instance);
                return;
            }
            int page = cPlayer.getGuiPage() - 1;
            new AdminGestionClaimsProtectedAreasGui(player, page, cPlayer.getFilter(), this.instance);
            return;
        }
        if (clickedSlot == 50) {
            int page = cPlayer.getGuiPage() + 1;
            new AdminGestionClaimsProtectedAreasGui(player, page, cPlayer.getFilter(), this.instance);
            return;
        }
        if (clickedSlot == 49) {
            String filter = cPlayer.getFilter();
            filter = filter.equals("all") ? "sales" : "all";
            new AdminGestionClaimsProtectedAreasGui(player, 1, filter, this.instance);
            return;
        }
        if (clickedSlot >= 0 && clickedSlot <= 44) {
            Claim claim = cPlayer.getMapClaim(clickedSlot);
            if (event.getClick() == ClickType.LEFT) {
                new AdminGestionClaimMainGui(player, claim, this.instance);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT) {
                ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-claim-protected-area")));
                        new AdminGestionClaimsProtectedAreasGui(player, cPlayer.getGuiPage(), cPlayer.getFilter(), this.instance);
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            }
            return;
        }
    }

    private void handleAdminGestionClaimMainGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        if (claim == null) {
            return;
        }
        if (clickedSlot == 20) {
            new AdminGestionClaimBansGui(player, claim, 1, this.instance);
            return;
        }
        if (clickedSlot == 30) {
            new AdminGestionClaimMembersGui(player, claim, 1, this.instance);
            return;
        }
        if (clickedSlot == 29) {
            new AdminGestionClaimGui(player, claim, this.instance, "visitors");
            return;
        }
        if (clickedSlot == 32) {
            new AdminGestionClaimChunksGui(player, claim, 1, this.instance);
            return;
        }
        if (clickedSlot == 33) {
            player.closeInventory();
            this.instance.getMain().goClaim(player, claim.getLocation());
            return;
        }
        if (clickedSlot == 24) {
            player.closeInventory();
            if (claim.getOwner().equalsIgnoreCase("*")) {
                Bukkit.dispatchCommand((CommandSender)player, (String)("parea unclaim " + claim.getName()));
            } else {
                Bukkit.dispatchCommand((CommandSender)player, (String)("scs player unclaim " + claim.getOwner() + " " + claim.getName()));
            }
            return;
        }
        if (clickedSlot == 49) {
            String owner = claim.getOwner();
            if (owner.equals("*")) {
                new AdminGestionClaimsProtectedAreasGui(player, 1, "all", this.instance);
            } else {
                new AdminGestionClaimsOwnerGui(player, 1, "all", claim.getOwner(), this.instance);
            }
            return;
        }
    }

    private void handleAdminGestionClaimChunksGuiClick(InventoryClickEvent event, Player player, CPlayer cPlayer) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        int clickedSlot = event.getSlot();
        Claim claim = cPlayer.getClaim();
        if (claim == null) {
            return;
        }
        if (clickedSlot == 48) {
            int page = cPlayer.getGuiPage();
            new AdminGestionClaimChunksGui(player, claim, page - 1, this.instance);
            return;
        }
        if (clickedSlot == 49) {
            new AdminGestionClaimMainGui(player, claim, this.instance);
            return;
        }
        if (clickedSlot == 50) {
            int page = cPlayer.getGuiPage() + 1;
            new AdminGestionClaimChunksGui(player, claim, page, this.instance);
            return;
        }
        if (clickedSlot >= 0 && clickedSlot <= 44) {
            String chunk = cPlayer.getMapString(clickedSlot);
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.delchunk")) {
                return;
            }
            if (claim.getChunks().size() == 1) {
                return;
            }
            ((CompletableFuture)this.instance.getMain().removeClaimChunk(claim, chunk).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-chunk-success").replace("%chunk%", "[" + chunk + "]").replace("%claim-name%", claim.getName())));
                    int page = cPlayer.getGuiPage();
                    new AdminGestionClaimChunksGui(player, claim, page, this.instance);
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
    }
}

