/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Listeners;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import fr.xyness.SCS.Types.WorldMode;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.WeatherType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PaperClaimEvents
implements Listener {
    private SimpleClaimSystem instance;

    public PaperClaimEvents(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    @EventHandler
    public void onPlayerRespawn(PlayerPostRespawnEvent event) {
        if (this.instance.isFolia()) {
            Player player = event.getPlayer();
            Bukkit.getRegionScheduler().run((Plugin)this.instance, event.getRespawnedLocation(), task -> {
                Chunk to = event.getRespawnedLocation().getChunk();
                this.instance.executeSync(() -> {
                    String ownerTO = this.instance.getMain().getOwnerInClaim(to);
                    CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
                    if (cPlayer == null) {
                        return;
                    }
                    String world = player.getWorld().getName();
                    this.handleWeatherSettings(player, to, null);
                    this.instance.getBossBars().activeBossBar(player, to);
                    this.handleAutoFly(player, cPlayer, to, ownerTO);
                    if (cPlayer.getClaimAuto().equals("addchunk")) {
                        this.handleAutoAddChunk(player, cPlayer, to, world);
                    } else if (cPlayer.getClaimAuto().equals("delchunk")) {
                        this.handleAutoDelChunk(player, cPlayer, to, world);
                    } else if (cPlayer.getClaimAuto().equals("claim")) {
                        this.handleAutoClaim(player, cPlayer, to, world);
                    } else if (cPlayer.getClaimAuto().equals("unclaim")) {
                        this.handleAutoUnclaim(player, cPlayer, to, world);
                    }
                    if (cPlayer.getClaimAutomap().booleanValue()) {
                        this.handleAutoMap(player, cPlayer, to, world);
                    }
                });
            });
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getName();
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        if (cPlayer == null) {
            return;
        }
        if (cPlayer.getClaimChat().booleanValue()) {
            event.setCancelled(true);
            String msg = this.instance.getLanguage().getMessage("chat-format").replace("%player%", playerName).replace("%message%", PlainTextComponentSerializer.plainText().serialize(event.originalMessage()));
            player.sendMessage(msg);
            for (String p : this.instance.getMain().getAllMembersWithPlayerParallel(playerName)) {
                Player target = Bukkit.getPlayer((String)p);
                if (target == null || !target.isOnline()) continue;
                target.sendMessage(msg);
            }
        }
    }

    @EventHandler
    public void onPlayerPickupItem(PlayerAttemptPickupItemEvent event) {
        Chunk chunk = event.getItem().getLocation().getChunk();
        Player player = event.getPlayer();
        WorldMode mode = this.instance.getSettings().getWorldMode(player.getWorld().getName());
        if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass")) {
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            if (!claim.getPermissionForPlayer("ItemsPickup", player)) {
                event.setCancelled(true);
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("itemspickup"), this.instance.getSettings().getSetting("protection-message"));
                return;
            }
        } else if (mode == WorldMode.SURVIVAL_REQUIRING_CLAIMS && !this.instance.getSettings().getSettingSRC("ItemsPickup")) {
            event.setCancelled(true);
            this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("itemspickup-mode"), this.instance.getSettings().getSetting("protection-message"));
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Chunk to = event.getTo().getChunk();
        Chunk from = event.getFrom().getChunk();
        Player player = event.getPlayer();
        if (!this.instance.getMain().checkIfClaimExists(to)) {
            this.instance.getBossBars().disableBossBar(player);
            return;
        }
        UUID playerId = player.getUniqueId();
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(playerId);
        if (cPlayer == null) {
            return;
        }
        String ownerTO = this.instance.getMain().getOwnerInClaim(to);
        String ownerFROM = this.instance.getMain().getOwnerInClaim(from);
        Claim claim = this.instance.getMain().getClaim(to);
        if (claim != null) {
            if (this.instance.getMain().checkBan(claim, player) && !this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass.ban")) {
                this.cancelTeleport(event, player, "player-banned");
                return;
            }
            if (!claim.getPermissionForPlayer("Enter", player) && !this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass.enter")) {
                this.cancelTeleport(event, player, "enter");
                return;
            }
            if (this.isTeleportBlocked(event, player, claim)) {
                this.cancelTeleport(event, player, "teleportations");
                return;
            }
        }
        this.instance.getBossBars().activeBossBar(player, to);
        this.handleAutoFly(player, cPlayer, to, ownerTO);
        this.handleWeatherSettings(player, to, from);
        String world = player.getWorld().getName();
        if (!ownerTO.equals(ownerFROM)) {
            this.handleEnterLeaveMessages(player, to, from, ownerTO, ownerFROM);
            if (cPlayer.getClaimAuto().equals("addchunk")) {
                this.handleAutoAddChunk(player, cPlayer, to, world);
            } else if (cPlayer.getClaimAuto().equals("delchunk")) {
                this.handleAutoDelChunk(player, cPlayer, to, world);
            } else if (cPlayer.getClaimAuto().equals("claim")) {
                this.handleAutoClaim(player, cPlayer, to, world);
            } else if (cPlayer.getClaimAuto().equals("unclaim")) {
                this.handleAutoUnclaim(player, cPlayer, to, world);
            }
        }
        if (cPlayer.getClaimAutomap().booleanValue()) {
            this.handleAutoMap(player, cPlayer, to, world);
        }
    }

    private void cancelTeleport(PlayerTeleportEvent event, Player player, String message) {
        if (this.instance.isFolia()) {
            this.instance.executeAsyncLater(() -> this.instance.getMain().teleportPlayer(player, event.getFrom()), 50L);
        } else {
            event.setCancelled(true);
        }
        this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage(message), this.instance.getSettings().getSetting("protection-message"));
    }

    private boolean isTeleportBlocked(PlayerTeleportEvent event, Player player, Claim claim) {
        if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.bypass") && !claim.getPermissionForPlayer("Teleportations", player)) {
            switch (event.getCause()) {
                case ENDER_PEARL: 
                case CHORUS_FRUIT: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void handleWeatherSettings(Player player, Chunk to, Chunk from) {
        Claim claimTo = this.instance.getMain().getClaim(to);
        Claim claimFrom = this.instance.getMain().getClaim(from);
        if (this.instance.getMain().checkIfClaimExists(to) && !claimTo.getPermissionForPlayer("Weather", player)) {
            player.setPlayerWeather(WeatherType.CLEAR);
        } else if (this.instance.getMain().checkIfClaimExists(from) && !claimFrom.getPermissionForPlayer("Weather", player)) {
            player.resetPlayerWeather();
        }
    }

    private void handleAutoFly(Player player, CPlayer cPlayer, Chunk chunk, String owner) {
        Claim claim = this.instance.getMain().getClaim(chunk);
        if (cPlayer.getClaimAutofly().booleanValue() && (owner.equals(player.getName()) || claim != null && claim.getPermissionForPlayer("Fly", player)) && !this.instance.isFolia()) {
            this.instance.getPlayerMain().activePlayerFly(player);
            if (this.instance.getSettings().getBooleanSetting("claim-fly-message-auto-fly")) {
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("fly-enabled"), "CHAT");
            }
        } else if (claim != null && !claim.getPermissionForPlayer("Fly", player) && !owner.equals(player.getName()) && cPlayer.getClaimFly().booleanValue() && !this.instance.isFolia()) {
            this.instance.getPlayerMain().removePlayerFly(player);
            if (this.instance.getSettings().getBooleanSetting("claim-fly-message-auto-fly")) {
                this.instance.getMain().sendMessage(player, this.instance.getLanguage().getMessage("fly-disabled"), "CHAT");
            }
        }
    }

    private void handleAutoDelChunk(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("autodelchunk-world-disabled").replace("%world%", world));
            cPlayer.setClaimAuto("");
        } else {
            Claim claim = cPlayer.getTargetClaimChunk();
            if (claim == null) {
                return;
            }
            if (claim.getChunks().size() == 1) {
                player.sendMessage(this.instance.getLanguage().getMessage("cannot-remove-only-remaining-chunk"));
                return;
            }
            HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
            if (!chunks.contains(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("chunk-not-in-claim"));
                return;
            }
            chunks.remove(chunk);
            if (!this.instance.getMain().isAnyChunkAdjacent(chunks, chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("one-chunk-must-be-adjacent-delchunk"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().removeClaimChunk(claim, chunk).thenAccept(success -> {
                if (success.booleanValue()) {
                    String chunk_string = world + ";" + String.valueOf(chunk.getX()) + ";" + String.valueOf(chunk.getZ());
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-chunk-success").replace("%chunk%", "[" + chunk_string + "]").replace("%claim-name%", claim.getName())));
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error-delete-chunk")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    private void handleAutoAddChunk(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("autoaddchunk-world-disabled").replace("%world%", world));
            cPlayer.setClaimAuto("");
        } else {
            String playerName = player.getName();
            Claim claim = cPlayer.getTargetClaimChunk();
            if (claim == null) {
                return;
            }
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                Claim claim_target = this.instance.getMain().getClaim(chunk);
                if (claim_target.getOwner().equalsIgnoreCase(playerName)) {
                    if (claim_target.equals(claim)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-already-in-claim").replace("%claim-name%", claim.getName()));
                        return;
                    }
                    player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-already-owner").replace("%claim-name%", claim.getName()).replace("%claim-name-1%", claim_target.getName()));
                    return;
                }
                player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-not-owner"));
                return;
            }
            HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
            if (!cPlayer.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(playerName).size() + 1)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                return;
            }
            if (!cPlayer.canClaimWithNumber(chunks.size() + 1)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                return;
            }
            chunks.add(chunk);
            if (!this.instance.getMain().areChunksInSameWorld(chunks)) {
                player.sendMessage(this.instance.getLanguage().getMessage("chunks-must-be-from-same-world"));
                return;
            }
            chunks.remove(chunk);
            if (!this.instance.getMain().isAnyChunkAdjacent(chunks, chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("one-chunk-must-be-adjacent"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().isAreaClaimFree(chunk, cPlayer.getClaimDistance(), playerName).thenAccept(successs -> {
                if (successs.booleanValue()) {
                    double[] price = new double[]{0.0};
                    if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("chunk-cost")) {
                        price[0] = this.instance.getSettings().getBooleanSetting("chunk-cost-multiplier") ? cPlayer.getChunkMultipliedCost(chunks.size()).doubleValue() : cPlayer.getChunkCost();
                        double balance = this.instance.getVault().getPlayerBalance(playerName);
                        if (balance < price[0]) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money-claim").replace("%missing-price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round((price[0] - balance) * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                            return;
                        }
                        this.instance.getVault().removePlayerBalance(playerName, price[0]);
                        if (price[0] > 0.0) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("you-paid-chunk").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price[0] * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                        }
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cannot-claim-because-claim-near")));
                    return;
                }
                ((CompletableFuture)this.instance.getMain().addClaimChunk(claim, chunk).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-successful").replace("%chunk%", "[" + chunk.getWorld().getName() + ";" + String.valueOf(chunk.getX()) + ";" + String.valueOf(chunk.getZ()) + "]").replace("%claim-name%", claim.getName())));
                        if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                            this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks()), true, false);
                        }
                        return;
                    }
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    private void handleAutoUnclaim(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("autounclaim-world-disabled").replace("%world%", world));
            cPlayer.setClaimAuto("");
        } else {
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (owner.equals("*") && player.hasPermission("scs.admin")) {
                ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("delete-claim-protected-area"));
                    } else {
                        player.sendMessage(this.instance.getLanguage().getMessage("error"));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            if (!owner.equals(player.getName())) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                if (success.booleanValue()) {
                    player.sendMessage(this.instance.getLanguage().getMessage("territory-delete-success"));
                } else {
                    player.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    private void handleAutoClaim(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("autoclaim-world-disabled").replace("%world%", world));
            cPlayer.setClaimAuto("");
        } else {
            String playerName = player.getName();
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                this.instance.getMain().handleClaimConflict(player, chunk);
                return;
            }
            if (!this.instance.getMain().isAreaClaimFree(chunk, cPlayer.getClaimDistance(), playerName).join().booleanValue()) {
                player.sendMessage(this.instance.getLanguage().getMessage("cannot-claim-because-claim-near"));
                return;
            }
            if (!cPlayer.canClaim()) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                double price = this.instance.getSettings().getBooleanSetting("claim-cost-multiplier") ? cPlayer.getMultipliedCost().doubleValue() : cPlayer.getCost();
                double balance = this.instance.getVault().getPlayerBalance(playerName);
                if (balance < price) {
                    player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money-claim").replace("%missing-price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round((price - balance) * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")));
                    return;
                }
                this.instance.getVault().removePlayerBalance(playerName, price);
                if (price > 0.0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("you-paid-claim").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")));
                }
            }
            ((CompletableFuture)this.instance.getMain().createClaim(player, chunk).thenAccept(success -> {
                if (success.booleanValue()) {
                    int remainingClaims = cPlayer.getMaxClaims() - cPlayer.getClaimsCount();
                    player.sendMessage(this.instance.getLanguage().getMessage("create-claim-success").replace("%remaining-claims%", this.instance.getMain().getNumberSeparate(String.valueOf(remainingClaims))));
                    if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                        this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)Set.of(chunk)), true, false);
                    }
                } else {
                    player.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    private void handleAutoMap(Player player, CPlayer cPlayer, Chunk chunk, String world) {
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("automap-world-disabled").replace("%world%", world));
            cPlayer.setClaimAutomap(false);
        } else {
            this.instance.getMain().getMap(player, chunk, true);
        }
    }

    private void handleEnterLeaveMessages(Player player, Chunk to, Chunk from, String ownerTO, String ownerFROM) {
        if (this.instance.getSettings().getBooleanSetting("enter-leave-messages")) {
            this.enterleaveMessages(player, to, from, ownerTO, ownerFROM);
        }
        if (this.instance.getSettings().getBooleanSetting("enter-leave-chat-messages")) {
            this.enterleaveChatMessages(player, to, from, ownerTO, ownerFROM);
        }
        if (this.instance.getSettings().getBooleanSetting("enter-leave-title-messages")) {
            this.enterleavetitleMessages(player, to, from, ownerTO, ownerFROM);
        }
    }

    private void enterleaveChatMessages(Player player, Chunk to, Chunk from, String ownerTO, String ownerFROM) {
        String playerName = player.getName();
        String toName = this.instance.getMain().getClaimNameByChunk(to);
        String fromName = this.instance.getMain().getClaimNameByChunk(from);
        if (this.instance.getMain().checkIfClaimExists(to)) {
            Claim claim = this.instance.getMain().getClaim(to);
            String message = claim.getSale() && this.instance.getSettings().getBooleanSetting("announce-sale.chat") ? (ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-for-sale-chat").replace("%name%", toName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("enter-territory-for-sale-chat").replace("%owner%", ownerTO).replace("%player%", playerName).replace("%name%", toName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))) : (ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-chat").replace("%name%", toName) : this.instance.getLanguage().getMessage("enter-territory-chat").replace("%owner%", ownerTO).replace("%player%", playerName).replace("%name%", toName));
            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(from)) {
            String message = ownerFROM.equals("*") ? this.instance.getLanguage().getMessage("leave-protected-area").replace("%name%", fromName) : this.instance.getLanguage().getMessage("leave-territory").replace("%owner%", ownerFROM).replace("%player%", playerName).replace("%name%", fromName);
            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
        }
    }

    private void enterleaveMessages(Player player, Chunk to, Chunk from, String ownerTO, String ownerFROM) {
        String playerName = player.getName();
        String toName = this.instance.getMain().getClaimNameByChunk(to);
        String fromName = this.instance.getMain().getClaimNameByChunk(from);
        if (this.instance.getMain().checkIfClaimExists(to)) {
            Claim claim = this.instance.getMain().getClaim(to);
            String message = claim.getSale() && this.instance.getSettings().getBooleanSetting("announce-sale.actionbar") ? (ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-for-sale").replace("%name%", toName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("enter-territory-for-sale").replace("%owner%", ownerTO).replace("%player%", playerName).replace("%name%", toName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))) : (ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area").replace("%name%", toName) : this.instance.getLanguage().getMessage("enter-territory").replace("%owner%", ownerTO).replace("%player%", playerName).replace("%name%", toName));
            this.instance.executeEntitySync(player, () -> this.instance.getMain().sendMessage(player, message, "ACTION_BAR"));
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(from)) {
            String message = ownerFROM.equals("*") ? this.instance.getLanguage().getMessage("leave-protected-area").replace("%name%", fromName) : this.instance.getLanguage().getMessage("leave-territory").replace("%owner%", ownerFROM).replace("%player%", playerName).replace("%name%", fromName);
            this.instance.executeEntitySync(player, () -> this.instance.getMain().sendMessage(player, message, "ACTION_BAR"));
        }
    }

    private void enterleavetitleMessages(Player player, Chunk to, Chunk from, String ownerTO, String ownerFROM) {
        String toName = this.instance.getMain().getClaimNameByChunk(to);
        String fromName = this.instance.getMain().getClaimNameByChunk(from);
        String playerName = player.getName();
        if (this.instance.getMain().checkIfClaimExists(to)) {
            String toSubtitleKey;
            String toTitleKey;
            Claim claim = this.instance.getMain().getClaim(to);
            if (claim.getSale() && this.instance.getSettings().getBooleanSetting("announce-sale.title")) {
                toTitleKey = ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-for-sale-title").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("enter-territory-for-sale-title").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"));
                toSubtitleKey = ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-for-sale-subtitle").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("enter-territory-for-sale-subtitle").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName).replace("%price%", this.instance.getMain().getPrice(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"));
            } else {
                toTitleKey = ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-title").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName) : this.instance.getLanguage().getMessage("enter-territory-title").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName);
                toSubtitleKey = ownerTO.equals("*") ? this.instance.getLanguage().getMessage("enter-protected-area-subtitle").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName) : this.instance.getLanguage().getMessage("enter-territory-subtitle").replace("%name%", toName).replace("%owner%", ownerTO).replace("%player%", playerName);
            }
            this.instance.executeEntitySync(player, () -> player.sendTitle(toTitleKey, toSubtitleKey, 5, 25, 5));
            return;
        }
        if (this.instance.getMain().checkIfClaimExists(from)) {
            String fromTitleKey = ownerFROM.equals("*") ? "leave-protected-area-title" : "leave-territory-title";
            String fromSubtitleKey = ownerFROM.equals("*") ? "leave-protected-area-subtitle" : "leave-territory-subtitle";
            String title = this.instance.getLanguage().getMessage(fromTitleKey).replace("%name%", fromName).replace("%owner%", ownerFROM).replace("%player%", playerName);
            String subtitle = this.instance.getLanguage().getMessage(fromSubtitleKey).replace("%name%", fromName).replace("%owner%", ownerFROM).replace("%player%", playerName);
            this.instance.executeEntitySync(player, () -> player.sendTitle(title, subtitle, 5, 25, 5));
        }
    }
}

