/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Support;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;

public class ClaimPlaceholdersExpansion
extends PlaceholderExpansion {
    private static ClaimPlaceholdersExpansion instancePAPI;
    private SimpleClaimSystem instance;

    public ClaimPlaceholdersExpansion(SimpleClaimSystem instance) {
        instancePAPI = this;
        this.instance = instance;
    }

    public static ClaimPlaceholdersExpansion getExpansionInstance() {
        return instancePAPI;
    }

    public String getIdentifier() {
        return "scs";
    }

    public String getAuthor() {
        return "Xyness";
    }

    public String getVersion() {
        return "1.0";
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "";
        }
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            switch (identifier) {
                case "player_claims_count": {
                    return String.valueOf(cPlayer.getClaimsCount());
                }
                case "claim_name": {
                    Chunk chunk = player.getLocation().getChunk();
                    if (this.instance.getMain().checkIfClaimExists(chunk)) {
                        return this.instance.getMain().getClaimNameByChunk(chunk);
                    }
                    return this.instance.getLanguage().getMessage("claim_name-if-no-claim");
                }
                case "player_max_claims": {
                    int maxClaims = cPlayer.getMaxClaims();
                    return maxClaims > 0 ? String.valueOf(maxClaims) : "\u221e";
                }
                case "player_max_chunks_per_claim": {
                    int maxChunks = cPlayer.getMaxChunksPerClaim();
                    return maxChunks > 0 ? String.valueOf(maxChunks) : "\u221e";
                }
                case "player_max_chunks_total": {
                    int maxChunksTotal = cPlayer.getMaxChunksTotal();
                    return maxChunksTotal > 0 ? String.valueOf(maxChunksTotal) : "\u221e";
                }
                case "player_claim_distance": {
                    int distance = cPlayer.getClaimDistance();
                    return distance > 0 ? String.valueOf(distance) : this.instance.getLanguage().getMessage("claim_distance-if-zero");
                }
                case "player_remain_claims": {
                    int max = cPlayer.getMaxClaims();
                    if (max == 0) {
                        return "\u221e";
                    }
                    int remainingClaims = max - cPlayer.getClaimsCount();
                    return remainingClaims >= 0 ? String.valueOf(remainingClaims) : "0";
                }
                case "player_remain_chunks": {
                    int max_chunks = cPlayer.getMaxChunksTotal();
                    if (max_chunks == 0) {
                        return "\u221e";
                    }
                    int remainingChunks = max_chunks - this.instance.getMain().getAllChunksFromAllClaims(player.getName()).size();
                    return remainingChunks >= 0 ? String.valueOf(remainingChunks) : "0";
                }
                case "player_chunks_count": {
                    return String.valueOf(this.instance.getMain().getAllChunksFromAllClaims(player.getName()).size());
                }
                case "player_max_radius_claims": {
                    int maxRadiusClaims = cPlayer.getMaxRadiusClaims();
                    return maxRadiusClaims > 0 ? String.valueOf(maxRadiusClaims) : "\u221e";
                }
                case "player_teleportation_delay": {
                    return String.valueOf(cPlayer.getDelay());
                }
                case "player_max_members": {
                    int maxMembers = cPlayer.getMaxMembers();
                    return maxMembers > 0 ? String.valueOf(maxMembers) : "\u221e";
                }
                case "player_claim_cost": {
                    return String.valueOf(cPlayer.getCost());
                }
                case "player_claim_cost_multiplier": {
                    return String.valueOf(cPlayer.getMultiplier());
                }
                case "claim_owner": {
                    Chunk chunk = player.getLocation().getChunk();
                    if (this.instance.getMain().checkIfClaimExists(chunk)) {
                        Claim claim = this.instance.getMain().getClaim(chunk);
                        return claim.getOwner();
                    }
                    return this.instance.getLanguage().getMessage("claim_owner-if-no-claim");
                }
                case "claim_description": {
                    Chunk chunk = player.getLocation().getChunk();
                    if (this.instance.getMain().checkIfClaimExists(chunk)) {
                        Claim claim = this.instance.getMain().getClaim(chunk);
                        return claim.getDescription();
                    }
                    return this.instance.getLanguage().getMessage("claim_description-if-no-claim");
                }
                case "claim_is_in_sale": {
                    Chunk chunk = player.getLocation().getChunk();
                    if (this.instance.getMain().checkIfClaimExists(chunk)) {
                        return String.valueOf(this.instance.getMain().getClaim(chunk).getSale());
                    }
                    return this.instance.getLanguage().getMessage("claim_is_in_sale-if-no-claim");
                }
                case "claim_sale_price": {
                    Chunk chunk = player.getLocation().getChunk();
                    if (this.instance.getMain().checkIfClaimExists(chunk)) {
                        Claim claim = this.instance.getMain().getClaim(chunk);
                        if (claim.getSale()) {
                            return String.valueOf(claim.getPrice());
                        }
                        return this.instance.getLanguage().getMessage("claim_sale_price-if-not-in-sale");
                    }
                    return this.instance.getLanguage().getMessage("claim_sale_price-if-no-claim");
                }
                case "claim_members_count": {
                    Chunk chunk = player.getLocation().getChunk();
                    if (this.instance.getMain().checkIfClaimExists(chunk)) {
                        Claim claim = this.instance.getMain().getClaim(chunk);
                        return String.valueOf(claim.getMembers().size());
                    }
                    return this.instance.getLanguage().getMessage("claim_members_count-if-no-claim");
                }
                case "claim_members_online": {
                    Chunk chunk = player.getLocation().getChunk();
                    if (this.instance.getMain().checkIfClaimExists(chunk)) {
                        Claim claim = this.instance.getMain().getClaim(chunk);
                        CustomSet<String> members = this.instance.getMain().convertUUIDSetToStringSet(claim.getMembers());
                        long onlineMembers = members.stream().filter(member -> Bukkit.getPlayer((String)member) != null).count();
                        return String.valueOf(onlineMembers);
                    }
                    return this.instance.getLanguage().getMessage("claim_members_online-if-no-claim");
                }
                case "claim_spawn": {
                    Chunk chunk = player.getLocation().getChunk();
                    if (this.instance.getMain().checkIfClaimExists(chunk)) {
                        Claim claim = this.instance.getMain().getClaim(chunk);
                        return String.valueOf(this.instance.getMain().getClaimCoords(claim));
                    }
                    return this.instance.getLanguage().getMessage("claim_spawn-if-no-claim");
                }
            }
            if (identifier.startsWith("claim_setting_")) {
                Chunk chunk = player.getLocation().getChunk();
                if (this.instance.getMain().checkIfClaimExists(chunk)) {
                    Claim claim = this.instance.getMain().getClaim(chunk);
                    String syntax = identifier.replaceFirst("claim_setting_", "");
                    String[] parts = syntax.split("_");
                    if (parts.length != 2) {
                        return this.instance.getLanguage().getMessage("status-disabled");
                    }
                    String setting = parts[0];
                    String role = parts[1];
                    return claim.getPermission(setting, role) ? this.instance.getLanguage().getMessage("status-enabled") : this.instance.getLanguage().getMessage("status-disabled");
                }
                return this.instance.getLanguage().getMessage("claim_setting-if-no-claim");
            }
            return null;
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return "";
        }
    }
}

