/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn;

import java.util.Arrays;
import me.rockquiet.spawn.3rdparty.org.bstats.bukkit.Metrics;
import me.rockquiet.spawn.3rdparty.org.bstats.charts.SimplePie;
import me.rockquiet.spawn.SpawnHandler;
import me.rockquiet.spawn.commands.SpawnCommand;
import me.rockquiet.spawn.commands.TabComplete;
import me.rockquiet.spawn.configuration.FileManager;
import me.rockquiet.spawn.configuration.MessageManager;
import me.rockquiet.spawn.configuration.MessageManagerLegacy;
import me.rockquiet.spawn.configuration.Messages;
import me.rockquiet.spawn.listeners.TeleportOnJoinListener;
import me.rockquiet.spawn.listeners.TeleportOnRespawnListener;
import me.rockquiet.spawn.listeners.TeleportOnWorldChangeListener;
import me.rockquiet.spawn.listeners.TeleportOutOfVoidListener;
import me.rockquiet.spawn.updater.UpdateChecker;
import me.rockquiet.spawn.updater.Version;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class Spawn
extends JavaPlugin {
    private static final Version SERVER_VERSION = Version.parse(Bukkit.getBukkitVersion());

    public static Version getServerVersion() {
        return SERVER_VERSION;
    }

    public void onEnable() {
        FileManager fileManager = new FileManager(this);
        Messages messageManager = Arrays.stream(Package.getPackages()).noneMatch(aPackage -> aPackage.getName().contains("io.papermc")) || SERVER_VERSION.getMinor() <= 18 && !SERVER_VERSION.equals(new Version(1, 18, 2)) ? new MessageManagerLegacy(fileManager) : new MessageManager(fileManager);
        SpawnHandler spawnHandler = new SpawnHandler(this, fileManager, messageManager);
        this.getCommand("spawn").setExecutor((CommandExecutor)new SpawnCommand(this, fileManager, messageManager, spawnHandler));
        this.getCommand("spawn").setTabCompleter((TabCompleter)new TabComplete());
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new TeleportOnJoinListener(fileManager, spawnHandler), (Plugin)this);
        pluginManager.registerEvents((Listener)new TeleportOutOfVoidListener(fileManager, spawnHandler), (Plugin)this);
        pluginManager.registerEvents((Listener)new TeleportOnRespawnListener(fileManager, messageManager, spawnHandler), (Plugin)this);
        pluginManager.registerEvents((Listener)new TeleportOnWorldChangeListener(fileManager, spawnHandler), (Plugin)this);
        boolean updateChecks = fileManager.getYamlConfig().getBoolean("plugin.update-checks");
        Metrics metrics = new Metrics((Plugin)this, 19297);
        metrics.addCustomChart(new SimplePie("update_checks", () -> String.valueOf(updateChecks)));
        if (updateChecks) {
            new UpdateChecker(this);
        }
    }
}

