/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn;

import java.util.List;
import java.util.Locale;
import me.rockquiet.spawn.Spawn;
import me.rockquiet.spawn.configuration.ConfigFile;
import me.rockquiet.spawn.configuration.FileManager;
import me.rockquiet.spawn.configuration.Messages;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class SpawnHandler {
    private static final String WORLD_KEY = "spawn.world";
    private static final String X_KEY = "spawn.x";
    private static final String Y_KEY = "spawn.y";
    private static final String Z_KEY = "spawn.z";
    private static final String YAW_KEY = "spawn.yaw";
    private static final String PITCH_KEY = "spawn.pitch";
    private final Spawn plugin;
    private final FileManager fileManager;
    private final Messages messageManager;
    private Location spawnLocation;

    public SpawnHandler(Spawn plugin, FileManager fileManager, Messages messageManager) {
        this.plugin = plugin;
        this.fileManager = fileManager;
        this.messageManager = messageManager;
        this.spawnLocation = this.loadSpawn();
    }

    public Location getSpawn() {
        return this.spawnLocation;
    }

    public void setSpawn(Location newSpawnLocation, boolean saveToFile) {
        this.spawnLocation = newSpawnLocation;
        if (saveToFile) {
            this.saveSpawn(newSpawnLocation);
        }
    }

    private void saveSpawn(Location newSpawnLocation) {
        ConfigFile location = this.fileManager.getLocation();
        YamlConfiguration locationYaml = location.get();
        locationYaml.set(WORLD_KEY, (Object)newSpawnLocation.getWorld().getName());
        locationYaml.set(X_KEY, (Object)newSpawnLocation.getX());
        locationYaml.set(Y_KEY, (Object)newSpawnLocation.getY());
        locationYaml.set(Z_KEY, (Object)newSpawnLocation.getZ());
        locationYaml.set(YAW_KEY, (Object)Float.valueOf(newSpawnLocation.getYaw()));
        locationYaml.set(PITCH_KEY, (Object)Float.valueOf(newSpawnLocation.getPitch()));
        location.save();
        location.reload();
    }

    public Location loadSpawn() {
        if (!this.isLocationConfigValid()) {
            return null;
        }
        YamlConfiguration location = this.fileManager.getYamlLocation();
        return new Location(Bukkit.getWorld((String)location.getString(WORLD_KEY)), location.getDouble(X_KEY), location.getDouble(Y_KEY), location.getDouble(Z_KEY), (float)location.getDouble(YAW_KEY), (float)location.getDouble(PITCH_KEY));
    }

    private boolean isLocationConfigValid() {
        YamlConfiguration location = this.fileManager.getYamlLocation();
        return location.getString(WORLD_KEY) != null && location.get(X_KEY) != null && location.get(Y_KEY) != null && location.get(Z_KEY) != null && location.get(YAW_KEY) != null && location.get(PITCH_KEY) != null;
    }

    public boolean spawnExists() {
        return this.spawnLocation != null || this.isLocationConfigValid();
    }

    public boolean isEnabledInWorld(World world) {
        YamlConfiguration config = this.fileManager.getYamlConfig();
        List worldList = config.getStringList("plugin.world-list");
        String worldName = world.getName();
        switch (config.getString("plugin.list-type").toLowerCase(Locale.ROOT)) {
            case "whitelist": {
                return worldList.contains(worldName);
            }
            case "blacklist": {
                return !worldList.contains(worldName);
            }
        }
        return true;
    }

    public boolean isAllowedGameMode(Player player) {
        YamlConfiguration config = this.fileManager.getYamlConfig();
        if (player.hasPermission("spawn.bypass.gamemode-restriction") || !config.getBoolean("plugin.gamemode-restricted")) {
            return true;
        }
        return config.getStringList("plugin.gamemode-list").stream().anyMatch(s -> s.equalsIgnoreCase(player.getGameMode().toString()));
    }

    public void teleportPlayer(Player player) {
        if (!this.spawnExists()) {
            this.messageManager.sendMessage(player, "no-spawn");
            return;
        }
        YamlConfiguration config = this.fileManager.getYamlConfig();
        if (!config.getBoolean("fall-damage.enabled")) {
            player.setFallDistance(0.0f);
        }
        if (config.getBoolean("use-player-head-rotation.enabled")) {
            Location location = this.spawnLocation.clone();
            location.setDirection(player.getLocation().getDirection());
            player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else {
            player.teleport(this.spawnLocation, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
        this.spawnParticles(player);
        this.playSound(player);
        this.messageManager.sendMessage(player, "teleport");
    }

    public void spawnParticles(Player player) {
        YamlConfiguration config = this.fileManager.getYamlConfig();
        if (config.getBoolean("particles.enabled")) {
            String particleName = config.getString("particles.particle");
            int particleAmount = config.getInt("particles.amount");
            try {
                if (Spawn.getServerVersion().getMinor() > 8) {
                    Particle particle = Particle.valueOf((String)particleName);
                    player.spawnParticle(particle, this.spawnLocation, particleAmount);
                    player.getNearbyEntities(16.0, 16.0, 16.0).stream().filter(entity -> entity instanceof Player && ((Player)entity).canSee(player)).forEach(entity -> ((Player)entity).spawnParticle(particle, this.spawnLocation, particleAmount));
                } else {
                    Effect effect = Effect.valueOf((String)particleName);
                    int particleAmountLegacy = Math.min(particleAmount, 2000);
                    for (int p = 0; p <= particleAmountLegacy; ++p) {
                        player.playEffect(this.spawnLocation, effect, null);
                    }
                    player.getNearbyEntities(16.0, 16.0, 16.0).stream().filter(entity -> entity instanceof Player && ((Player)entity).canSee(player)).forEach(entity -> {
                        for (int p = 0; p <= particleAmountLegacy; ++p) {
                            ((Player)entity).playEffect(this.spawnLocation, effect, null);
                        }
                    });
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("The particle " + particleName + " does not exist in this Minecraft version!");
            }
        }
    }

    public void playSound(Player player) {
        YamlConfiguration config = this.fileManager.getYamlConfig();
        if (config.getBoolean("sounds.enabled")) {
            String sound = config.getString("sounds.sound");
            try {
                player.playSound(this.getSpawn(), Sound.valueOf((String)sound), (float)config.getDouble("sounds.volume"), (float)config.getDouble("sounds.pitch"));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("The sound " + sound + " does not exist in this Minecraft version!");
            }
        }
    }
}

