/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn.commands;

import java.time.Instant;
import java.util.HashMap;
import java.util.UUID;
import me.rockquiet.spawn.Spawn;
import me.rockquiet.spawn.configuration.FileManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class CommandCooldown
implements Listener {
    private final HashMap<UUID, Long> cooldown = new HashMap();
    private final FileManager fileManager;

    public CommandCooldown(Spawn plugin, FileManager fileManager) {
        this.fileManager = fileManager;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public int getCooldownTime() {
        YamlConfiguration config = this.fileManager.getYamlConfig();
        if (config.getBoolean("teleport-cooldown.enabled")) {
            return config.getInt("teleport-cooldown.seconds");
        }
        return 0;
    }

    public void setCooldown(UUID playerUUID) {
        this.cooldown.put(playerUUID, Instant.now().getEpochSecond());
    }

    public long getCooldown(UUID playerUUID) {
        return Instant.now().getEpochSecond() - this.cooldown.get(playerUUID);
    }

    public long getRemainingCooldown(UUID playerUUID) {
        return (long)this.getCooldownTime() - this.getCooldown(playerUUID);
    }

    public boolean isCooldownDone(UUID playerUUID) {
        if (!this.cooldown.containsKey(playerUUID)) {
            return true;
        }
        return this.getCooldown(playerUUID) >= (long)this.getCooldownTime();
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        this.cooldown.remove(event.getPlayer().getUniqueId());
    }
}

