/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.rockquiet.spawn.Spawn;
import me.rockquiet.spawn.SpawnHandler;
import me.rockquiet.spawn.configuration.FileManager;
import me.rockquiet.spawn.configuration.Messages;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CommandDelay
implements Listener {
    private final Map<UUID, BukkitTask> delay = new HashMap<UUID, BukkitTask>();
    private final Spawn plugin;
    private final FileManager fileManager;
    private final Messages messageManager;
    private final SpawnHandler spawnHandler;

    public CommandDelay(Spawn plugin, FileManager fileManager, Messages messageManager, SpawnHandler spawnHandler) {
        this.plugin = plugin;
        this.fileManager = fileManager;
        this.messageManager = messageManager;
        this.spawnHandler = spawnHandler;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public int getDelayTime() {
        YamlConfiguration config = this.fileManager.getYamlConfig();
        if (config.getBoolean("teleport-delay.enabled")) {
            return config.getInt("teleport-delay.seconds");
        }
        return 0;
    }

    public void runDelay(final Player player) {
        if (!this.spawnHandler.spawnExists()) {
            this.messageManager.sendMessage(player, "no-spawn");
            return;
        }
        final UUID playerUUID = player.getUniqueId();
        if (this.delay.containsKey(playerUUID)) {
            return;
        }
        final int delayTime = this.getDelayTime();
        if (delayTime <= 0) {
            return;
        }
        if (!player.hasPotionEffect(PotionEffectType.BLINDNESS) && this.fileManager.getYamlConfig().getBoolean("teleport-delay.blindness")) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, (delayTime + 1) * 20, 0, false, false));
        }
        this.delay.put(playerUUID, new BukkitRunnable(){
            int delayRemaining;
            {
                this.delayRemaining = delayTime;
            }

            public void run() {
                if (this.delayRemaining <= delayTime && this.delayRemaining >= 1) {
                    CommandDelay.this.messageManager.sendMessage(player, "delay-left", "%delay%", String.valueOf(this.delayRemaining));
                } else if (this.delayRemaining == 0) {
                    CommandDelay.this.spawnHandler.teleportPlayer(player);
                    CommandDelay.this.delay.remove(playerUUID);
                    this.cancel();
                }
                --this.delayRemaining;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L));
    }

    private void clearBlindness(Player player) {
        if (!player.hasPotionEffect(PotionEffectType.BLINDNESS) || !this.fileManager.getYamlConfig().getBoolean("teleport-delay.blindness")) {
            return;
        }
        if (Spawn.getServerVersion().getMinor() >= 10 && player.getPotionEffect(PotionEffectType.BLINDNESS).getDuration() <= (this.getDelayTime() + 1) * 20) {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("spawn.bypass.cancel-on-move") || event.getFrom().distanceSquared(event.getTo()) < 0.01) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.delay.containsKey(playerUUID)) {
            return;
        }
        if (this.fileManager.getYamlConfig().getBoolean("teleport-delay.cancel-on-move")) {
            this.delay.get(playerUUID).cancel();
            this.delay.remove(playerUUID);
            this.clearBlindness(player);
            this.messageManager.sendMessage(player, "teleport-canceled");
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.delay.containsKey(playerUUID)) {
            this.delay.get(playerUUID).cancel();
            this.delay.remove(playerUUID);
            this.clearBlindness(player);
        }
    }
}

