/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn.commands;

import java.util.Locale;
import java.util.UUID;
import me.rockquiet.spawn.Spawn;
import me.rockquiet.spawn.SpawnHandler;
import me.rockquiet.spawn.commands.CommandCooldown;
import me.rockquiet.spawn.commands.CommandDelay;
import me.rockquiet.spawn.configuration.FileManager;
import me.rockquiet.spawn.configuration.Messages;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SpawnCommand
implements CommandExecutor {
    private final FileManager fileManager;
    private final Messages messageManager;
    private final SpawnHandler spawnHandler;
    private final CommandCooldown commandCooldown;
    private final CommandDelay commandDelay;

    public SpawnCommand(Spawn plugin, FileManager fileManager, Messages messageManager, SpawnHandler spawnHandler) {
        this.fileManager = fileManager;
        this.messageManager = messageManager;
        this.spawnHandler = spawnHandler;
        this.commandCooldown = new CommandCooldown(plugin, fileManager);
        this.commandDelay = new CommandDelay(plugin, fileManager, messageManager, spawnHandler);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length == 0) {
            return this.spawn(sender);
        }
        if (args.length == 1) {
            switch (args[0].toLowerCase(Locale.ROOT)) {
                case "set": {
                    return this.setSpawn(sender);
                }
                case "reload": {
                    return this.reload(sender);
                }
            }
            if (!args[0].isEmpty()) {
                return this.spawnOther(sender, args);
            }
        }
        return false;
    }

    private boolean spawn(CommandSender sender) {
        if (this.isConsole(sender)) {
            return false;
        }
        YamlConfiguration config = this.fileManager.getYamlConfig();
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        if (this.hasNoPerms((CommandSender)player, "spawn.use")) {
            return false;
        }
        if (this.isWorldDisabled(player)) {
            return false;
        }
        if (this.isProhibitedGameMode(player)) {
            return false;
        }
        if (!player.hasPermission("spawn.bypass.cooldown") && config.getBoolean("teleport-cooldown.enabled") && this.commandCooldown.getCooldownTime() > 0) {
            if (this.commandCooldown.isCooldownDone(playerUUID)) {
                this.commandCooldown.setCooldown(playerUUID);
            } else {
                this.messageManager.sendMessage(player, "cooldown-left", "%cooldown%", String.valueOf(this.commandCooldown.getRemainingCooldown(playerUUID)));
                return false;
            }
        }
        if (!player.hasPermission("spawn.bypass.delay") && config.getBoolean("teleport-delay.enabled") && this.commandDelay.getDelayTime() > 0) {
            this.commandDelay.runDelay(player);
        } else {
            this.spawnHandler.teleportPlayer(player);
        }
        return true;
    }

    private boolean spawnOther(CommandSender sender, String[] args) {
        Player player;
        if (this.hasNoPerms(sender, "spawn.others")) {
            return false;
        }
        Player target = Bukkit.getServer().getPlayerExact(args[0]);
        if (target == null || !target.isOnline()) {
            this.messageManager.sendMessage(sender, "player-not-found", "%player%", args[0]);
            return false;
        }
        if (sender instanceof Player && (player = (Player)sender).equals(target) && this.isProhibitedGameMode(player)) {
            return false;
        }
        this.spawnHandler.teleportPlayer(target);
        this.messageManager.sendMessage(sender, "teleport-other", "%player%", target.getName());
        return true;
    }

    private boolean setSpawn(CommandSender sender) {
        if (this.isConsole(sender)) {
            return false;
        }
        Player player = (Player)sender;
        if (this.hasNoPerms((CommandSender)player, "spawn.set")) {
            return false;
        }
        if (this.isWorldDisabled(player)) {
            return false;
        }
        this.spawnHandler.setSpawn(player.getLocation(), true);
        this.messageManager.sendMessage(player, "spawn-set");
        return true;
    }

    private boolean reload(CommandSender sender) {
        if (this.hasNoPerms(sender, "spawn.reload")) {
            return false;
        }
        this.fileManager.reloadAll();
        this.spawnHandler.setSpawn(this.spawnHandler.loadSpawn(), false);
        this.messageManager.sendMessage(sender, "reload");
        return true;
    }

    private boolean isConsole(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            this.messageManager.sendMessage(sender, "no-player");
            return true;
        }
        return false;
    }

    private boolean hasNoPerms(CommandSender sender, String permission) {
        if (sender instanceof Player && !sender.hasPermission(permission)) {
            this.messageManager.sendMessage(sender, "no-permission");
            return true;
        }
        return false;
    }

    private boolean isWorldDisabled(Player player) {
        if (!player.hasPermission("spawn.bypass.world-list") && !this.spawnHandler.isEnabledInWorld(player.getWorld())) {
            this.messageManager.sendMessage(player, "world-disabled");
            return true;
        }
        return false;
    }

    private boolean isProhibitedGameMode(Player player) {
        if (!this.spawnHandler.isAllowedGameMode(player)) {
            this.messageManager.sendMessage(player, "gamemode-restricted", "%gamemode%", player.getGameMode().toString());
            return true;
        }
        return false;
    }
}

