/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.rockquiet.spawn.3rdparty.com.tchristofferson.configupdater.ConfigUpdater;
import me.rockquiet.spawn.Spawn;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class ConfigFile {
    static final String FILE_VERSION = "file-version";
    private final Spawn plugin;
    private final Path dataFolderPath;
    private final String fileName;
    private final Path filePath;
    private YamlConfiguration config;

    public ConfigFile(Spawn plugin, Path dataFolderPath, String name) {
        this.plugin = plugin;
        this.dataFolderPath = dataFolderPath;
        this.fileName = name + ".yml";
        this.filePath = dataFolderPath.resolve(this.fileName);
        this.reload();
    }

    public String getFileName() {
        return this.fileName;
    }

    public YamlConfiguration get() {
        if (this.config == null) {
            this.reload();
        }
        return this.config;
    }

    public boolean containsIgnoreDefault(String path) {
        return this.config.get(path, null) != null;
    }

    public void reload() {
        if (Files.notExists(this.filePath, new LinkOption[0])) {
            this.create();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.filePath.toFile());
        try (InputStream inputStream = this.plugin.getResource(this.fileName);){
            if (inputStream == null) {
                return;
            }
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                this.config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)reader));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Unable to load defaults for file: " + this.fileName);
            this.plugin.getLogger().warning(e.getMessage());
        }
    }

    public void create() {
        if (!Files.isDirectory(this.dataFolderPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.dataFolderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Unable to create plugin directory: " + this.dataFolderPath);
                this.plugin.getLogger().severe(e.getMessage());
            }
        }
        try (InputStream inputStream = this.plugin.getResource(this.fileName);){
            if (inputStream != null) {
                Files.copy(inputStream, this.filePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Unable to create file: " + this.fileName);
            this.plugin.getLogger().severe(e.getMessage());
        }
    }

    public void update(int bundledFileVersion) {
        if (Files.notExists(this.filePath, new LinkOption[0])) {
            this.create();
            return;
        }
        if (!this.containsIgnoreDefault(FILE_VERSION)) {
            return;
        }
        int currentFileVersion = this.config.getInt(FILE_VERSION);
        try {
            if (currentFileVersion < bundledFileVersion) {
                this.backup();
                ConfigUpdater.update((Plugin)this.plugin, this.fileName, this.filePath.toFile(), new String[0]);
                this.config.set(FILE_VERSION, (Object)bundledFileVersion);
                this.save();
                this.reload();
                this.plugin.getLogger().info("Successfully updated " + this.fileName + " (" + currentFileVersion + " -> " + bundledFileVersion + ")");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Unable to update " + this.fileName);
            this.plugin.getLogger().warning(e.getMessage());
        }
    }

    public void save() {
        try {
            this.config.save(this.filePath.toFile());
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Unable to save " + this.fileName);
            this.plugin.getLogger().severe(e.getMessage());
        }
    }

    public void backup() {
        Path backupsPath = this.dataFolderPath.resolve("backups");
        try {
            this.plugin.getLogger().info("Backing up " + this.fileName + " into the backups directory...");
            if (!Files.exists(backupsPath, new LinkOption[0])) {
                Files.createDirectory(backupsPath, new FileAttribute[0]);
            }
            Path fileBackupPath = backupsPath.resolve(new SimpleDateFormat("'" + this.fileName + "_'yyyyMMdd-HHmm'.yml'").format(new Date()));
            Files.copy(this.filePath, fileBackupPath, new CopyOption[0]);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Unable to backup " + this.fileName);
            this.plugin.getLogger().warning(e.getMessage());
        }
    }

    void delete() {
        try {
            Files.deleteIfExists(this.filePath);
            this.config = null;
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Unable to delete " + this.fileName);
            this.plugin.getLogger().warning(e.getMessage());
        }
    }
}

