/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn.configuration;

import java.nio.file.Path;
import me.rockquiet.spawn.Spawn;
import me.rockquiet.spawn.configuration.ConfigFile;
import me.rockquiet.spawn.configuration.LegacyConfigUpgrade;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileManager {
    private final ConfigFile config;
    private final ConfigFile messages;
    private final ConfigFile location;

    public FileManager(Spawn plugin) {
        Path dataFolderPath = plugin.getDataFolder().toPath();
        this.config = new ConfigFile(plugin, dataFolderPath, "config");
        this.messages = new ConfigFile(plugin, dataFolderPath, "messages");
        this.location = new ConfigFile(plugin, dataFolderPath, "location");
        if (LegacyConfigUpgrade.isLegacyConfig(this.config)) {
            new LegacyConfigUpgrade(plugin, this).start();
        } else {
            this.config.update(6);
        }
        this.messages.update(3);
    }

    public ConfigFile getConfig() {
        return this.config;
    }

    public YamlConfiguration getYamlConfig() {
        return this.config.get();
    }

    public ConfigFile getMessages() {
        return this.messages;
    }

    public YamlConfiguration getYamlMessages() {
        return this.messages.get();
    }

    public ConfigFile getLocation() {
        return this.location;
    }

    public YamlConfiguration getYamlLocation() {
        return this.location.get();
    }

    public void reloadAll() {
        this.config.reload();
        this.messages.reload();
        this.location.reload();
    }
}

