/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.rockquiet.spawn.Spawn;
import me.rockquiet.spawn.configuration.ConfigFile;
import me.rockquiet.spawn.configuration.FileManager;
import org.bukkit.configuration.file.YamlConfiguration;

public class LegacyConfigUpgrade {
    private static final String CONFIG_SECTION = "options";
    private static final String MESSAGES_SECTION = "messages";
    private static final String LOCATION_SECTION = "spawn";
    private final Spawn plugin;
    private final FileManager fileManager;

    public LegacyConfigUpgrade(Spawn plugin, FileManager fileManager) {
        this.plugin = plugin;
        this.fileManager = fileManager;
    }

    public static boolean isLegacyConfig(ConfigFile configFile) {
        boolean hasLegacyConfigSections = configFile.containsIgnoreDefault(CONFIG_SECTION) && configFile.containsIgnoreDefault(MESSAGES_SECTION) && configFile.containsIgnoreDefault(LOCATION_SECTION);
        boolean hasFileVersion = configFile.containsIgnoreDefault("file-version");
        return hasLegacyConfigSections && !hasFileVersion;
    }

    public void start() {
        String fileName = this.fileManager.getConfig().getFileName();
        this.plugin.getLogger().warning("Found legacy " + fileName + " - The plugin will now upgrade it to the latest format");
        YamlConfiguration legacyFileConfig = this.fileManager.getConfig().get();
        Map<String, Object> optionsMap = legacyFileConfig.getConfigurationSection(CONFIG_SECTION).getKeys(false).stream().collect(Collectors.toMap(Function.identity(), key -> legacyFileConfig.getConfigurationSection(CONFIG_SECTION).get(key)));
        this.upgradeConfigSection(optionsMap);
        Map<String, Object> messagesMap = legacyFileConfig.getConfigurationSection(MESSAGES_SECTION).getKeys(false).stream().collect(Collectors.toMap(Function.identity(), key -> legacyFileConfig.getConfigurationSection(MESSAGES_SECTION).get(key)));
        messagesMap.remove("config-reload");
        this.upgradeSection(this.fileManager.getMessages(), messagesMap, "");
        Map<String, Object> locationMap = legacyFileConfig.getConfigurationSection(LOCATION_SECTION).getKeys(false).stream().collect(Collectors.toMap(Function.identity(), key -> legacyFileConfig.getConfigurationSection(LOCATION_SECTION).get(key)));
        if (!locationMap.isEmpty()) {
            this.upgradeSection(this.fileManager.getLocation(), locationMap, LOCATION_SECTION);
        }
        this.fileManager.reloadAll();
        this.plugin.getLogger().warning("Successfully upgraded legacy " + fileName);
        this.plugin.getLogger().warning("Please check if everything upgraded correctly!");
    }

    private void upgradeConfigSection(Map<String, Object> optionsMap) {
        ConfigFile config = this.fileManager.getConfig();
        config.backup();
        config.delete();
        YamlConfiguration yamlConfiguration = config.get();
        HashMap<String, String> values = new HashMap<String, String>(10);
        values.put("fall-damage", "fall-damage.enabled");
        values.put("teleport-on-join", "teleport-on-join.enabled");
        values.put("teleport-on-first-join", "teleport-on-join.only-first-join");
        values.put("cancel-on-move", "teleport-delay.cancel-on-move");
        values.put("teleport-out-of-void", "teleport-out-of-void.enabled");
        values.put("void-check-height", "teleport-out-of-void.check-height");
        values.put("teleport-on-respawn", "teleport-on-respawn.enabled");
        values.put("ignore-bed-spawn", "teleport-on-respawn.ignore-bed-spawn");
        values.put("particle", "particles.particle");
        values.put("sound", "sounds.sound");
        values.put("sound-pitch", "sounds.pitch");
        values.forEach((legacyKey, key) -> this.renameKey(yamlConfiguration, optionsMap, (String)legacyKey, (String)key));
        this.renameKeyUpdateOrDisable(yamlConfiguration, optionsMap, "teleport-cooldown", "teleport-cooldown.enabled", "teleport-cooldown.seconds");
        this.renameKeyUpdateOrDisable(yamlConfiguration, optionsMap, "teleport-delay", "teleport-delay.enabled", "teleport-delay.seconds");
        this.renameKeyUpdateOrDisable(yamlConfiguration, optionsMap, "particle-amount", "particles.enabled", "particles.amount");
        this.renameKeyUpdateOrDisable(yamlConfiguration, optionsMap, "sound-volume", "sounds.enabled", "sounds.volume");
        config.save();
    }

    private void renameKey(YamlConfiguration config, Map<String, Object> optionsMap, String legacyKey, String key) {
        if (optionsMap.containsKey(legacyKey)) {
            config.set(key, optionsMap.get(legacyKey));
        }
    }

    private void renameKeyUpdateOrDisable(YamlConfiguration config, Map<String, Object> optionsMap, String legacyKey, String enabledKey, String valueKey) {
        if (optionsMap.containsKey(legacyKey)) {
            Number number = (Number)optionsMap.get(legacyKey);
            if (number.doubleValue() <= 0.0) {
                config.set(enabledKey, (Object)false);
            } else {
                config.set(valueKey, (Object)number);
            }
        }
    }

    private void upgradeSection(ConfigFile configFile, Map<String, Object> sectionMap, String sectionName) {
        YamlConfiguration yamlConfiguration = configFile.get();
        for (Map.Entry<String, Object> entry : sectionMap.entrySet()) {
            String key = sectionName.isEmpty() ? entry.getKey() : sectionName + "." + entry.getKey();
            Object value = entry.getValue();
            yamlConfiguration.set(key, value);
        }
        configFile.save();
    }
}

