/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn.configuration;

import me.rockquiet.spawn.configuration.FileManager;
import me.rockquiet.spawn.configuration.Messages;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager
implements Messages {
    private final FileManager fileManager;
    private final MiniMessage msg;

    public MessageManager(FileManager fileManager) {
        this.fileManager = fileManager;
        this.msg = MiniMessage.miniMessage();
    }

    @Override
    public boolean messageExists(String messagePath) {
        YamlConfiguration messages = this.fileManager.getYamlMessages();
        return messages.getString(messagePath) != null && !messages.getString(messagePath).isEmpty();
    }

    @Override
    public String getMessage(String messagePath) {
        YamlConfiguration messages = this.fileManager.getYamlMessages();
        return messages.getString(messagePath).replace("%prefix%", messages.getString("prefix") != null ? messages.getString("prefix") : "");
    }

    public String convertLegacyToMiniMessage(String string) {
        return string.replace("&0", "<black>").replace("&1", "<dark_blue>").replace("&2", "<dark_green>").replace("&3", "<dark_aqua>").replace("&4", "<dark_red>").replace("&5", "<dark_purple>").replace("&6", "<gold>").replace("&7", "<gray>").replace("&8", "<dark_gray>").replace("&9", "<blue>").replace("&a", "<green>").replace("&b", "<aqua>").replace("&c", "<red>").replace("&d", "<light_purple>").replace("&e", "<yellow>").replace("&f", "<white>").replace("&k", "<obf>").replace("&l", "<b>").replace("&m", "<st>").replace("&n", "<u>").replace("&o", "<i>").replace("&r", "<reset>");
    }

    @Override
    public void sendMessage(Player player, String messagePath) {
        if (this.messageExists(messagePath)) {
            player.sendMessage(this.msg.deserialize((Object)this.convertLegacyToMiniMessage(this.getMessage(messagePath))));
        }
    }

    @Override
    public void sendMessage(Player player, String messagePath, String placeholder, String replacePlaceholder) {
        if (this.messageExists(messagePath)) {
            player.sendMessage(this.msg.deserialize((Object)this.convertLegacyToMiniMessage(this.getMessage(messagePath)).replace(placeholder, replacePlaceholder)));
        }
    }

    @Override
    public void sendMessage(CommandSender sender, String messagePath) {
        if (this.messageExists(messagePath)) {
            sender.sendMessage(this.msg.deserialize((Object)this.convertLegacyToMiniMessage(this.getMessage(messagePath))));
        }
    }

    @Override
    public void sendMessage(CommandSender sender, String messagePath, String placeholder, String replacePlaceholder) {
        if (this.messageExists(messagePath)) {
            sender.sendMessage(this.msg.deserialize((Object)this.convertLegacyToMiniMessage(this.getMessage(messagePath)).replace(placeholder, replacePlaceholder)));
        }
    }
}

