/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn.configuration;

import me.rockquiet.spawn.configuration.FileManager;
import me.rockquiet.spawn.configuration.Messages;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManagerLegacy
implements Messages {
    private final FileManager fileManager;

    public MessageManagerLegacy(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    @Override
    public boolean messageExists(String messagePath) {
        YamlConfiguration messages = this.fileManager.getYamlMessages();
        return messages.getString(messagePath) != null && !messages.getString(messagePath).isEmpty();
    }

    @Override
    public String getMessage(String messagePath) {
        YamlConfiguration messages = this.fileManager.getYamlMessages();
        return messages.getString(messagePath).replace("%prefix%", messages.getString("prefix") != null ? messages.getString("prefix") : "");
    }

    @Override
    public void sendMessage(Player player, String messagePath) {
        if (this.messageExists(messagePath)) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getMessage(messagePath)));
        }
    }

    @Override
    public void sendMessage(Player player, String messagePath, String placeholder, String replacePlaceholder) {
        if (this.messageExists(messagePath)) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getMessage(messagePath)).replace(placeholder, replacePlaceholder));
        }
    }

    @Override
    public void sendMessage(CommandSender sender, String messagePath) {
        if (this.messageExists(messagePath)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getMessage(messagePath)));
        }
    }

    @Override
    public void sendMessage(CommandSender sender, String messagePath, String placeholder, String replacePlaceholder) {
        if (this.messageExists(messagePath)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getMessage(messagePath)).replace(placeholder, replacePlaceholder));
        }
    }
}

