/*
 * Decompiled with CFR 0.152.
 */
package me.rockquiet.spawn.updater;

public class Version {
    private final int major;
    private final int minor;
    private final int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version parse(String version) {
        int suffixIndex;
        if (version == null) {
            throw new IllegalArgumentException("Version string cannot be null");
        }
        if (version.isEmpty()) {
            throw new IllegalArgumentException("Version string cannot be empty");
        }
        if ((version = version.replaceFirst("^[Vv]", "")).contains("-") && !version.startsWith("-") && (suffixIndex = version.indexOf(45)) != -1) {
            version = version.substring(0, suffixIndex);
        }
        String[] versionSegments = version.split("\\.");
        int length = versionSegments.length;
        return new Version(Version.parseInt(versionSegments[0]), length < 2 ? 0 : Version.parseInt(versionSegments[1]), length < 3 ? 0 : Version.parseInt(versionSegments[2]));
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int compareTo(Version version2) {
        if (version2 == null) {
            return 1;
        }
        int compareMajor = Integer.compare(this.major, version2.major);
        if (compareMajor != 0) {
            return compareMajor;
        }
        int compareMinor = Integer.compare(this.minor, version2.minor);
        if (compareMinor != 0) {
            return compareMinor;
        }
        return Integer.compare(this.patch, version2.patch);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

