/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.action;

import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.function.SQLExceptionHandler;
import cc.carm.lib.easysql.api.function.SQLHandler;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSQLAction<T>
implements SQLAction<T> {
    @NotNull
    protected final String sqlContent;
    @NotNull
    private final SQLManagerImpl sqlManager;
    @NotNull
    private final UUID uuid;
    private final long createNanoTime;

    public AbstractSQLAction(@NotNull SQLManagerImpl manager, @NotNull String sql) {
        this(manager, sql, System.nanoTime());
    }

    public AbstractSQLAction(@NotNull SQLManagerImpl manager, @NotNull String sql, @NotNull UUID uuid) {
        this(manager, sql, uuid, System.nanoTime());
    }

    public AbstractSQLAction(@NotNull SQLManagerImpl manager, @NotNull String sql, long createNanoTime) {
        this(manager, sql, UUID.randomUUID(), createNanoTime);
    }

    public AbstractSQLAction(@NotNull SQLManagerImpl manager, @NotNull String sql, @NotNull UUID uuid, long createNanoTime) {
        Objects.requireNonNull(manager);
        Objects.requireNonNull(sql);
        Objects.requireNonNull(uuid);
        this.sqlManager = manager;
        this.sqlContent = sql;
        this.uuid = uuid;
        this.createNanoTime = createNanoTime;
    }

    @Override
    @NotNull
    public UUID getActionUUID() {
        return this.uuid;
    }

    @Override
    @NotNull
    public String getShortID() {
        return this.getActionUUID().toString().substring(0, 8);
    }

    @Override
    public long getCreateTime(TimeUnit unit) {
        return unit.convert(this.createNanoTime, TimeUnit.NANOSECONDS);
    }

    @Override
    @NotNull
    public String getSQLContent() {
        return this.sqlContent.trim();
    }

    @Override
    @NotNull
    public SQLManagerImpl getManager() {
        return this.sqlManager;
    }

    protected void debugMessage(List<Object[]> params) {
        if (this.getManager().isDebugMode()) {
            try {
                this.getManager().getDebugHandler().beforeExecute(this, params);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void executeAsync(SQLHandler<T> success, SQLExceptionHandler failure) {
        this.getManager().getExecutorPool().submit(() -> {
            try {
                Object returnedValue = this.execute();
                if (success != null) {
                    success.accept(returnedValue);
                }
            }
            catch (SQLException e) {
                this.handleException(failure, e);
            }
        });
    }
}

