/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.action.query;

import cc.carm.lib.easysql.action.query.QueryActionImpl;
import cc.carm.lib.easysql.api.action.query.PreparedQueryAction;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import cc.carm.lib.easysql.query.SQLQueryImpl;
import cc.carm.lib.easysql.util.StatementUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreparedQueryActionImpl
extends QueryActionImpl
implements PreparedQueryAction {
    Consumer<PreparedStatement> handler;
    Object[] params;

    public PreparedQueryActionImpl(@NotNull SQLManagerImpl manager, @NotNull String sql) {
        super(manager, sql);
    }

    @Override
    public PreparedQueryActionImpl setParams(Object ... params) {
        this.params = params;
        return this;
    }

    @Override
    public PreparedQueryActionImpl setParams(@Nullable Iterable<Object> params) {
        if (params == null) {
            return this.setParams((Object[])null);
        }
        ArrayList paramsList = new ArrayList();
        params.forEach(paramsList::add);
        return this.setParams(paramsList.toArray());
    }

    @Override
    public PreparedQueryActionImpl handleStatement(@Nullable Consumer<PreparedStatement> statement) {
        this.handler = statement;
        return this;
    }

    @Override
    @NotNull
    public SQLQueryImpl execute() throws SQLException {
        PreparedStatement preparedStatement;
        this.debugMessage(Collections.singletonList(this.params));
        Connection connection = this.getManager().getConnection();
        try {
            if (this.handler == null) {
                preparedStatement = StatementUtil.createPrepareStatement(connection, this.getSQLContent(), this.params);
            } else {
                preparedStatement = connection.prepareStatement(this.getSQLContent());
                this.handler.accept(preparedStatement);
            }
        }
        catch (SQLException exception) {
            connection.close();
            throw exception;
        }
        try {
            SQLQueryImpl query = new SQLQueryImpl(this.getManager(), this, connection, preparedStatement, preparedStatement.executeQuery());
            this.getManager().getActiveQuery().put(this.getActionUUID(), query);
            return query;
        }
        catch (SQLException exception) {
            preparedStatement.close();
            connection.close();
            throw exception;
        }
    }
}

