/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api.function;

import cc.carm.lib.easysql.api.SQLAction;
import java.sql.SQLException;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

@FunctionalInterface
public interface SQLExceptionHandler
extends BiConsumer<SQLException, SQLAction<?>> {
    public static SQLExceptionHandler detailed(Logger logger) {
        return (exception, sqlAction) -> {
            logger.error("Error occurred while executing SQL: ");
            int i = 1;
            for (String content : sqlAction.getSQLContents()) {
                logger.error(String.format("#%d {%s}", i, content));
                ++i;
            }
            exception.printStackTrace();
        };
    }

    public static SQLExceptionHandler silent() {
        return (exception, sqlAction) -> {};
    }
}

