/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.action.query.PreparedQueryActionImpl;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.action.query.PreparedQueryAction;
import cc.carm.lib.easysql.api.builder.TableQueryBuilder;
import cc.carm.lib.easysql.builder.impl.AbstractConditionalBuilder;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableQueryBuilderImpl
extends AbstractConditionalBuilder<TableQueryBuilder, PreparedQueryAction>
implements TableQueryBuilder {
    @NotNull
    protected final String tableName;
    String[] columns;
    @Nullable
    String orderBy;
    int[] pageLimit;

    public TableQueryBuilderImpl(@NotNull SQLManagerImpl manager, @NotNull String tableName) {
        super(manager);
        this.tableName = tableName;
    }

    @Override
    public PreparedQueryActionImpl build() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT").append(" ");
        if (this.columns == null || this.columns.length < 1) {
            sqlBuilder.append("*");
        } else {
            for (int i = 0; i < this.columns.length; ++i) {
                String name = this.columns[i];
                sqlBuilder.append(SQLBuilder.withBackQuote(name));
                if (i == this.columns.length - 1) continue;
                sqlBuilder.append(",");
            }
        }
        sqlBuilder.append(" ").append("FROM").append(" ").append(SQLBuilder.withBackQuote(this.tableName));
        if (this.hasConditions()) {
            sqlBuilder.append(" ").append(this.buildConditionSQL());
        }
        if (this.orderBy != null) {
            sqlBuilder.append(" ").append(this.orderBy);
        }
        if (this.pageLimit != null && this.pageLimit.length == 2) {
            sqlBuilder.append(" LIMIT ").append(this.pageLimit[0]).append(",").append(this.pageLimit[1]);
        } else if (this.limit > 0) {
            sqlBuilder.append(" ").append(this.buildLimitSQL());
        }
        return new PreparedQueryActionImpl(this.getManager(), sqlBuilder.toString()).setParams(this.hasConditionParams() ? this.getConditionParams() : null);
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public TableQueryBuilderImpl selectColumns(String ... columnNames) {
        Objects.requireNonNull(columnNames, "columnNames could not be null");
        this.columns = columnNames;
        return this;
    }

    @Override
    public TableQueryBuilder orderBy(@NotNull String columnName, boolean asc) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        this.orderBy = "ORDER BY " + SQLBuilder.withBackQuote(columnName) + " " + (asc ? "ASC" : "DESC");
        return this;
    }

    @Override
    public TableQueryBuilder setPageLimit(int start, int end) {
        this.pageLimit = new int[]{start, end};
        return this;
    }

    @Override
    protected TableQueryBuilderImpl getThis() {
        return this;
    }
}

