/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.cache;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.database.SQLDatabase;
import cn.superiormc.ultimateshop.database.YamlDatabase;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerCache
extends ServerCache {
    private Player player;

    public PlayerCache(Player player) {
        super(player);
        this.player = player;
    }

    public void initPlayerCache() {
        if (UltimateShop.isFolia) {
            if (ConfigManager.configManager.getBoolean("database.enabled")) {
                SQLDatabase.checkData(this);
            } else {
                YamlDatabase.checkData(this);
            }
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)UltimateShop.instance, () -> {
            if (ConfigManager.configManager.getBoolean("database.enabled")) {
                SQLDatabase.checkData(this);
            } else {
                YamlDatabase.checkData(this);
            }
        });
    }

    public void shutPlayerCache(boolean quitServer) {
        if (UltimateShop.isFolia) {
            if (ConfigManager.configManager.getBoolean("database.enabled")) {
                SQLDatabase.updateData(this, quitServer);
            } else {
                YamlDatabase.updateData(this, quitServer);
            }
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)UltimateShop.instance, () -> {
            if (ConfigManager.configManager.getBoolean("database.enabled")) {
                SQLDatabase.updateData(this, quitServer);
            } else {
                YamlDatabase.updateData(this, quitServer);
            }
        });
    }

    public void shutPlayerCacheOnDisable(boolean disable) {
        if (ConfigManager.configManager.getBoolean("database.enabled")) {
            SQLDatabase.updateDataOnDisable(this, disable);
        } else {
            YamlDatabase.updateData(this, true);
        }
    }
}

