/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.commands;

import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.commands.AbstractCommand;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SubAddSellTimes
extends AbstractCommand {
    public SubAddSellTimes() {
        this.id = "addselltimes";
        this.requiredPermission = "ultimateshop." + this.id;
        this.onlyInGame = false;
        this.requiredArgLength = new Integer[]{5};
    }

    @Override
    public void executeCommandInGame(String[] args, Player player) {
        ObjectItem tempVal2;
        ServerCache tempVal3;
        ObjectShop tempVal1 = ConfigManager.configManager.getShop(args[1]);
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText("error.shop-not-found", "shop", args[1]);
            return;
        }
        if (args[3].equals("global")) {
            tempVal3 = ServerCache.serverCache;
        } else {
            Player changePlayer = Bukkit.getPlayer((String)args[3]);
            if (changePlayer == null) {
                LanguageManager.languageManager.sendStringText(player, "error.player-not-found", "player", args[3]);
                return;
            }
            tempVal3 = CacheManager.cacheManager.getPlayerCache(changePlayer);
        }
        if (tempVal3 == null) {
            LanguageManager.languageManager.sendStringText(player, "error.player-not-found", "player", args[3]);
            return;
        }
        if (args[2].equals("*")) {
            // empty if block
        }
        if ((tempVal2 = tempVal1.getProduct(args[2])) == null) {
            LanguageManager.languageManager.sendStringText(player, "error.product-not-found", "product", args[2]);
            return;
        }
        ObjectUseTimesCache tempVal4 = tempVal3.getUseTimesCache().get(tempVal2);
        if (tempVal4 == null) {
            tempVal3.setUseTimesCache(tempVal1.getShopName(), tempVal2.getProduct(), 0, Integer.parseInt(args[4]), null, null, null, null);
        } else {
            tempVal4.setSellUseTimes(Integer.parseInt(args[4]) + tempVal4.getSellUseTimes());
        }
        LanguageManager.languageManager.sendStringText(player, "add-times", "player", args[3], "item", args[2], "times", args[4]);
    }

    @Override
    public void executeCommandInConsole(String[] args) {
        ObjectItem tempVal2;
        ServerCache tempVal3;
        ObjectShop tempVal1 = ConfigManager.configManager.getShop(args[1]);
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText("error.shop-not-found", "shop", args[1]);
            return;
        }
        if (args[3].equals("global")) {
            tempVal3 = ServerCache.serverCache;
        } else {
            Player changePlayer = Bukkit.getPlayer((String)args[3]);
            if (changePlayer == null) {
                LanguageManager.languageManager.sendStringText("error.player-not-found", "player", args[3]);
                return;
            }
            tempVal3 = CacheManager.cacheManager.getPlayerCache(changePlayer);
        }
        if (tempVal3 == null) {
            LanguageManager.languageManager.sendStringText("error.player-not-found", "player", args[3]);
            return;
        }
        if (args[2].equals("*")) {
            // empty if block
        }
        if ((tempVal2 = tempVal1.getProduct(args[2])) == null) {
            LanguageManager.languageManager.sendStringText("error.product-not-found", "product", args[2]);
            return;
        }
        ObjectUseTimesCache tempVal4 = tempVal3.getUseTimesCache().get(tempVal2);
        if (tempVal4 == null) {
            tempVal3.setUseTimesCache(tempVal1.getShopName(), tempVal2.getProduct(), 0, Integer.parseInt(args[4]), null, null, null, null);
        } else {
            tempVal4.setSellUseTimes(Integer.parseInt(args[4]) + tempVal4.getBuyUseTimes());
        }
        LanguageManager.languageManager.sendStringText("add-times", "player", args[3], "item", args[2], "times", args[4]);
    }

    @Override
    public List<String> getTabResult(String[] args) {
        ArrayList<String> tempVal1 = new ArrayList<String>();
        switch (args.length) {
            case 2: {
                for (ObjectShop tempVal2 : ConfigManager.configManager.getShops()) {
                    tempVal1.add(tempVal2.getShopName());
                }
                break;
            }
            case 3: {
                ObjectShop tempVal3 = ConfigManager.configManager.getShop(args[1]);
                if (tempVal3 == null) {
                    tempVal1.add(LanguageManager.languageManager.getStringText("command-tab.unknown-shop"));
                    break;
                }
                for (ObjectItem tempVal4 : tempVal3.getProductList()) {
                    tempVal1.add(tempVal4.getItemConfig().getName());
                }
                break;
            }
            case 4: {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    tempVal1.add(player.getName());
                }
                tempVal1.add("global");
                break;
            }
            case 5: {
                tempVal1.add("0");
                tempVal1.add("5");
            }
        }
        return tempVal1;
    }
}

