/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.database;

import cc.carm.lib.easysql.EasySQL;
import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.action.query.QueryAction;
import cc.carm.lib.easysql.api.builder.DeleteBuilder;
import cc.carm.lib.easysql.api.builder.TableQueryBuilder;
import cc.carm.lib.easysql.hikari.HikariConfig;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;

public class SQLDatabase {
    public static SQLManager sqlManager;

    public static void initSQL() {
        Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7fTrying connect to SQL database...");
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(ConfigManager.configManager.getString("database.jdbc-class", new String[0]));
        config.setJdbcUrl(ConfigManager.configManager.getString("database.jdbc-url", new String[0]));
        if (ConfigManager.configManager.getString("database.properties.user", new String[0]) != null) {
            config.setUsername(ConfigManager.configManager.getString("database.properties.user", new String[0]));
            config.setPassword(ConfigManager.configManager.getString("database.properties.password", new String[0]));
        }
        sqlManager = EasySQL.createManager(config);
        try {
            if (!sqlManager.getConnection().isValid(5)) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cFailed connect to SQL database!");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        SQLDatabase.createTable();
    }

    public static void closeSQL() {
        if (Objects.nonNull(sqlManager)) {
            EasySQL.shutdownManager(sqlManager);
            sqlManager = null;
        }
    }

    public static void createTable() {
        sqlManager.createTable("ultimateshop_useTimes").addColumn("playerUUID", "VARCHAR(36)").addColumn("shop", "VARCHAR(48)").addColumn("product", "VARCHAR(1)").addColumn("buyUseTimes", "INT").addColumn("sellUseTimes", "INT").addColumn("lastBuyTime", "DATETIME").addColumn("lastSellTime", "DATETIME").addColumn("cooldownBuyTime", "DATETIME").addColumn("cooldownSellTime", "DATETIME").build().execute(null);
    }

    public static void checkData(ServerCache cache) {
        QueryAction queryAction1 = cache.server ? (QueryAction)((TableQueryBuilder)sqlManager.createQuery().inTable("ultimateshop_useTimes").selectColumns("playerUUID", "shop", "product", "buyUseTimes", "sellUseTimes", "lastBuyTime", "lastSellTime", "cooldownBuyTime", "cooldownSellTime").addCondition("playerUUID = 'Global-Server'")).build() : (QueryAction)((TableQueryBuilder)sqlManager.createQuery().inTable("ultimateshop_useTimes").selectColumns("playerUUID", "shop", "product", "buyUseTimes", "sellUseTimes", "lastBuyTime", "lastSellTime", "cooldownBuyTime", "cooldownSellTime").addCondition("playerUUID = '" + cache.player.getUniqueId() + "'")).build();
        queryAction1.executeAsync(result -> {
            while (result.getResultSet().next()) {
                String shop = result.getResultSet().getString("shop");
                String product = result.getResultSet().getString("product");
                int buyUseTimes = result.getResultSet().getInt("buyUseTimes");
                int sellUseTimes = result.getResultSet().getInt("sellUseTimes");
                String lastPurchaseTime = result.getResultSet().getString("lastBuyTime");
                String lastSellTime = result.getResultSet().getString("lastSellTime");
                String cooldownPurchaseTime = result.getResultSet().getString("cooldownBuyTime");
                String cooldownSellTime = result.getResultSet().getString("cooldownSellTime");
                cache.setUseTimesCache(shop, product, buyUseTimes, sellUseTimes, lastPurchaseTime, lastSellTime, cooldownPurchaseTime, cooldownSellTime);
            }
        });
        if (cache.server) {
            // empty if block
        }
    }

    public static void updateData(ServerCache cache, boolean quitServer) {
        String playerUUID = cache.server ? "Global-Server" : cache.player.getUniqueId().toString();
        Map<ObjectItem, ObjectUseTimesCache> tempVal1 = cache.getUseTimesCache();
        for (ObjectItem tempVal2 : tempVal1.keySet()) {
            try {
                ((DeleteBuilder)((DeleteBuilder)((DeleteBuilder)sqlManager.createDelete("ultimateshop_useTimes").addCondition("playerUUID = '" + playerUUID + "'")).addCondition("shop = '" + tempVal2.getShop() + "'")).addCondition("product = '" + tempVal2.getProduct() + "'")).build().execute();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            int buyUseTimes = tempVal1.get(tempVal2).getBuyUseTimes();
            int sellUseTimes = tempVal1.get(tempVal2).getSellUseTimes();
            String lastBuyTime = tempVal1.get(tempVal2).getLastBuyTime();
            String lastSellTime = tempVal1.get(tempVal2).getLastSellTime();
            String cooldownBuyTime = tempVal1.get(tempVal2).getCooldownBuyTime();
            String cooldownSellTime = tempVal1.get(tempVal2).getCooldownSellTime();
            if (buyUseTimes == 0 && sellUseTimes == 0 && lastBuyTime == null && lastSellTime == null && cooldownBuyTime == null && cooldownSellTime == null) continue;
            if (cache.server) {
                cooldownBuyTime = null;
                cooldownSellTime = null;
            }
            sqlManager.createInsert("ultimateshop_useTimes").setColumnNames("playerUUID", "shop", "product", "buyUseTimes", "sellUseTimes", "lastBuyTime", "lastSellTime", "cooldownBuyTime", "cooldownSellTime").setParams(playerUUID, tempVal2.getShop(), tempVal2.getProduct(), buyUseTimes, sellUseTimes, lastBuyTime, lastSellTime, cooldownBuyTime, cooldownSellTime).executeAsync();
        }
        if (cache.server) {
            // empty if block
        }
        if (quitServer) {
            CacheManager.cacheManager.removePlayerCache(cache.player);
        }
    }

    public static void updateDataOnDisable(ServerCache cache, boolean disable) {
        String playerUUID = cache.server ? "Global-Server" : cache.player.getUniqueId().toString();
        Map<ObjectItem, ObjectUseTimesCache> tempVal1 = cache.getUseTimesCache();
        for (ObjectItem tempVal2 : tempVal1.keySet()) {
            try {
                int buyUseTimes = tempVal1.get(tempVal2).getBuyUseTimes();
                int sellUseTimes = tempVal1.get(tempVal2).getSellUseTimes();
                String lastBuyTime = tempVal1.get(tempVal2).getLastBuyTime();
                String lastSellTime = tempVal1.get(tempVal2).getLastSellTime();
                String cooldownBuyTime = tempVal1.get(tempVal2).getCooldownBuyTime();
                String cooldownSellTime = tempVal1.get(tempVal2).getCooldownSellTime();
                if (buyUseTimes == 0 && sellUseTimes == 0 && lastBuyTime == null && lastSellTime == null && cooldownBuyTime == null && cooldownSellTime == null) continue;
                if (cache.server) {
                    cooldownBuyTime = null;
                    cooldownSellTime = null;
                }
                sqlManager.createReplace("ultimateshop_useTimes").setColumnNames("playerUUID", "shop", "product", "buyUseTimes", "sellUseTimes", "lastBuyTime", "lastSellTime", "cooldownBuyTime", "cooldownSellTime").setParams(playerUUID, tempVal2.getShop(), tempVal2.getProduct(), buyUseTimes, sellUseTimes, lastBuyTime, lastSellTime, cooldownBuyTime, cooldownSellTime).execute();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (cache.server) {
            // empty if block
        }
        CacheManager.cacheManager.removePlayerCache(cache.player);
    }

    private static /* synthetic */ void lambda$checkData$1(ServerCache cache, SQLQuery result) throws SQLException {
        while (result.getResultSet().next()) {
            String placeholderID = result.getResultSet().getString("placeholderID");
            String nowValue = result.getResultSet().getString("nowValue");
            String refreshDoneTime = result.getResultSet().getString("refreshDoneTime");
            cache.setRandomPlaceholderCache(placeholderID, refreshDoneTime, nowValue);
        }
    }
}

