/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.database;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectRandomPlaceholderCache;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlDatabase {
    public static void checkData(ServerCache cache) {
        ConfigurationSection randomPlaceholderSection;
        ConfigurationSection useTimeSection;
        HashMap<String, String> data;
        YamlConfiguration config;
        File dir = new File(UltimateShop.instance.getDataFolder() + "/datas");
        if (!dir.exists()) {
            dir.mkdir();
        }
        File file = null;
        if (!cache.server) {
            file = new File(dir, cache.player.getUniqueId() + ".yml");
            if (!file.exists()) {
                config = new YamlConfiguration();
                data = new HashMap();
                try {
                    data.put("playerName", cache.player.getName());
                    for (String key : data.keySet()) {
                        config.set(key, data.get(key));
                    }
                    config.save(file);
                }
                catch (IOException e) {
                    ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not create new data file: " + cache.player.getUniqueId() + ".yml!");
                }
            }
        } else {
            file = new File(dir, "global.yml");
            if (!file.exists()) {
                config = new YamlConfiguration();
                data = new HashMap<String, String>();
                try {
                    data.put("playerName", "global");
                    for (String key : data.keySet()) {
                        config.set(key, data.get(key));
                    }
                    config.save(file);
                }
                catch (IOException e) {
                    ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not create new data file: global.yml!");
                }
            }
        }
        if ((useTimeSection = (config = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("useTimes")) != null) {
            for (String shopID : useTimeSection.getKeys(false)) {
                ConfigurationSection tempVal3 = useTimeSection.getConfigurationSection(shopID);
                for (String productID : tempVal3.getKeys(false)) {
                    ConfigurationSection tempVal4 = tempVal3.getConfigurationSection(productID);
                    int buyUseTimes = tempVal4.getInt("buyUseTimes", 0);
                    int sellUseTimes = tempVal4.getInt("sellUseTimes", 0);
                    String lastPurchaseTime = tempVal4.getString("lastBuyTime", null);
                    String lastSellTime = tempVal4.getString("lastSellTime", null);
                    String cooldownPurchaseTime = tempVal4.getString("cooldownBuyTime", null);
                    String cooldownSellTime = tempVal4.getString("cooldownSellTime", null);
                    cache.setUseTimesCache(shopID, productID, buyUseTimes, sellUseTimes, lastPurchaseTime, lastSellTime, cooldownPurchaseTime, cooldownSellTime);
                }
            }
        }
        if (!cache.server || (randomPlaceholderSection = config.getConfigurationSection("randomPlaceholder")) != null) {
            // empty if block
        }
    }

    public static void updateData(ServerCache cache, boolean quitServer) {
        boolean needDelete = false;
        File dir = new File(UltimateShop.instance.getDataFolder() + "/datas");
        if (!dir.exists()) {
            dir.mkdir();
        }
        File file = null;
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (cache.server) {
            data.put("playerName", "global");
            cache = ServerCache.serverCache;
            file = new File(dir, "global.yml");
            if (file.exists()) {
                needDelete = true;
            }
        } else {
            data.put("playerName", cache.player);
            file = new File(dir, cache.player.getUniqueId() + ".yml");
            if (file.exists()) {
                file.delete();
            }
        }
        YamlConfiguration config = new YamlConfiguration();
        ConfigurationSection useTimesSection = config.createSection("useTimes");
        Map<ObjectItem, ObjectUseTimesCache> tempVal1 = cache.getUseTimesCache();
        for (ObjectItem tempVal4 : tempVal1.keySet()) {
            data.clear();
            ConfigurationSection tempVal5 = useTimesSection.getConfigurationSection(tempVal4.getShop());
            if (tempVal5 == null) {
                tempVal5 = useTimesSection.createSection(tempVal4.getShop());
            }
            ConfigurationSection tempVal6 = tempVal5.getConfigurationSection(tempVal4.getProduct());
            if (tempVal1.get(tempVal4).getBuyUseTimes() != 0) {
                data.put("buyUseTimes", tempVal1.get(tempVal4).getBuyUseTimes());
            }
            if (tempVal1.get(tempVal4).getSellUseTimes() != 0) {
                data.put("sellUseTimes", tempVal1.get(tempVal4).getSellUseTimes());
            }
            if (tempVal1.get(tempVal4).getBuyRefreshTime() != null) {
                data.put("lastBuyTime", tempVal1.get(tempVal4).getLastBuyTime());
            }
            if (tempVal1.get(tempVal4).getSellRefreshTime() != null) {
                data.put("lastSellTime", tempVal1.get(tempVal4).getLastSellTime());
            }
            if (!cache.server && tempVal1.get(tempVal4).getCooldownBuyTime() != null) {
                data.put("cooldownBuyTime", tempVal1.get(tempVal4).getCooldownBuyTime());
            }
            if (!cache.server && tempVal1.get(tempVal4).getCooldownSellTime() != null) {
                data.put("cooldownSellTime", tempVal1.get(tempVal4).getCooldownSellTime());
            }
            for (String key : data.keySet()) {
                if (tempVal6 == null) {
                    tempVal6 = tempVal5.createSection(tempVal4.getProduct());
                }
                tempVal6.set(key, data.get(key));
            }
        }
        if (cache.server) {
            ConfigurationSection randomPlaceholderSection = config.createSection("randomPlaceholder");
            Collection<ObjectRandomPlaceholderCache> tempVal7 = cache.getRandomPlaceholderCache().values();
            for (ObjectRandomPlaceholderCache tempVal8 : tempVal7) {
                data.clear();
                ConfigurationSection tempVal9 = randomPlaceholderSection.getConfigurationSection(tempVal8.getPlaceholder().getID());
                if (tempVal9 == null) {
                    tempVal9 = randomPlaceholderSection.createSection(tempVal8.getPlaceholder().getID());
                }
                if (tempVal8.getPlaceholder().getMode().equals("TIMED") || tempVal8.getPlaceholder().getMode().equals("TIMER")) {
                    data.put("nowValue", tempVal8.getNowValue(true));
                    data.put("refreshDoneTime", CommonUtil.timeToString(tempVal8.getRefreshDoneTime()));
                }
                for (String string : data.keySet()) {
                }
            }
        }
        if (quitServer) {
            CacheManager.cacheManager.removePlayerCache(cache.player);
        }
        try {
            if (needDelete) {
                file.delete();
            }
            config.save(file);
        }
        catch (IOException e) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not save data file: " + file.getName() + "!");
        }
    }
}

